/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.servlet;

import java.io.BufferedReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    public static final String URL_PREFIX = "/ossWebhook";

    public static void successResponse(HttpServletResponse response, String contentType, String responseData) {
        response.setStatus(200);
        response.setContentType(contentType);
        try {
            response.getWriter().println(responseData);
            response.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void failureResponse(HttpServletResponse response, int statusCode, String jsonMessage) {
        response.setStatus(statusCode);
        response.setContentType("application/json");
        try {
            response.getWriter().println("{\"success\":false,\n\"error\":\"" + jsonMessage + "\"}");
            response.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getEndpointPath(HttpServletRequest request) {
        String endpointPath = request.getRequestURI().trim();
        if ((endpointPath = endpointPath.replaceAll("/+", "/")).startsWith(URL_PREFIX)) {
            endpointPath = endpointPath.substring(URL_PREFIX.length());
        }
        if (endpointPath.startsWith("/")) {
            endpointPath = endpointPath.substring(1);
        }
        if (endpointPath.endsWith("/")) {
            endpointPath = endpointPath.substring(0, endpointPath.length() - 1);
        }
        return endpointPath;
    }

    public static String getRequestBody(HttpServletRequest request, int maxBodySize) {
        StringBuilder requestBody = new StringBuilder();
        try {
            int currentChar;
            BufferedReader reader = request.getReader();
            while ((currentChar = reader.read()) >= 0) {
                requestBody.append((char)(currentChar & 0xFF));
                if (requestBody.length() < maxBodySize) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestBody.toString();
    }
}

