/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.servlet;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.endpoint.BEndpoint;
import solutions.onesight.ossWebhook.license.OssWebhookLicense;
import solutions.onesight.ossWebhook.log.OssModuleLog;
import solutions.onesight.ossWebhook.service.BOssWebhookService;
import solutions.onesight.ossWebhook.servlet.EndpointAuth;
import solutions.onesight.ossWebhook.servlet.ServletUtils;

public class ServletRequest {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processRequest(HttpServletRequest request, HttpServletResponse response, boolean postRequest) {
        BOssWebhookService service = null;
        try {
            service = (BOssWebhookService)Sys.getService((Type)BOssWebhookService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (service == null) {
            OssModuleLog.debug("OssWebhookService not found");
            ServletUtils.failureResponse(response, 400, "OssWebhookService not found");
            return;
        }
        if (!OssWebhookLicense.isLicensed()) {
            OssModuleLog.debug("ossWebhook is not licensed");
            ServletUtils.failureResponse(response, 400, "ossWebhook is not licensed");
            return;
        }
        if (!service.getStatus().isOk()) {
            service.debugMsg("OssWebhookService fault: " + service.getFaultCause());
            ServletUtils.failureResponse(response, 400, "OssWebhookService fault");
            return;
        }
        if (!service.getEnabled()) {
            service.debugMsg("OssWebhookService disabled");
            ServletUtils.failureResponse(response, 400, "OssWebhookService disabled");
            return;
        }
        String endpointPath = ServletUtils.getEndpointPath(request);
        if (endpointPath.isEmpty()) {
            service.debugMsg("Request missing endpoint");
            ServletUtils.failureResponse(response, 400, "Missing endpoint");
            return;
        }
        service.debugMsg("Endpoint path: " + endpointPath);
        BEndpoint endpoint = ServletRequest.retrieveEndpoint(service, endpointPath);
        if (endpoint == null) {
            service.debugMsg("Request endpoint not found: " + endpointPath);
            ServletUtils.failureResponse(response, 404, "Endpoint not found");
            return;
        }
        if (!endpoint.getEnabled() || !endpoint.getGetEnabled() && !endpoint.getPostEnabled()) {
            service.debugMsg("Request endpoint disabled: " + endpointPath);
            ServletUtils.failureResponse(response, 400, "Endpoint disabled");
            return;
        }
        String postData = ServletUtils.getRequestBody(request, endpoint.getMaxPostSize());
        if (!EndpointAuth.checkAuth(service, request, response, endpoint, postData)) {
            service.debugMsg("Request auth failed for endpoint: " + endpointPath);
            ServletUtils.failureResponse(response, 401, "Unauthorized");
            return;
        }
        if (postRequest) {
            if (!endpoint.getPostEnabled()) {
                service.debugMsg("POST invalid for endpoint: " + endpointPath);
                ServletUtils.failureResponse(response, 405, "POST invalid");
                return;
            }
            endpoint.setPostData(postData);
            String contentType = request.getContentType();
            if (contentType != null) {
                endpoint.setPostContentType(contentType);
            } else {
                endpoint.setPostContentType("");
            }
            if (endpoint.getDebugEnabled()) {
                OssModuleLog.debug("[" + endpoint.getName() + "] POST(" + postData.length() + "): " + postData);
            }
        } else if (!endpoint.getGetEnabled()) {
            service.debugMsg("GET invalid for endpoint: " + endpointPath);
            ServletUtils.failureResponse(response, 405, "GET invalid");
            return;
        }
        String responseData = endpoint.getResponseData();
        ServletUtils.successResponse(response, endpoint.getResponseContentType(), responseData);
        if (endpoint.getDebugEnabled()) {
            OssModuleLog.debug("[" + endpoint.getName() + "] RESPONSE(" + responseData.length() + "): " + responseData);
        }
        endpoint.setLastRequestTime(BAbsTime.now());
        endpoint.fireRequestReceived(BBoolean.TRUE);
        service.setLastRequestTime(BAbsTime.now());
    }

    public static BEndpoint retrieveEndpoint(BOssWebhookService service, String endpointUrlPath) {
        BEndpoint foundEndpoint;
        block8: {
            foundEndpoint = null;
            if (service.getEnabled()) {
                try {
                    String decodedUrlPath = URLDecoder.decode(endpointUrlPath, StandardCharsets.UTF_8.toString());
                    String[] pathElements = decodedUrlPath.split("/+");
                    StringBuilder escapedPath = new StringBuilder();
                    for (String pathItem : pathElements) {
                        if (pathItem.isEmpty()) continue;
                        escapedPath.append("/");
                        escapedPath.append(SlotPath.escape((String)pathItem).trim());
                    }
                    if (escapedPath.length() <= 0) break block8;
                    BOrd endpointOrd = BOrd.make((String)(service.getEndpoints().getSlotPath() + escapedPath.toString()));
                    BObject endpointNode = null;
                    try {
                        endpointNode = endpointOrd.get((BObject)service.getEndpoints());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (endpointNode instanceof BEndpoint) {
                        foundEndpoint = (BEndpoint)endpointNode;
                    }
                }
                catch (Exception endpointException) {
                    OssModuleLog.error("Exception resolving endpoint: " + endpointUrlPath);
                    endpointException.printStackTrace();
                }
            } else {
                OssModuleLog.debug("Service disabled [endpoint: " + endpointUrlPath + "]");
            }
        }
        return foundEndpoint;
    }
}

