/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.service;

import javax.baja.data.BIDataValue;
import javax.baja.driver.BDriverContainer;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.endpoint.BEndpointFolder;
import solutions.onesight.ossWebhook.license.OssWebhookLicense;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authentication", type="BAuthCredsFolder", defaultValue="new BAuthCredsFolder()"), @NiagaraProperty(name="endpoints", type="BEndpointFolder", defaultValue="new BEndpointFolder()"), @NiagaraProperty(name="lastRequestTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=65604)})
public final class BOssWebhookService
extends BAbstractService {
    public static final Property authentication = BOssWebhookService.newProperty((int)0, (BValue)new BAuthCredsFolder(), null);
    public static final Property endpoints = BOssWebhookService.newProperty((int)0, (BValue)new BEndpointFolder(), null);
    public static final Property lastRequestTime = BOssWebhookService.newProperty((int)65, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property debugEnabled = BOssWebhookService.newProperty((int)65604, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BOssWebhookService.class);
    public static final String INVALID_PARENT_ERROR = "OssWebhookService must be placed in the services container";

    public BAuthCredsFolder getAuthentication() {
        return (BAuthCredsFolder)this.get(authentication);
    }

    public void setAuthentication(BAuthCredsFolder v) {
        this.set(authentication, (BValue)v, null);
    }

    public BEndpointFolder getEndpoints() {
        return (BEndpointFolder)this.get(endpoints);
    }

    public void setEndpoints(BEndpointFolder v) {
        this.set(endpoints, (BValue)v, null);
    }

    public BAbsTime getLastRequestTime() {
        return (BAbsTime)this.get(lastRequestTime);
    }

    public void setLastRequestTime(BAbsTime v) {
        this.set(lastRequestTime, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() {
        if (!OssWebhookLicense.checkLicense()) {
            this.setFacets((Slot)faultCause, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)40)));
            this.configFatal("ossWebhook is not licensed");
            OssModuleLog.error("ossWebhook is not licensed");
            throw new LicenseException("ossWebhook is not licensed");
        }
        if (!(this.getParent() instanceof BServiceContainer) && !(this.getParent() instanceof BDriverContainer)) {
            this.setFacets((Slot)faultCause, BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
            this.configFatal(INVALID_PARENT_ERROR);
            OssModuleLog.error(INVALID_PARENT_ERROR);
            throw new BajaRuntimeException("Invalid OssWebhookService parent");
        }
        this.configOk();
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
    }

    public void changed(Property property, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            OssModuleLog.debug(debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossWebhook/icons/oss-icon.png");
    }
}

