/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.auth.BAuthGroup;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="headerName", type="String", defaultValue="new String( \"X-Signature\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="hashAlgorithm", type="BEnum", defaultValue="BDynamicEnum.make( 0, BEnumRange.make( new int[]{ 0, 1, 2, 3, 4 }, new String[]{ \"HmacSHA256\", \"HmacSHA512\", \"HmacSHA384\", \"HmacSHA1\", \"HmacMD5\" } ) )"), @NiagaraProperty(name="secretKey", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="enableExpiry", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiry", type="BAbsTime", defaultValue="BAbsTime.make( 2050, BMonth.january, 1 )")})
public final class BAuthHmac
extends BAuthCreds {
    public static final Property enabled = BAuthHmac.newProperty((int)0, (boolean)true, null);
    public static final Property headerName = BAuthHmac.newProperty((int)0, (String)new String("X-Signature"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property hashAlgorithm = BAuthHmac.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4}, (String[])new String[]{"HmacSHA256", "HmacSHA512", "HmacSHA384", "HmacSHA1", "HmacMD5"})), null);
    public static final Property secretKey = BAuthHmac.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property enableExpiry = BAuthHmac.newProperty((int)0, (boolean)false, null);
    public static final Property expiry = BAuthHmac.newProperty((int)0, (BValue)BAbsTime.make((int)2050, (BMonth)BMonth.january, (int)1), null);
    public static final Type TYPE = Sys.loadType(BAuthHmac.class);
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] HASH_ALGORITHM_LIST = new String[]{"HmacSHA256", "HmacSHA512", "HmacSHA384", "HmacSHA1", "HmacMD5"};

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getHeaderName() {
        return this.getString(headerName);
    }

    public void setHeaderName(String v) {
        this.setString(headerName, v, null);
    }

    public BEnum getHashAlgorithm() {
        return (BEnum)this.get(hashAlgorithm);
    }

    public void setHashAlgorithm(BEnum v) {
        this.set(hashAlgorithm, (BValue)v, null);
    }

    public String getSecretKey() {
        return this.getString(secretKey);
    }

    public void setSecretKey(String v) {
        this.setString(secretKey, v, null);
    }

    public boolean getEnableExpiry() {
        return this.getBoolean(enableExpiry);
    }

    public void setEnableExpiry(boolean v) {
        this.setBoolean(enableExpiry, v, null);
    }

    public BAbsTime getExpiry() {
        return (BAbsTime)this.get(expiry);
    }

    public void setExpiry(BAbsTime v) {
        this.set(expiry, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BAuthCredsFolder) && !(this.getParent() instanceof BAuthGroup)) {
            this.setFlags((Slot)enabled, 1);
            this.setFlags((Slot)headerName, 1);
            this.setFlags((Slot)hashAlgorithm, 1);
            this.setFlags((Slot)secretKey, 1);
            this.setFlags((Slot)enableExpiry, 1);
            this.setEnabled(false);
            OssModuleLog.error("AuthHmac parent must be service authentication folder: " + this.getSlotPath());
            throw new BajaRuntimeException("ossWebhook AuthHmac parent must be service authentication folder");
        }
        if ((this.getFlags((Slot)enabled) & 1) != 0) {
            this.setFlags((Slot)enabled, 0);
            this.setFlags((Slot)headerName, 0);
            this.setFlags((Slot)hashAlgorithm, 0);
            this.setFlags((Slot)secretKey, 0);
            this.setFlags((Slot)enableExpiry, 0);
            this.setEnabled(true);
        }
    }

    @Override
    public boolean checkAuth(HttpServletRequest request, HttpServletResponse response, String postData) {
        boolean validAuth = false;
        if (this.getEnabled()) {
            try {
                String httpHeaderName = this.getHeaderName().trim();
                if (!httpHeaderName.isEmpty()) {
                    if (!this.getSecretKey().isEmpty()) {
                        if (this.getExpiry().isAfter(BAbsTime.now())) {
                            int algoOrdinal = this.getHashAlgorithm().getOrdinal();
                            if (algoOrdinal >= 0 && algoOrdinal < HASH_ALGORITHM_LIST.length) {
                                String expectedValue;
                                String authHeader = request.getHeader(httpHeaderName);
                                if (authHeader != null && (expectedValue = BAuthHmac.calculateHmac(postData, this.getSecretKey(), HASH_ALGORITHM_LIST[algoOrdinal])) != null && authHeader.toLowerCase().contentEquals(expectedValue)) {
                                    validAuth = true;
                                }
                            } else {
                                OssModuleLog.error("Auth [" + this.getName() + "] invalid hash algorithm");
                            }
                        } else {
                            OssModuleLog.debug("Auth [" + this.getName() + "] expired");
                        }
                    } else {
                        OssModuleLog.error("Auth [" + this.getName() + "] empty secret key");
                    }
                } else {
                    OssModuleLog.error("Auth [" + this.getName() + "] empty header name");
                }
            }
            catch (Exception authException) {
                OssModuleLog.debug("AuthHmac exception: " + authException);
            }
        }
        return validAuth;
    }

    public static String calculateHmac(String data, String key, String algorithm) {
        String result = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKeySpec);
            result = BAuthHmac.bytesToHex(mac.doFinal(data.getBytes()));
        }
        catch (Exception NoSuchAlgorithmException) {
            OssModuleLog.error("HMAC auth failed: Algorithm " + algorithm + " not supported");
        }
        return result;
    }

    public static String bytesToHex(byte[] byteArray) {
        char[] hexChars = new char[byteArray.length * 2];
        for (int byteIndex = 0; byteIndex < byteArray.length; ++byteIndex) {
            int byteValue = byteArray[byteIndex] & 0xFF;
            hexChars[byteIndex * 2] = HEX_ARRAY[byteValue >>> 4];
            hexChars[byteIndex * 2 + 1] = HEX_ARRAY[byteValue & 0xF];
        }
        return new String(hexChars);
    }

    @Override
    public String expirySummary() {
        if (this.getEnableExpiry()) {
            return this.getExpiry().toString(null);
        }
        return "Never";
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

