/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.auth.BAuthApiKey;
import solutions.onesight.ossWebhook.auth.BAuthBasic;
import solutions.onesight.ossWebhook.auth.BAuthBearerToken;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.auth.BAuthHmac;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addBasicAuth", parameterType="BString", defaultValue="BString.make(\"BasicAuth\")"), @NiagaraAction(name="addApiKeyAuth", parameterType="BString", defaultValue="BString.make(\"ApiKeyAuth\")"), @NiagaraAction(name="addBearerTokenAuth", parameterType="BString", defaultValue="BString.make(\"BearerTokenAuth\")"), @NiagaraAction(name="addHmacAuth", parameterType="BString", defaultValue="BString.make(\"HmacAuth\")"), @NiagaraAction(name="addAuthGroup", parameterType="BString", defaultValue="BString.make(\"AuthGroup\")")})
public final class BAuthGroup
extends BAuthCreds {
    public static final Action addBasicAuth = BAuthGroup.newAction((int)0, (BValue)BString.make((String)"BasicAuth"), null);
    public static final Action addApiKeyAuth = BAuthGroup.newAction((int)0, (BValue)BString.make((String)"ApiKeyAuth"), null);
    public static final Action addBearerTokenAuth = BAuthGroup.newAction((int)0, (BValue)BString.make((String)"BearerTokenAuth"), null);
    public static final Action addHmacAuth = BAuthGroup.newAction((int)0, (BValue)BString.make((String)"HmacAuth"), null);
    public static final Action addAuthGroup = BAuthGroup.newAction((int)0, (BValue)BString.make((String)"AuthGroup"), null);
    public static final Type TYPE = Sys.loadType(BAuthGroup.class);

    public void addBasicAuth(BString parameter) {
        this.invoke(addBasicAuth, (BValue)parameter, null);
    }

    public void addApiKeyAuth(BString parameter) {
        this.invoke(addApiKeyAuth, (BValue)parameter, null);
    }

    public void addBearerTokenAuth(BString parameter) {
        this.invoke(addBearerTokenAuth, (BValue)parameter, null);
    }

    public void addHmacAuth(BString parameter) {
        this.invoke(addHmacAuth, (BValue)parameter, null);
    }

    public void addAuthGroup(BString parameter) {
        this.invoke(addAuthGroup, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BAuthCredsFolder)) {
            OssModuleLog.error("AuthGroup parent must be service authentication folder: " + this.getSlotPath());
            throw new BajaRuntimeException("ossWebhook AuthGroup parent must be service authentication folder");
        }
    }

    public void doAddBasicAuth(BString authName) {
        this.add(authName.getString() + "?", (BValue)new BAuthBasic());
    }

    public void doAddApiKeyAuth(BString authName) {
        this.add(authName.getString() + "?", (BValue)new BAuthApiKey());
    }

    public void doAddBearerTokenAuth(BString authName) {
        this.add(authName.getString() + "?", (BValue)new BAuthBearerToken());
    }

    public void doAddHmacAuth(BString authName) {
        this.add(authName.getString() + "?", (BValue)new BAuthHmac());
    }

    public void doAddAuthGroup(BString authName) {
        this.add(authName.getString() + "?", (BValue)new BAuthGroup());
    }

    @Override
    public boolean checkAuth(HttpServletRequest request, HttpServletResponse response, String postData) {
        boolean validAuth = false;
        for (BAuthCreds credsItem : (BAuthCreds[])this.getChildren(BAuthCreds.class)) {
            if (!credsItem.checkAuth(request, response, postData)) continue;
            validAuth = true;
            break;
        }
        return validAuth;
    }

    @Override
    public String expirySummary() {
        return "N/A";
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

