/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.auth.BAuthGroup;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="tokenValue", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="realm", type="String", defaultValue="ossWebhook", flags=4, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)")}), @NiagaraProperty(name="enableExpiry", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiry", type="BAbsTime", defaultValue="BAbsTime.make( 2050, BMonth.january, 1 )")})
public final class BAuthBearerToken
extends BAuthCreds {
    public static final Property enabled = BAuthBearerToken.newProperty((int)0, (boolean)true, null);
    public static final Property tokenValue = BAuthBearerToken.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property realm = BAuthBearerToken.newProperty((int)4, (String)"ossWebhook", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)));
    public static final Property enableExpiry = BAuthBearerToken.newProperty((int)0, (boolean)false, null);
    public static final Property expiry = BAuthBearerToken.newProperty((int)0, (BValue)BAbsTime.make((int)2050, (BMonth)BMonth.january, (int)1), null);
    public static final Type TYPE = Sys.loadType(BAuthBearerToken.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getTokenValue() {
        return this.getString(tokenValue);
    }

    public void setTokenValue(String v) {
        this.setString(tokenValue, v, null);
    }

    public String getRealm() {
        return this.getString(realm);
    }

    public void setRealm(String v) {
        this.setString(realm, v, null);
    }

    public boolean getEnableExpiry() {
        return this.getBoolean(enableExpiry);
    }

    public void setEnableExpiry(boolean v) {
        this.setBoolean(enableExpiry, v, null);
    }

    public BAbsTime getExpiry() {
        return (BAbsTime)this.get(expiry);
    }

    public void setExpiry(BAbsTime v) {
        this.set(expiry, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BAuthCredsFolder) && !(this.getParent() instanceof BAuthGroup)) {
            this.setFlags((Slot)enabled, 1);
            this.setFlags((Slot)tokenValue, 1);
            this.setFlags((Slot)realm, this.getFlags((Slot)realm) | 1);
            this.setFlags((Slot)enableExpiry, 1);
            this.setEnabled(false);
            OssModuleLog.error("AuthBearerToken parent must be service authentication folder: " + this.getSlotPath());
            throw new BajaRuntimeException("ossWebhook AuthBearerToken parent must be service authentication folder");
        }
        if ((this.getFlags((Slot)enabled) & 1) != 0) {
            this.setFlags((Slot)enabled, 0);
            this.setFlags((Slot)tokenValue, 0);
            this.setFlags((Slot)realm, this.getFlags((Slot)realm) & 0xFFFFFFFE);
            this.setFlags((Slot)enableExpiry, 0);
            this.setEnabled(true);
        }
    }

    @Override
    public boolean checkAuth(HttpServletRequest request, HttpServletResponse response, String postData) {
        boolean validAuth = false;
        String errorDetails = "";
        if (this.getEnabled()) {
            try {
                if (this.getExpiry().isAfter(BAbsTime.now())) {
                    String authHeader = request.getHeader("Authorization");
                    if (authHeader != null) {
                        String prefix;
                        errorDetails = ", error=\"invalid_token\", error_description=\"Token malformed\"";
                        if (authHeader.length() > 8 && (prefix = authHeader.substring(0, 7).toLowerCase()).contentEquals("bearer ") && !(validAuth = authHeader.substring(6).trim().contentEquals(this.getTokenValue()))) {
                            errorDetails = ", error=\"invalid_token\", error_description=\"Token not valid\"";
                        }
                    }
                } else {
                    OssModuleLog.debug("Auth [" + this.getName() + "] expired");
                }
            }
            catch (Exception authException) {
                OssModuleLog.debug("AuthBearerToken exception: " + authException);
            }
        }
        if (!validAuth) {
            response.setHeader("WWW-Authenticate", "Bearer realm=\"" + this.getRealm() + "\"" + errorDetails);
        }
        return validAuth;
    }

    @Override
    public String expirySummary() {
        if (this.getEnableExpiry()) {
            return this.getExpiry().toString(null);
        }
        return "Never";
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

