/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Base64;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.auth.BAuthGroup;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="username", type="String", defaultValue="", flags=64, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)")}), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=64, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)")}), @NiagaraProperty(name="realm", type="String", defaultValue="ossWebhook", flags=4, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(20)")}), @NiagaraProperty(name="enableExpiry", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiry", type="BAbsTime", defaultValue="BAbsTime.make( 2050, BMonth.january, 1 )")})
public final class BAuthBasic
extends BAuthCreds {
    public static final Property enabled = BAuthBasic.newProperty((int)0, (boolean)true, null);
    public static final Property username = BAuthBasic.newProperty((int)64, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)));
    public static final Property password = BAuthBasic.newProperty((int)64, (BValue)BPassword.DEFAULT, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)));
    public static final Property realm = BAuthBasic.newProperty((int)4, (String)"ossWebhook", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)20)));
    public static final Property enableExpiry = BAuthBasic.newProperty((int)0, (boolean)false, null);
    public static final Property expiry = BAuthBasic.newProperty((int)0, (BValue)BAbsTime.make((int)2050, (BMonth)BMonth.january, (int)1), null);
    public static final Type TYPE = Sys.loadType(BAuthBasic.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public String getRealm() {
        return this.getString(realm);
    }

    public void setRealm(String v) {
        this.setString(realm, v, null);
    }

    public boolean getEnableExpiry() {
        return this.getBoolean(enableExpiry);
    }

    public void setEnableExpiry(boolean v) {
        this.setBoolean(enableExpiry, v, null);
    }

    public BAbsTime getExpiry() {
        return (BAbsTime)this.get(expiry);
    }

    public void setExpiry(BAbsTime v) {
        this.set(expiry, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BAuthCredsFolder) && !(this.getParent() instanceof BAuthGroup)) {
            this.setFlags((Slot)enabled, 1);
            this.setFlags((Slot)username, 1);
            this.setFlags((Slot)password, 1);
            this.setFlags((Slot)realm, this.getFlags((Slot)realm) | 1);
            this.setFlags((Slot)enableExpiry, 1);
            this.setEnabled(false);
            OssModuleLog.error("AuthBasic parent must be service authentication folder: " + this.getSlotPath());
            throw new BajaRuntimeException("ossWebhook AuthBasic parent must be service authentication folder");
        }
        if ((this.getFlags((Slot)enabled) & 1) != 0) {
            this.setFlags((Slot)enabled, 0);
            this.setFlags((Slot)username, 64);
            this.setFlags((Slot)password, 64);
            this.setFlags((Slot)realm, this.getFlags((Slot)realm) & 0xFFFFFFFE);
            this.setFlags((Slot)enableExpiry, 0);
            this.setEnabled(true);
        }
    }

    @Override
    public boolean checkAuth(HttpServletRequest request, HttpServletResponse response, String postData) {
        boolean validAuth = false;
        if (this.getEnabled()) {
            try {
                if (this.getExpiry().isAfter(BAbsTime.now())) {
                    String prefix;
                    String authHeader = request.getHeader("Authorization");
                    if (authHeader != null && authHeader.length() > 7 && (prefix = authHeader.substring(0, 6).toLowerCase()).contentEquals("basic ")) {
                        validAuth = this.compareCreds(authHeader.substring(6).trim());
                    }
                } else {
                    OssModuleLog.debug("Auth [" + this.getName() + "] expired");
                }
            }
            catch (Exception authException) {
                OssModuleLog.debug("BasicAuth exception: " + authException);
            }
        }
        if (!validAuth) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\", charset=\"UTF-8\"");
        }
        return validAuth;
    }

    public boolean compareCreds(String encodedCreds) {
        boolean credsMatch = false;
        try {
            String decodedCreds = new String(Base64.getDecoder().decode(encodedCreds));
            String validCreds = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return BAuthBasic.this.getUsername().trim() + ":" + BAuthBasic.this.getPassword().getValue();
                }
            });
            credsMatch = decodedCreds.contentEquals(validCreds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credsMatch;
    }

    @Override
    public String expirySummary() {
        if (this.getEnableExpiry()) {
            return this.getExpiry().toString(null);
        }
        return "Never";
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

