/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossWebhook.auth;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import solutions.onesight.ossWebhook.auth.BAuthCreds;
import solutions.onesight.ossWebhook.auth.BAuthCredsFolder;
import solutions.onesight.ossWebhook.auth.BAuthGroup;
import solutions.onesight.ossWebhook.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="keyName", type="String", defaultValue="new String( \"X-API-KEY\" )", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="keyValue", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(80)")}), @NiagaraProperty(name="allowHttpHeader", type="boolean", defaultValue="true"), @NiagaraProperty(name="allowUrlParam", type="boolean", defaultValue="true"), @NiagaraProperty(name="enableExpiry", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiry", type="BAbsTime", defaultValue="BAbsTime.make( 2050, BMonth.january, 1 )")})
public final class BAuthApiKey
extends BAuthCreds {
    public static final Property enabled = BAuthApiKey.newProperty((int)0, (boolean)true, null);
    public static final Property keyName = BAuthApiKey.newProperty((int)0, (String)new String("X-API-KEY"), (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property keyValue = BAuthApiKey.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)80)));
    public static final Property allowHttpHeader = BAuthApiKey.newProperty((int)0, (boolean)true, null);
    public static final Property allowUrlParam = BAuthApiKey.newProperty((int)0, (boolean)true, null);
    public static final Property enableExpiry = BAuthApiKey.newProperty((int)0, (boolean)false, null);
    public static final Property expiry = BAuthApiKey.newProperty((int)0, (BValue)BAbsTime.make((int)2050, (BMonth)BMonth.january, (int)1), null);
    public static final Type TYPE = Sys.loadType(BAuthApiKey.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getKeyName() {
        return this.getString(keyName);
    }

    public void setKeyName(String v) {
        this.setString(keyName, v, null);
    }

    public String getKeyValue() {
        return this.getString(keyValue);
    }

    public void setKeyValue(String v) {
        this.setString(keyValue, v, null);
    }

    public boolean getAllowHttpHeader() {
        return this.getBoolean(allowHttpHeader);
    }

    public void setAllowHttpHeader(boolean v) {
        this.setBoolean(allowHttpHeader, v, null);
    }

    public boolean getAllowUrlParam() {
        return this.getBoolean(allowUrlParam);
    }

    public void setAllowUrlParam(boolean v) {
        this.setBoolean(allowUrlParam, v, null);
    }

    public boolean getEnableExpiry() {
        return this.getBoolean(enableExpiry);
    }

    public void setEnableExpiry(boolean v) {
        this.setBoolean(enableExpiry, v, null);
    }

    public BAbsTime getExpiry() {
        return (BAbsTime)this.get(expiry);
    }

    public void setExpiry(BAbsTime v) {
        this.set(expiry, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BAuthCredsFolder) && !(this.getParent() instanceof BAuthGroup)) {
            this.setFlags((Slot)enabled, 1);
            this.setFlags((Slot)keyValue, 1);
            this.setFlags((Slot)keyName, 1);
            this.setFlags((Slot)allowHttpHeader, 1);
            this.setFlags((Slot)allowUrlParam, 1);
            this.setFlags((Slot)enableExpiry, 1);
            this.setEnabled(false);
            OssModuleLog.error("AuthApiKey parent must be service authentication folder: " + this.getSlotPath());
            throw new BajaRuntimeException("ossWebhook AuthApiKey parent must be service authentication folder");
        }
        if ((this.getFlags((Slot)enabled) & 1) != 0) {
            this.setFlags((Slot)enabled, 0);
            this.setFlags((Slot)keyValue, 0);
            this.setFlags((Slot)allowHttpHeader, 0);
            this.setFlags((Slot)allowUrlParam, 0);
            this.setFlags((Slot)keyName, 0);
            this.setFlags((Slot)enableExpiry, 0);
            this.setEnabled(true);
        }
    }

    @Override
    public boolean checkAuth(HttpServletRequest request, HttpServletResponse response, String postData) {
        boolean validAuth = false;
        if (this.getEnabled()) {
            try {
                String apiKeyName = this.getKeyName().trim();
                if (!apiKeyName.isEmpty()) {
                    if (this.getExpiry().isAfter(BAbsTime.now())) {
                        String queryStr;
                        String authHeader;
                        if (this.getAllowHttpHeader() && (authHeader = request.getHeader(apiKeyName)) != null) {
                            validAuth = authHeader.trim().contentEquals(this.getKeyValue().trim());
                        }
                        if (!validAuth && this.getAllowUrlParam() && (queryStr = request.getQueryString()) != null && !queryStr.isEmpty()) {
                            String[] paramList = queryStr.split("&");
                            String searchStr = apiKeyName + "=";
                            for (String paramItem : paramList) {
                                if (!paramItem.startsWith(searchStr)) continue;
                                validAuth = paramItem.substring(searchStr.length()).contentEquals(this.getKeyValue());
                            }
                        }
                    } else {
                        OssModuleLog.debug("Auth [" + this.getName() + "] expired");
                    }
                } else {
                    OssModuleLog.error("Auth [" + this.getName() + "] empty key name");
                }
            }
            catch (Exception authException) {
                OssModuleLog.debug("AuthApiKey exception: " + authException);
            }
        }
        return validAuth;
    }

    @Override
    public String expirySummary() {
        if (this.getEnableExpiry()) {
            return this.getExpiry().toString(null);
        }
        return "Never";
    }

    @Override
    public BIcon getIcon() {
        return BIcon.std((String)"securityHigh.png");
    }
}

