/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossTeltonikaSms.license;

import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;

public class OssTeltonikaSmsLicense {
    private static boolean licensed = false;
    private static boolean licenseAlertsUnlimited = false;
    private static int licenseAlertsLimit = 0;
    public static final String LICENSE_ERROR = "ossTeltonikaSms is not licensed";
    public static final String LICENSE_LIMIT_ERROR = "ossTeltonikaSms licence limit exceeded";
    private static final String LICENSE_LIMIT = "alertLimit";
    public static final String LICENSE_VENDOR = "OneSightSolutions";
    public static final String LICENSE_FEATURE = "ossTeltonikaSms";

    public static boolean checkLicense() throws FeatureNotLicensedException {
        licensed = false;
        licenseAlertsUnlimited = true;
        licenseAlertsLimit = 0;
        try {
            Feature licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            if (licenseFeature != null) {
                licensed = true;
                String limitProperty = licenseFeature.get(LICENSE_LIMIT, "");
                if (limitProperty != null && !limitProperty.isEmpty()) {
                    if (limitProperty.equals("none")) {
                        licenseAlertsUnlimited = true;
                    } else {
                        licenseAlertsLimit = licenseFeature.geti(LICENSE_LIMIT, 0);
                    }
                }
            }
        }
        catch (LicenseException licEx) {
            licensed = false;
        }
        return licensed;
    }

    public static boolean isLicensed() {
        return licensed;
    }
}

