/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossTeltonikaSms.alarm;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import solutions.onesight.ossTeltonikaSms.alarm.BRecipientType;
import solutions.onesight.ossTeltonikaSms.license.OssTeltonikaSmsLicense;
import solutions.onesight.ossTeltonikaSms.log.OssModuleLog;
import solutions.onesight.ossTeltonikaSms.request.HttpRequest;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="Output", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="teltonikaSmsUrl", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="teltonikaUser", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="teltonikaPassword", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="teltonikaModem", type="String", defaultValue=""), @NiagaraProperty(name="recipientType", type="BRecipientType", defaultValue="BRecipientType.Single", flags=4), @NiagaraProperty(name="telephoneNumber", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="groupName", type="String", defaultValue="", flags=4, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="normalTextFormat", type="String", defaultValue="\"Alarm: Normal\\nSource: %alarmSourceName%\\nMessage Text: %alarmMessageText%\\nAlarm Class: %alarmClass%\\nTimestamp: %alarmTimestamp%\"", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)"), @Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)")}), @NiagaraProperty(name="alarmTextFormat", type="String", defaultValue="\"Alarm: Offnormal\\nSource: %alarmSourceName%\\nMessage Text: %alarmMessageText%\\nAlarm Class: %alarmClass%\\nTimestamp: %alarmTimestamp%\"", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)"), @Facet(name="BFacets.MULTI_LINE", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="alarmSource", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="alarmState", type="BSourceState", defaultValue="BSourceState.normal", flags=1), @NiagaraProperty(name="alarmAckState", type="BAckState", defaultValue="BAckState.DEFAULT", flags=1), @NiagaraProperty(name="alarmSourceName", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmMessageText", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmPriority", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="alarmClass", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="alarmRecordCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="lastTeltonikaAuthTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="teltonikaAuthResponse", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="teltonikaApiResponse", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="teltonikaApiError", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="lastTeltonikaApiTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="readTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=65604), @NiagaraProperty(name="useOldApi", type="boolean", defaultValue="false", flags=65604)})
@NiagaraActions(value={@NiagaraAction(name="reset"), @NiagaraAction(name="sendRequest", parameterType="BString", defaultValue="BString.DEFAULT", flags=4)})
@NiagaraTopic(name="alarmTrigger", eventType="BBoolean")
public final class BOssTeltonikaAlarmRecipient
extends BAlarmRecipient {
    public static final Property enabled = BOssTeltonikaAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssTeltonikaAlarmRecipient.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssTeltonikaAlarmRecipient.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property Output = BOssTeltonikaAlarmRecipient.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property teltonikaSmsUrl = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property teltonikaUser = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property teltonikaPassword = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property teltonikaModem = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"", null);
    public static final Property recipientType = BOssTeltonikaAlarmRecipient.newProperty((int)4, (BValue)BRecipientType.Single, null);
    public static final Property telephoneNumber = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property groupName = BOssTeltonikaAlarmRecipient.newProperty((int)4, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property normalTextFormat = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"Alarm: Normal\nSource: %alarmSourceName%\nMessage Text: %alarmMessageText%\nAlarm Class: %alarmClass%\nTimestamp: %alarmTimestamp%", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true))));
    public static final Property alarmTextFormat = BOssTeltonikaAlarmRecipient.newProperty((int)0, (String)"Alarm: Offnormal\nSource: %alarmSourceName%\nMessage Text: %alarmMessageText%\nAlarm Class: %alarmClass%\nTimestamp: %alarmTimestamp%", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true))));
    public static final Property lastAlarmTime = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alarmSource = BOssTeltonikaAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmOrd = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property alarmState = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BSourceState.normal, null);
    public static final Property alarmAckState = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BAckState.DEFAULT, null);
    public static final Property alarmSourceName = BOssTeltonikaAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmMessageText = BOssTeltonikaAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmPriority = BOssTeltonikaAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property alarmClass = BOssTeltonikaAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmTimestamp = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alarmRecordCount = BOssTeltonikaAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property lastTeltonikaAuthTime = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property teltonikaAuthResponse = BOssTeltonikaAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property teltonikaApiResponse = BOssTeltonikaAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property teltonikaApiError = BOssTeltonikaAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property lastTeltonikaApiTime = BOssTeltonikaAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property connectTimeout = BOssTeltonikaAlarmRecipient.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property readTimeout = BOssTeltonikaAlarmRecipient.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property debugEnabled = BOssTeltonikaAlarmRecipient.newProperty((int)65604, (boolean)false, null);
    public static final Property useOldApi = BOssTeltonikaAlarmRecipient.newProperty((int)65604, (boolean)false, null);
    public static final Action reset = BOssTeltonikaAlarmRecipient.newAction((int)0, null);
    public static final Action sendRequest = BOssTeltonikaAlarmRecipient.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Topic alarmTrigger = BOssTeltonikaAlarmRecipient.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssTeltonikaAlarmRecipient.class);
    private boolean licenseAllocationValid = false;
    private String BEARER_TOKEN = "placeholder";
    private static final int MAX_RESPONSE_SIZE = 100000000;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getOutput() {
        return this.getString(Output);
    }

    public void setOutput(String v) {
        this.setString(Output, v, null);
    }

    public String getTeltonikaSmsUrl() {
        return this.getString(teltonikaSmsUrl);
    }

    public void setTeltonikaSmsUrl(String v) {
        this.setString(teltonikaSmsUrl, v, null);
    }

    public String getTeltonikaUser() {
        return this.getString(teltonikaUser);
    }

    public void setTeltonikaUser(String v) {
        this.setString(teltonikaUser, v, null);
    }

    public String getTeltonikaPassword() {
        return this.getString(teltonikaPassword);
    }

    public void setTeltonikaPassword(String v) {
        this.setString(teltonikaPassword, v, null);
    }

    public String getTeltonikaModem() {
        return this.getString(teltonikaModem);
    }

    public void setTeltonikaModem(String v) {
        this.setString(teltonikaModem, v, null);
    }

    public BRecipientType getRecipientType() {
        return (BRecipientType)this.get(recipientType);
    }

    public void setRecipientType(BRecipientType v) {
        this.set(recipientType, (BValue)v, null);
    }

    public String getTelephoneNumber() {
        return this.getString(telephoneNumber);
    }

    public void setTelephoneNumber(String v) {
        this.setString(telephoneNumber, v, null);
    }

    public String getGroupName() {
        return this.getString(groupName);
    }

    public void setGroupName(String v) {
        this.setString(groupName, v, null);
    }

    public String getNormalTextFormat() {
        return this.getString(normalTextFormat);
    }

    public void setNormalTextFormat(String v) {
        this.setString(normalTextFormat, v, null);
    }

    public String getAlarmTextFormat() {
        return this.getString(alarmTextFormat);
    }

    public void setAlarmTextFormat(String v) {
        this.setString(alarmTextFormat, v, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    public String getAlarmSource() {
        return this.getString(alarmSource);
    }

    public void setAlarmSource(String v) {
        this.setString(alarmSource, v, null);
    }

    public BOrd getAlarmOrd() {
        return (BOrd)this.get(alarmOrd);
    }

    public void setAlarmOrd(BOrd v) {
        this.set(alarmOrd, (BValue)v, null);
    }

    public BSourceState getAlarmState() {
        return (BSourceState)this.get(alarmState);
    }

    public void setAlarmState(BSourceState v) {
        this.set(alarmState, (BValue)v, null);
    }

    public BAckState getAlarmAckState() {
        return (BAckState)this.get(alarmAckState);
    }

    public void setAlarmAckState(BAckState v) {
        this.set(alarmAckState, (BValue)v, null);
    }

    public String getAlarmSourceName() {
        return this.getString(alarmSourceName);
    }

    public void setAlarmSourceName(String v) {
        this.setString(alarmSourceName, v, null);
    }

    public String getAlarmMessageText() {
        return this.getString(alarmMessageText);
    }

    public void setAlarmMessageText(String v) {
        this.setString(alarmMessageText, v, null);
    }

    public int getAlarmPriority() {
        return this.getInt(alarmPriority);
    }

    public void setAlarmPriority(int v) {
        this.setInt(alarmPriority, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BAbsTime getAlarmTimestamp() {
        return (BAbsTime)this.get(alarmTimestamp);
    }

    public void setAlarmTimestamp(BAbsTime v) {
        this.set(alarmTimestamp, (BValue)v, null);
    }

    public int getAlarmRecordCount() {
        return this.getInt(alarmRecordCount);
    }

    public void setAlarmRecordCount(int v) {
        this.setInt(alarmRecordCount, v, null);
    }

    public BAbsTime getLastTeltonikaAuthTime() {
        return (BAbsTime)this.get(lastTeltonikaAuthTime);
    }

    public void setLastTeltonikaAuthTime(BAbsTime v) {
        this.set(lastTeltonikaAuthTime, (BValue)v, null);
    }

    public int getTeltonikaAuthResponse() {
        return this.getInt(teltonikaAuthResponse);
    }

    public void setTeltonikaAuthResponse(int v) {
        this.setInt(teltonikaAuthResponse, v, null);
    }

    public int getTeltonikaApiResponse() {
        return this.getInt(teltonikaApiResponse);
    }

    public void setTeltonikaApiResponse(int v) {
        this.setInt(teltonikaApiResponse, v, null);
    }

    public String getTeltonikaApiError() {
        return this.getString(teltonikaApiError);
    }

    public void setTeltonikaApiError(String v) {
        this.setString(teltonikaApiError, v, null);
    }

    public BAbsTime getLastTeltonikaApiTime() {
        return (BAbsTime)this.get(lastTeltonikaApiTime);
    }

    public void setLastTeltonikaApiTime(BAbsTime v) {
        this.set(lastTeltonikaApiTime, (BValue)v, null);
    }

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getReadTimeout() {
        return this.getInt(readTimeout);
    }

    public void setReadTimeout(int v) {
        this.setInt(readTimeout, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public boolean getUseOldApi() {
        return this.getBoolean(useOldApi);
    }

    public void setUseOldApi(boolean v) {
        this.setBoolean(useOldApi, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void sendRequest(BString parameter) {
        this.invoke(sendRequest, (BValue)parameter, null);
    }

    public void fireAlarmTrigger(BBoolean event) {
        this.fire(alarmTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.licenseAllocationValid = false;
        if (!OssTeltonikaSmsLicense.checkLicense()) {
            this.setFault("ossTeltonikaSms is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void stopped() {
    }

    public void changed(Property property, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        if (this.checkLicense(false)) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
        if (property == recipientType) {
            if (this.getRecipientType().equals((Object)BRecipientType.Single)) {
                this.setFlags((Slot)telephoneNumber, 0);
                this.setFlags((Slot)groupName, 4);
            } else {
                this.setFlags((Slot)telephoneNumber, 4);
                this.setFlags((Slot)groupName, 0);
            }
        }
    }

    public void doReset() {
        this.setLastAlarmTime(BAbsTime.NULL);
        this.setAlarmSource("");
        this.setAlarmOrd(BOrd.NULL);
        this.setAlarmState(BSourceState.normal);
        this.setAlarmAckState(BAckState.DEFAULT);
        this.setAlarmSourceName("");
        this.setAlarmMessageText("");
        this.setAlarmPriority(0);
        this.setAlarmClass("");
        this.setAlarmTimestamp(BAbsTime.NULL);
        this.setAlarmRecordCount(0);
        this.setTeltonikaApiResponse(0);
        this.setTeltonikaApiError("");
        this.setLastTeltonikaApiTime(BAbsTime.NULL);
    }

    public void handleAlarm(BAlarmRecord alarmRecord) {
        if (this.checkLicense(true)) {
            return;
        }
        if (!this.getEnabled()) {
            this.debugMsg("Disabled");
            return;
        }
        if (this.getTeltonikaSmsUrl().trim().isEmpty()) {
            this.setFault("Teltonika SMS URL is not set");
            return;
        }
        this.setLastAlarmTime(alarmRecord.getTimestamp());
        this.setAlarmSource(this.simplifySource(alarmRecord.getSource().get(0)));
        this.setAlarmOrd(alarmRecord.getSource().get(0));
        this.setAlarmState(alarmRecord.getSourceState());
        this.setAlarmAckState(alarmRecord.getAckState());
        this.setAlarmPriority(alarmRecord.getPriority());
        this.setAlarmClass(alarmRecord.getAlarmClass());
        this.setAlarmTimestamp(alarmRecord.getTimestamp());
        this.setAlarmRecordCount(this.getAlarmRecordCount() + 1);
        BObject sourceName = alarmRecord.getAlarmFacet("sourceName");
        BObject messageText = alarmRecord.getAlarmFacet("msgText");
        if (sourceName != null) {
            this.setAlarmSourceName(sourceName.toString());
        } else {
            this.setAlarmSourceName("unknown");
        }
        if (messageText != null) {
            this.setAlarmMessageText(messageText.toString());
        }
        this.debugMsg("Alarm: " + this.getAlarmSource() + " = " + this.getAlarmState());
        BString requestBody = null;
        requestBody = alarmRecord.getSourceState().getOrdinal() == 0 ? BString.make((String)BFormat.make((String)this.getNormalTextFormat()).format((Object)this)) : BString.make((String)BFormat.make((String)this.getAlarmTextFormat()).format((Object)this));
        if (this.getUseOldApi()) {
            try {
                requestBody = BString.make((String)URLEncoder.encode(requestBody.toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException | NullPointerException npe) {
                this.setFault("Invalid request body");
            }
        }
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)1L), (Action)sendRequest, (BValue)requestBody);
    }

    public void doSendRequest(BString requestBody) {
        if (this.checkLicense(true)) {
            return;
        }
        if (this.getTeltonikaSmsUrl().trim().isEmpty()) {
            this.setFault("Teltonika SMS URL is not set");
            return;
        }
        if (this.getTeltonikaUser().trim().isEmpty()) {
            this.setFault("Teltonika User is not set");
            return;
        }
        if (this.getTeltonikaPassword().trim().isEmpty()) {
            this.setFault("Teltonika Password is not set");
            return;
        }
        if (requestBody == null || requestBody.getString().trim().isEmpty()) {
            OssModuleLog.error(this.getLogPrefix() + "Invalid request body");
            return;
        }
        if (this.getUseOldApi()) {
            this.makeDeprecatedApiRequest(requestBody);
        } else {
            String[] numbers = this.getTelephoneNumber().replaceAll(" ", "").split(",");
            if (this.makeApiAuthRequest()) {
                for (String n : numbers) {
                    this.makeApiRequest(requestBody, n);
                }
            }
        }
    }

    public boolean makeApiAuthRequest() {
        HashMap<String, String> headerFields = new HashMap<String, String>();
        String URL_OUT = this.getTeltonikaSmsUrl().trim();
        URL_OUT = URL_OUT + "/api/login";
        headerFields.put("Content-Type", "application/json");
        String reqBody = "{\n  \"username\": \"" + this.getTeltonikaUser().trim() + "\",\n  \"password\": \"" + this.getTeltonikaPassword().trim() + "\"\n}";
        HttpRequest request = new HttpRequest(URL_OUT, "POST", headerFields, reqBody, this.getConnectTimeout(), this.getReadTimeout(), 100000000);
        request.setDebugEnabled(this.getDebugEnabled());
        request.setDebugIdent(this.getName());
        this.debugMsg("Teltonika Auth Request");
        request.sendRequest();
        this.setTeltonikaAuthResponse(request.getResponseCode());
        this.setLastTeltonikaAuthTime(BAbsTime.now());
        if (request.getRequestSuccess()) {
            boolean success = this.getToken(request.getResponseBody());
            if (success) {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
                this.debugMsg("Teltonika Auth Success");
                return true;
            }
            this.setStatus(BStatus.fault);
            this.setFaultCause("Unable to Authenticate");
            this.debugMsg("Teltonika Auth Failure");
        } else {
            this.setTeltonikaApiError(request.getResponseError());
            this.setFault(request.getFaultMessage());
        }
        return false;
    }

    public void makeApiRequest(BString requestBody, String number) {
        String bodyText = requestBody.getString().trim();
        String modem = this.getTeltonikaModem().trim();
        this.debugMsg("Teltonika SMS message size = " + bodyText.length());
        HashMap<String, String> headerFields = new HashMap<String, String>();
        String URL_OUT = this.getTeltonikaSmsUrl().trim();
        URL_OUT = URL_OUT + "/api/messages/actions/send";
        headerFields.put("Content-Type", "application/json");
        headerFields.put("Authorization", "Bearer " + this.BEARER_TOKEN);
        StringBuilder reqBody = new StringBuilder();
        reqBody.append("{\"data\": { \"number\": \"" + number + "\",");
        reqBody.append("\"message\": \"" + bodyText + "\",");
        reqBody.append("\"modem\": \"" + modem + "\"}}");
        OssModuleLog.message(URL_OUT);
        this.setOutput(URL_OUT + " message: " + reqBody);
        HttpRequest request = new HttpRequest(URL_OUT, "POST", headerFields, reqBody.toString(), this.getConnectTimeout(), this.getReadTimeout(), 100000000);
        request.setDebugEnabled(this.getDebugEnabled());
        request.setDebugIdent(this.getName());
        this.debugMsg("Teltonika SMS Request");
        request.sendRequest();
        this.setTeltonikaApiResponse(request.getResponseCode());
        this.setLastTeltonikaApiTime(BAbsTime.now());
        if (request.getRequestSuccess()) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            this.debugMsg("Teltonika SMS Success");
        } else {
            this.setTeltonikaApiError(request.getResponseError());
            this.setFault(request.getFaultMessage());
        }
    }

    public void makeDeprecatedApiRequest(BString requestBody) {
        if (this.getTelephoneNumber().trim().isEmpty() && this.getRecipientType().equals((Object)BRecipientType.Single)) {
            this.setFault("Telephone Number is not set");
            return;
        }
        if (this.getGroupName().trim().isEmpty() && this.getRecipientType().equals((Object)BRecipientType.Group)) {
            this.setFault("Group Name is not set");
            return;
        }
        String bodyText = requestBody.getString().trim();
        this.debugMsg("Teltonika SMS message size = " + bodyText.length());
        HashMap<String, String> headerFields = new HashMap<String, String>();
        String URL_OUT = this.getTeltonikaSmsUrl().trim();
        URL_OUT = URL_OUT + "/cgi-bin/sms_send?username=";
        URL_OUT = URL_OUT + this.getTeltonikaUser().trim();
        URL_OUT = URL_OUT + "&password=";
        URL_OUT = URL_OUT + this.getTeltonikaPassword().trim();
        if (this.getRecipientType().equals((Object)BRecipientType.Single)) {
            URL_OUT = URL_OUT + "&number=";
            URL_OUT = URL_OUT + this.getTelephoneNumber().trim();
        } else {
            URL_OUT = URL_OUT + "&group=";
            URL_OUT = URL_OUT + this.getGroupName().trim();
        }
        URL_OUT = URL_OUT + "&text=";
        URL_OUT = URL_OUT + requestBody.getString().trim();
        OssModuleLog.message(URL_OUT);
        this.setOutput(URL_OUT);
        HttpRequest request = new HttpRequest(URL_OUT, "GET", headerFields, this.getConnectTimeout(), this.getReadTimeout(), 100000000);
        request.setDebugEnabled(this.getDebugEnabled());
        request.setDebugIdent(this.getName());
        this.debugMsg("Teltonika SMS Request");
        request.sendRequest();
        this.setTeltonikaApiResponse(request.getResponseCode());
        this.setLastTeltonikaApiTime(BAbsTime.now());
        if (request.getRequestSuccess()) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            this.debugMsg("Teltonika SMS Success");
        } else {
            this.setTeltonikaApiError(request.getResponseError());
            this.setFault(request.getFaultMessage());
        }
    }

    public String simplifySource(BOrd sourceOrd) {
        String sourcePath = sourceOrd.encodeToString();
        int slotStrIndex = sourcePath.indexOf("slot:/");
        if (slotStrIndex >= 0) {
            sourcePath = sourcePath.substring(slotStrIndex + 6);
        }
        return sourcePath;
    }

    private boolean getToken(String json) {
        if (json.contains("false")) {
            return false;
        }
        JsonObject obj = JsonParser.parseString(json).getAsJsonObject();
        JsonObject data = obj.getAsJsonObject("data");
        this.BEARER_TOKEN = data.get("token").getAsString();
        return true;
    }

    private boolean checkLicense(boolean alwaysReport) {
        if (!OssTeltonikaSmsLicense.isLicensed()) {
            if (this.getStatus().isOk() || alwaysReport) {
                this.setFault("ossTeltonikaSms is not licensed");
            }
            return true;
        }
        return false;
    }

    private void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssModuleLog.error(this.getLogPrefix() + faultMessage);
    }

    private void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            OssModuleLog.debug(this.getLogPrefix() + debugMessage);
        }
    }

    private String getLogPrefix() {
        return "[" + this.getName() + "] ";
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossTeltonikaSms/icons/oss-icon.png");
    }
}

