/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossTeamsTools.alarm;

import java.util.HashMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;
import solutions.onesight.ossTeamsTools.license.OssTeamsToolsLicense;
import solutions.onesight.ossTeamsTools.log.OssModuleLog;
import solutions.onesight.ossTeamsTools.request.HttpRequest;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="teamsWebhookUrl", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="normalCardFormat", type="BFormat", defaultValue="BFormat.make( \"{\\\"type\\\":\\\"message\\\",\\\"attachments\\\":[{\\\"contentType\\\":\\\"application/vnd.microsoft.card.adaptive\\\",\\\"contentUrl\\\":null,\\\"content\\\":{\\\"$schema\\\":\\\"http://adaptivecards.io/schemas/adaptive-card.json\\\",\\\"type\\\":\\\"AdaptiveCard\\\",\\\"version\\\":\\\"1.2\\\",\\\"body\\\":[{\\\"type\\\":\\\"ColumnSet\\\",\\\"columns\\\":[{\\\"type\\\":\\\"Column\\\",\\\"width\\\":\\\"stretch\\\",\\\"items\\\":[{\\\"type\\\":\\\"TextBlock\\\",\\\"text\\\":\\\"Alarm: Normal\\\",\\\"wrap\\\":true,\\\"spacing\\\":\\\"Large\\\",\\\"height\\\":\\\"auto\\\",\\\"fontType\\\":\\\"Default\\\",\\\"size\\\":\\\"ExtraLarge\\\",\\\"weight\\\":\\\"Bolder\\\",\\\"color\\\":\\\"Good\\\"}]},{\\\"type\\\":\\\"Column\\\",\\\"width\\\":\\\"Automatic\\\",\\\"items\\\":[{\\\"type\\\":\\\"Image\\\",\\\"url\\\":\\\"data:image/png;base64,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\\\",\\\"size\\\":\\\"Small\\\",\\\"horizontalAlignment\\\":\\\"Right\\\"}]}]},{\\\"type\\\":\\\"FactSet\\\",\\\"facts\\\":[{\\\"title\\\":\\\"Source\\\",\\\"value\\\":\\\"%alarmSourceName%\\\"},{\\\"title\\\":\\\"Message Text\\\",\\\"value\\\":\\\"%alarmMessageText%\\\"},{\\\"title\\\":\\\"Alarm Class\\\",\\\"value\\\":\\\"%alarmClass%\\\"},{\\\"title\\\":\\\"Timestamp\\\",\\\"value\\\":\\\"%alarmTimestamp%\\\"}]}]}}]}\" )", flags=4), @NiagaraProperty(name="alarmCardFormat", type="BFormat", defaultValue="BFormat.make( \"{\\\"type\\\":\\\"message\\\",\\\"attachments\\\":[{\\\"contentType\\\":\\\"application/vnd.microsoft.card.adaptive\\\",\\\"contentUrl\\\":null,\\\"content\\\":{\\\"$schema\\\":\\\"http://adaptivecards.io/schemas/adaptive-card.json\\\",\\\"type\\\":\\\"AdaptiveCard\\\",\\\"version\\\":\\\"1.2\\\",\\\"body\\\":[{\\\"type\\\":\\\"ColumnSet\\\",\\\"columns\\\":[{\\\"type\\\":\\\"Column\\\",\\\"width\\\":\\\"stretch\\\",\\\"items\\\":[{\\\"type\\\":\\\"TextBlock\\\",\\\"text\\\":\\\"Alarm: %alarmState%\\\",\\\"wrap\\\":true,\\\"spacing\\\":\\\"Large\\\",\\\"height\\\":\\\"auto\\\",\\\"fontType\\\":\\\"Default\\\",\\\"size\\\":\\\"ExtraLarge\\\",\\\"weight\\\":\\\"Bolder\\\",\\\"color\\\":\\\"Attention\\\"}]},{\\\"type\\\":\\\"Column\\\",\\\"width\\\":\\\"Automatic\\\",\\\"items\\\":[{\\\"type\\\":\\\"Image\\\",\\\"url\\\":\\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAgCAYAAAB3j6rJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAT4SURBVFhHvZdtSFtXGMf/N0abOmPUaMKia7vuBatVsWOUQYfVbh/GarUSB3MrbOxFB/2QTaif3EAs3QabCDLYBhJZ0bFGmEqlG6XDD4VaGL6XWaars6NuNRpjrW8xZ88598bFm5uYZNAfnDznnHvOvc/9n+c89wTsf1JXV8fKy0+x8fFxpSc+JP6DODGZTPB6vUoL8Hg8oi8edIqNGZfLJZy48KEF7M5h0XfixEvCxoXQJQ74VDF9vpCxvwvZmVMm0Y53ieJypKmpSTzU1ZLD2PRhxm7lCcv7MjOzlFGxEZcj/IHpRgovTxFj4+QEL7MF7JMPMsW1vr4+ZWT0xBysNTU16OrqwkTPU8jLMwDrynSJSpYekmVUNGO8bWzByoOTO3G0wIC8Yyn/OcHh1Yd+OM/bRLOtrU3YaIlJkeLiIxgeHsLqr7kwPEbvIJEMqWQTyK75gWUqtkTozSPYomosqkStyNDQkHDirco0GOhh0EmYnd1A/rHbYjneddwlpxKABR+ute8Xc+rr64WNCq5INKSkGPnrMTaj7JJ7BaIdXBxnMuTri0Vsv00vj4+SqBTp7OzEgwfL+OwjixyUJDsSQ6cm6vlF4r4PA84nRbWqqkpYv59PioDiUET4MDGUJ6/Adr1fuN0fKF+eszL2BymiXD/+fLLoX1hYUO4Unl0VaWxsFLa37QnaNkFvRdVsi15pyFjN1A4E6LwPP38rx0pZWZmwkdjVkebmZmSl61D+ZobYntv4GWwqRyzckcCQLVoqqx5vn06jIB/G6KicX8IR0RG73S7s9YsHgX98or6NUIR2TxBWM+2aIF+xuIX2lhxRPV4qq0KrIKyasI643W50d3fjxSN78czRZGBDdQMNRcTSUP823CnKMU1ns7C44EZvby+lHiWgVYR1pKSkRNhr7QfELgiBpFfHiCUjaGkCeLfQ+PHjolpRUSGsFpqODA4OYmJiAu9Xp0FP68wfGgI90KZaGmRqOMIFWvHju0+zRbO1tVVYNZop3mBIxvr6KuiLSmmbvFDfnGOQcOXqMl6p+1PpoGe6i4B7m0pLRXYi9lhGsEGXteIkRBGn0ymcaGmwyltRywmOj+G5fPr6KqSm0K2oLyxuH37hy0w4HA5hgwlRJBBMEd8ugFGHy5eX8H2/F19RHBiprbmMAUiVpwtvYWp2M0SVHYo0NDQIe+XrfXQS1ghQNaTAqydN+LzeAuPBJDkeIkEpYMApq6IO3B2KcDVslgT8dZsOw3d3UWOPhBs3V/DCG3eUDvLj93x5m4dbTg4F/8vlU7h6YwXz8/Mwm82ie1uRyspKYa9fpI+VOnlpQZ/8sndmlIbMufNzAD+nRIJS/0/fkOJEaWmpsBwxi3vW09ODMkpcB4o1kpcWFEqrazvHPeSHo92gGNLRNn/PnoaxsTGR/jliaXJzD2Fy8jf4x/Ig8RwVKeAC7JVw6cclvFZPByKFzZFD0CeRh7vN569Pu0zaN45UUxqWPIvQcY+4E2dfT4fEvxXROMFZZaimhDc38Cx++CIHbCofegM9IZr5inAXHBZ4lzzo7++HZLdXM5frEthcobxTolB3B/wwlEhlnSbGMpdniZwkSMZh2kGV0G1sKruDEs7OY06UZZN++PGAK6G+FqnwGJtcowqQlERbnw7FWsMeaZmenpb/YM3MzKCjo4P65FzyKAikr9raWlitVvwLhf+Pp/U1974AAAAASUVORK5CYII\\u003d\\\",\\\"size\\\":\\\"Small\\\",\\\"horizontalAlignment\\\":\\\"Right\\\"}]}]},{\\\"type\\\":\\\"FactSet\\\",\\\"facts\\\":[{\\\"title\\\":\\\"Source\\\",\\\"value\\\":\\\"%alarmSourceName%\\\"},{\\\"title\\\":\\\"Message Text\\\",\\\"value\\\":\\\"%alarmMessageText%\\\"},{\\\"title\\\":\\\"Alarm Class\\\",\\\"value\\\":\\\"%alarmClass%\\\"},{\\\"title\\\":\\\"Timestamp\\\",\\\"value\\\":\\\"%alarmTimestamp%\\\"}]}]}}]}\" )", flags=4), @NiagaraProperty(name="lastAlarmTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="alarmSource", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="alarmState", type="BSourceState", defaultValue="BSourceState.normal", flags=1), @NiagaraProperty(name="alarmAckState", type="BAckState", defaultValue="BAckState.DEFAULT", flags=1), @NiagaraProperty(name="alarmSourceName", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmMessageText", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmPriority", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="alarmClass", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="alarmTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="alarmRecordCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="teamsWebhookResponse", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="teamsWebhookError", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(70)")}), @NiagaraProperty(name="lastTeamsWebhookTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="connectTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="readTimeout", type="int", defaultValue="30000", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit( \"millisecond\" )")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=65604)})
@NiagaraActions(value={@NiagaraAction(name="reset"), @NiagaraAction(name="sendRequest", parameterType="BString", defaultValue="BString.DEFAULT", flags=4)})
@NiagaraTopic(name="alarmTrigger", eventType="BBoolean")
public final class BOssTeamsAlarmRecipient
extends BAlarmRecipient {
    public static final Property enabled = BOssTeamsAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssTeamsAlarmRecipient.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssTeamsAlarmRecipient.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property teamsWebhookUrl = BOssTeamsAlarmRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property normalCardFormat = BOssTeamsAlarmRecipient.newProperty((int)4, (BValue)BFormat.make((String)"{\"type\":\"message\",\"attachments\":[{\"contentType\":\"application/vnd.microsoft.card.adaptive\",\"contentUrl\":null,\"content\":{\"$schema\":\"http://adaptivecards.io/schemas/adaptive-card.json\",\"type\":\"AdaptiveCard\",\"version\":\"1.2\",\"body\":[{\"type\":\"ColumnSet\",\"columns\":[{\"type\":\"Column\",\"width\":\"stretch\",\"items\":[{\"type\":\"TextBlock\",\"text\":\"Alarm: Normal\",\"wrap\":true,\"spacing\":\"Large\",\"height\":\"auto\",\"fontType\":\"Default\",\"size\":\"ExtraLarge\",\"weight\":\"Bolder\",\"color\":\"Good\"}]},{\"type\":\"Column\",\"width\":\"Automatic\",\"items\":[{\"type\":\"Image\",\"url\":\"data:image/png;base64,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\",\"size\":\"Small\",\"horizontalAlignment\":\"Right\"}]}]},{\"type\":\"FactSet\",\"facts\":[{\"title\":\"Source\",\"value\":\"%alarmSourceName%\"},{\"title\":\"Message Text\",\"value\":\"%alarmMessageText%\"},{\"title\":\"Alarm Class\",\"value\":\"%alarmClass%\"},{\"title\":\"Timestamp\",\"value\":\"%alarmTimestamp%\"}]}]}}]}"), null);
    public static final Property alarmCardFormat = BOssTeamsAlarmRecipient.newProperty((int)4, (BValue)BFormat.make((String)"{\"type\":\"message\",\"attachments\":[{\"contentType\":\"application/vnd.microsoft.card.adaptive\",\"contentUrl\":null,\"content\":{\"$schema\":\"http://adaptivecards.io/schemas/adaptive-card.json\",\"type\":\"AdaptiveCard\",\"version\":\"1.2\",\"body\":[{\"type\":\"ColumnSet\",\"columns\":[{\"type\":\"Column\",\"width\":\"stretch\",\"items\":[{\"type\":\"TextBlock\",\"text\":\"Alarm: %alarmState%\",\"wrap\":true,\"spacing\":\"Large\",\"height\":\"auto\",\"fontType\":\"Default\",\"size\":\"ExtraLarge\",\"weight\":\"Bolder\",\"color\":\"Attention\"}]},{\"type\":\"Column\",\"width\":\"Automatic\",\"items\":[{\"type\":\"Image\",\"url\":\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAgCAYAAAB3j6rJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAT4SURBVFhHvZdtSFtXGMf/N0abOmPUaMKia7vuBatVsWOUQYfVbh/GarUSB3MrbOxFB/2QTaif3EAs3QabCDLYBhJZ0bFGmEqlG6XDD4VaGL6XWaars6NuNRpjrW8xZ88598bFm5uYZNAfnDznnHvOvc/9n+c89wTsf1JXV8fKy0+x8fFxpSc+JP6DODGZTPB6vUoL8Hg8oi8edIqNGZfLJZy48KEF7M5h0XfixEvCxoXQJQ74VDF9vpCxvwvZmVMm0Y53ieJypKmpSTzU1ZLD2PRhxm7lCcv7MjOzlFGxEZcj/IHpRgovTxFj4+QEL7MF7JMPMsW1vr4+ZWT0xBysNTU16OrqwkTPU8jLMwDrynSJSpYekmVUNGO8bWzByoOTO3G0wIC8Yyn/OcHh1Yd+OM/bRLOtrU3YaIlJkeLiIxgeHsLqr7kwPEbvIJEMqWQTyK75gWUqtkTozSPYomosqkStyNDQkHDirco0GOhh0EmYnd1A/rHbYjneddwlpxKABR+ute8Xc+rr64WNCq5INKSkGPnrMTaj7JJ7BaIdXBxnMuTri0Vsv00vj4+SqBTp7OzEgwfL+OwjixyUJDsSQ6cm6vlF4r4PA84nRbWqqkpYv59PioDiUET4MDGUJ6/Adr1fuN0fKF+eszL2BymiXD/+fLLoX1hYUO4Unl0VaWxsFLa37QnaNkFvRdVsi15pyFjN1A4E6LwPP38rx0pZWZmwkdjVkebmZmSl61D+ZobYntv4GWwqRyzckcCQLVoqqx5vn06jIB/G6KicX8IR0RG73S7s9YsHgX98or6NUIR2TxBWM+2aIF+xuIX2lhxRPV4qq0KrIKyasI643W50d3fjxSN78czRZGBDdQMNRcTSUP823CnKMU1ns7C44EZvby+lHiWgVYR1pKSkRNhr7QfELgiBpFfHiCUjaGkCeLfQ+PHjolpRUSGsFpqODA4OYmJiAu9Xp0FP68wfGgI90KZaGmRqOMIFWvHju0+zRbO1tVVYNZop3mBIxvr6KuiLSmmbvFDfnGOQcOXqMl6p+1PpoGe6i4B7m0pLRXYi9lhGsEGXteIkRBGn0ymcaGmwyltRywmOj+G5fPr6KqSm0K2oLyxuH37hy0w4HA5hgwlRJBBMEd8ugFGHy5eX8H2/F19RHBiprbmMAUiVpwtvYWp2M0SVHYo0NDQIe+XrfXQS1ghQNaTAqydN+LzeAuPBJDkeIkEpYMApq6IO3B2KcDVslgT8dZsOw3d3UWOPhBs3V/DCG3eUDvLj93x5m4dbTg4F/8vlU7h6YwXz8/Mwm82ie1uRyspKYa9fpI+VOnlpQZ/8sndmlIbMufNzAD+nRIJS/0/fkOJEaWmpsBwxi3vW09ODMkpcB4o1kpcWFEqrazvHPeSHo92gGNLRNn/PnoaxsTGR/jliaXJzD2Fy8jf4x/Ig8RwVKeAC7JVw6cclvFZPByKFzZFD0CeRh7vN569Pu0zaN45UUxqWPIvQcY+4E2dfT4fEvxXROMFZZaimhDc38Cx++CIHbCofegM9IZr5inAXHBZ4lzzo7++HZLdXM5frEthcobxTolB3B/wwlEhlnSbGMpdniZwkSMZh2kGV0G1sKruDEs7OY06UZZN++PGAK6G+FqnwGJtcowqQlERbnw7FWsMeaZmenpb/YM3MzKCjo4P65FzyKAikr9raWlitVvwLhf+Pp/U1974AAAAASUVORK5CYII=\",\"size\":\"Small\",\"horizontalAlignment\":\"Right\"}]}]},{\"type\":\"FactSet\",\"facts\":[{\"title\":\"Source\",\"value\":\"%alarmSourceName%\"},{\"title\":\"Message Text\",\"value\":\"%alarmMessageText%\"},{\"title\":\"Alarm Class\",\"value\":\"%alarmClass%\"},{\"title\":\"Timestamp\",\"value\":\"%alarmTimestamp%\"}]}]}}]}"), null);
    public static final Property lastAlarmTime = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alarmSource = BOssTeamsAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmOrd = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property alarmState = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BSourceState.normal, null);
    public static final Property alarmAckState = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BAckState.DEFAULT, null);
    public static final Property alarmSourceName = BOssTeamsAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmMessageText = BOssTeamsAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmPriority = BOssTeamsAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property alarmClass = BOssTeamsAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property alarmTimestamp = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alarmRecordCount = BOssTeamsAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property teamsWebhookResponse = BOssTeamsAlarmRecipient.newProperty((int)1, (int)0, null);
    public static final Property teamsWebhookError = BOssTeamsAlarmRecipient.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property lastTeamsWebhookTime = BOssTeamsAlarmRecipient.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property connectTimeout = BOssTeamsAlarmRecipient.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property readTimeout = BOssTeamsAlarmRecipient.newProperty((int)4, (int)30000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property debugEnabled = BOssTeamsAlarmRecipient.newProperty((int)65604, (boolean)false, null);
    public static final Action reset = BOssTeamsAlarmRecipient.newAction((int)0, null);
    public static final Action sendRequest = BOssTeamsAlarmRecipient.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Topic alarmTrigger = BOssTeamsAlarmRecipient.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssTeamsAlarmRecipient.class);
    private boolean licenseAllocationValid = false;
    private static final int MAX_RESPONSE_SIZE = 15000;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getTeamsWebhookUrl() {
        return this.getString(teamsWebhookUrl);
    }

    public void setTeamsWebhookUrl(String v) {
        this.setString(teamsWebhookUrl, v, null);
    }

    public BFormat getNormalCardFormat() {
        return (BFormat)this.get(normalCardFormat);
    }

    public void setNormalCardFormat(BFormat v) {
        this.set(normalCardFormat, (BValue)v, null);
    }

    public BFormat getAlarmCardFormat() {
        return (BFormat)this.get(alarmCardFormat);
    }

    public void setAlarmCardFormat(BFormat v) {
        this.set(alarmCardFormat, (BValue)v, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime v) {
        this.set(lastAlarmTime, (BValue)v, null);
    }

    public String getAlarmSource() {
        return this.getString(alarmSource);
    }

    public void setAlarmSource(String v) {
        this.setString(alarmSource, v, null);
    }

    public BOrd getAlarmOrd() {
        return (BOrd)this.get(alarmOrd);
    }

    public void setAlarmOrd(BOrd v) {
        this.set(alarmOrd, (BValue)v, null);
    }

    public BSourceState getAlarmState() {
        return (BSourceState)this.get(alarmState);
    }

    public void setAlarmState(BSourceState v) {
        this.set(alarmState, (BValue)v, null);
    }

    public BAckState getAlarmAckState() {
        return (BAckState)this.get(alarmAckState);
    }

    public void setAlarmAckState(BAckState v) {
        this.set(alarmAckState, (BValue)v, null);
    }

    public String getAlarmSourceName() {
        return this.getString(alarmSourceName);
    }

    public void setAlarmSourceName(String v) {
        this.setString(alarmSourceName, v, null);
    }

    public String getAlarmMessageText() {
        return this.getString(alarmMessageText);
    }

    public void setAlarmMessageText(String v) {
        this.setString(alarmMessageText, v, null);
    }

    public int getAlarmPriority() {
        return this.getInt(alarmPriority);
    }

    public void setAlarmPriority(int v) {
        this.setInt(alarmPriority, v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BAbsTime getAlarmTimestamp() {
        return (BAbsTime)this.get(alarmTimestamp);
    }

    public void setAlarmTimestamp(BAbsTime v) {
        this.set(alarmTimestamp, (BValue)v, null);
    }

    public int getAlarmRecordCount() {
        return this.getInt(alarmRecordCount);
    }

    public void setAlarmRecordCount(int v) {
        this.setInt(alarmRecordCount, v, null);
    }

    public int getTeamsWebhookResponse() {
        return this.getInt(teamsWebhookResponse);
    }

    public void setTeamsWebhookResponse(int v) {
        this.setInt(teamsWebhookResponse, v, null);
    }

    public String getTeamsWebhookError() {
        return this.getString(teamsWebhookError);
    }

    public void setTeamsWebhookError(String v) {
        this.setString(teamsWebhookError, v, null);
    }

    public BAbsTime getLastTeamsWebhookTime() {
        return (BAbsTime)this.get(lastTeamsWebhookTime);
    }

    public void setLastTeamsWebhookTime(BAbsTime v) {
        this.set(lastTeamsWebhookTime, (BValue)v, null);
    }

    public int getConnectTimeout() {
        return this.getInt(connectTimeout);
    }

    public void setConnectTimeout(int v) {
        this.setInt(connectTimeout, v, null);
    }

    public int getReadTimeout() {
        return this.getInt(readTimeout);
    }

    public void setReadTimeout(int v) {
        this.setInt(readTimeout, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void sendRequest(BString parameter) {
        this.invoke(sendRequest, (BValue)parameter, null);
    }

    public void fireAlarmTrigger(BBoolean event) {
        this.fire(alarmTrigger, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.licenseAllocationValid = false;
        if (!OssTeamsToolsLicense.checkLicense()) {
            this.setFault("ossTeamsTools is not licensed");
            return;
        }
        if (!OssTeamsToolsLicense.allocateAlertLicense()) {
            this.setFault("ossTeamsTools licence limit exceeded");
            return;
        }
        this.licenseAllocationValid = true;
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void stopped() {
        if (this.licenseAllocationValid) {
            OssTeamsToolsLicense.freeAlertLicense();
        }
    }

    public void changed(Property property, Context cxt) {
        if (!this.isRunning()) {
            return;
        }
        if (this.checkLicense(false)) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doReset() {
        this.setLastAlarmTime(BAbsTime.NULL);
        this.setAlarmSource("");
        this.setAlarmOrd(BOrd.NULL);
        this.setAlarmState(BSourceState.normal);
        this.setAlarmAckState(BAckState.DEFAULT);
        this.setAlarmSourceName("");
        this.setAlarmMessageText("");
        this.setAlarmPriority(0);
        this.setAlarmClass("");
        this.setAlarmTimestamp(BAbsTime.NULL);
        this.setAlarmRecordCount(0);
        this.setTeamsWebhookResponse(0);
        this.setTeamsWebhookError("");
        this.setLastTeamsWebhookTime(BAbsTime.NULL);
    }

    public void handleAlarm(BAlarmRecord alarmRecord) {
        if (this.checkLicense(true)) {
            return;
        }
        if (!this.getEnabled()) {
            this.debugMsg("Disabled");
            return;
        }
        if (this.getTeamsWebhookUrl().trim().isEmpty()) {
            this.setFault("Teams Webhook URL is not set");
            return;
        }
        this.setLastAlarmTime(alarmRecord.getTimestamp());
        this.setAlarmSource(this.simplifySource(alarmRecord.getSource().get(0)));
        this.setAlarmOrd(alarmRecord.getSource().get(0));
        this.setAlarmState(alarmRecord.getSourceState());
        this.setAlarmAckState(alarmRecord.getAckState());
        this.setAlarmPriority(alarmRecord.getPriority());
        this.setAlarmClass(alarmRecord.getAlarmClass());
        this.setAlarmTimestamp(alarmRecord.getTimestamp());
        this.setAlarmRecordCount(this.getAlarmRecordCount() + 1);
        BObject sourceName = alarmRecord.getAlarmFacet("sourceName");
        BObject messageText = alarmRecord.getAlarmFacet("msgText");
        if (sourceName != null) {
            this.setAlarmSourceName(sourceName.toString());
        } else {
            this.setAlarmSourceName("unknown");
        }
        if (messageText != null) {
            this.setAlarmMessageText(messageText.toString());
        }
        this.debugMsg("Alarm: " + this.getAlarmSource() + " = " + this.getAlarmState());
        BString requestBody = null;
        requestBody = alarmRecord.getSourceState().getOrdinal() == 0 ? BString.make((String)this.getNormalCardFormat().format((Object)this)) : BString.make((String)this.getAlarmCardFormat().format((Object)this));
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)1L), (Action)sendRequest, (BValue)requestBody);
    }

    public void doSendRequest(BString requestBody) {
        if (this.checkLicense(true)) {
            return;
        }
        if (this.getTeamsWebhookUrl().trim().isEmpty()) {
            this.setFault("Teams Webhook URL is not set");
            return;
        }
        if (requestBody == null || requestBody.getString().trim().isEmpty()) {
            OssModuleLog.error(this.getLogPrefix() + "Invalid request body");
            return;
        }
        String bodyText = requestBody.getString().trim();
        this.debugMsg("Teams Card Message Size = " + bodyText.length());
        HashMap<String, String> headerFields = new HashMap<String, String>();
        headerFields.put("Content-Type", "application/json");
        HttpRequest request = new HttpRequest(this.getTeamsWebhookUrl().trim(), "POST", headerFields, bodyText, this.getConnectTimeout(), this.getReadTimeout(), 15000);
        request.setDebugEnabled(this.getDebugEnabled());
        request.setDebugIdent(this.getName());
        this.debugMsg("Teams Webhook Request");
        request.sendRequest();
        this.setTeamsWebhookResponse(request.getResponseCode());
        this.setLastTeamsWebhookTime(BAbsTime.now());
        if (request.getRequestSuccess()) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            this.debugMsg("Teams Webhook Success");
        } else {
            this.setTeamsWebhookError(request.getResponseError());
            this.setFault(request.getFaultMessage());
        }
    }

    public String simplifySource(BOrd sourceOrd) {
        String sourcePath = sourceOrd.encodeToString();
        int slotStrIndex = sourcePath.indexOf("slot:/");
        if (slotStrIndex >= 0) {
            sourcePath = sourcePath.substring(slotStrIndex + 6);
        }
        return sourcePath;
    }

    private boolean checkLicense(boolean alwaysReport) {
        if (!OssTeamsToolsLicense.isLicensed()) {
            if (this.getStatus().isOk() || alwaysReport) {
                this.setFault("ossTeamsTools is not licensed");
            }
            return true;
        }
        if (!this.licenseAllocationValid) {
            if (this.getStatus().isOk() || alwaysReport) {
                this.setFault("ossTeamsTools licence limit exceeded");
            }
            return true;
        }
        return false;
    }

    private void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        OssModuleLog.error(this.getLogPrefix() + faultMessage);
    }

    private void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            OssModuleLog.debug(this.getLogPrefix() + debugMessage);
        }
    }

    private String getLogPrefix() {
        return "[" + this.getName() + "] ";
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossTeamsTools/icons/oss-icon.png");
    }
}

