/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossStationBackup.backup;

import com.tridium.sys.station.Station;
import com.tridium.util.TimeFormat;
import java.io.IOException;
import java.util.logging.Logger;
import javax.baja.backup.BBackupService;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.JobLogItem;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossStationBackup.backup.BOssStationBackup;
import solutions.onesight.ossStationBackup.backup.BStationBackupJob;
import solutions.onesight.ossStationBackup.log.OssModuleLog;

public class StationBackupTask
extends Thread {
    private final BOssStationBackup master;
    private BStationBackupJob backupJob = null;
    private volatile boolean abortFlag = false;
    private static final Logger log = OssModuleLog.getLog();

    public StationBackupTask(BOssStationBackup newMaster) {
        this.master = newMaster;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("OSS-StationBackupTask-" + this.getId());
        this.abortFlag = false;
        try {
            if (this.master.getEnabled()) {
                this.processBackup();
                this.master.applyBackupSchedule();
            }
        }
        catch (Exception taskException) {
            this.master.setFault("Backup task exception: " + taskException, true);
            taskException.printStackTrace();
        }
        this.master.setBackupInProgress(false);
    }

    public void processBackup() {
        BIFile backupFile;
        BObject folderObject;
        this.master.setBackupInProgress(true);
        this.master.setStatus(BStatus.ok);
        this.master.setFaultCause("");
        this.master.resolveBackupName();
        try {
            folderObject = this.master.getBackupFolder().get();
        }
        catch (UnresolvedException folderException) {
            this.master.setFault("Backup folder does not exist");
            log.severe("Backup folder does not exist: " + folderException.getMessage());
            return;
        }
        catch (Exception folderException) {
            this.master.setFault("Could not access backup folder");
            log.severe("Could not access backup folder: " + folderException.getMessage());
            folderException.printStackTrace();
            return;
        }
        if (!(folderObject instanceof BDirectory)) {
            this.master.setFault("Backup folder invalid");
            log.severe("Backup folder invalid: " + this.master.getBackupFolder());
            return;
        }
        BDirectory backupDirectory = (BDirectory)folderObject;
        StringBuilder backupFilename = new StringBuilder("backup_").append(this.master.getBackupName());
        if (this.master.getAddTimestamp()) {
            backupFilename.append("_").append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYMMDD_HHmmss"));
        }
        backupFilename.append(".dist");
        this.master.debugMsg("Backup filename: " + backupFilename);
        this.master.debugMsg("Backup folder: " + backupDirectory);
        FilePath backupPath = backupDirectory.getFilePath().merge(backupFilename.toString());
        this.master.debugMsg("Backup file path: " + backupPath);
        try {
            backupFile = backupDirectory.getFileSpace().makeFile(backupPath);
        }
        catch (IOException fileException) {
            this.master.setFault("Could not create backup file");
            log.severe("Could not create backup file: " + fileException.getMessage());
            fileException.printStackTrace();
            return;
        }
        if (this.abortFlag) {
            return;
        }
        this.master.debugMsg("Saving station");
        try {
            Station.saveSync();
        }
        catch (Exception stationException) {
            this.master.setFault("Station save failed");
            log.severe("Station save failed:" + stationException.getMessage());
            stationException.printStackTrace();
            return;
        }
        this.master.debugMsg("Station saved");
        if (this.abortFlag) {
            return;
        }
        this.master.debugMsg("Starting backup");
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        this.backupJob = new BStationBackupJob();
        try {
            service.zip((BJob)this.backupJob, backupFile.getOutputStream(), true);
            this.master.setLastBackup(BAbsTime.now());
            this.master.fireBackupComplete(BBoolean.TRUE);
        }
        catch (Exception backupException) {
            this.master.setFault("Backup failed: " + backupException, true);
            backupException.printStackTrace();
            return;
        }
        if (this.master.getLogBackup()) {
            for (JobLogItem logItem : this.backupJob.log().getItems()) {
                log.finest(logItem.toString());
            }
        }
        this.backupJob = null;
        if (this.abortFlag) {
            return;
        }
        log.info("Station backup complete");
    }

    public void abort() {
        this.abortFlag = true;
        if (this.backupJob != null) {
            this.backupJob.cancel();
        }
    }
}

