/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossStationBackup.backup;

import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import solutions.onesight.ossStationBackup.backup.BBackupSchedule;
import solutions.onesight.ossStationBackup.backup.ScheduleCalc;
import solutions.onesight.ossStationBackup.backup.StationBackupTask;
import solutions.onesight.ossStationBackup.license.OssStationBackupLicense;
import solutions.onesight.ossStationBackup.log.OssModuleLog;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", flags=73, defaultValue="BStatus.ok"), @NiagaraProperty(name="faultCause", type="String", flags=65, defaultValue=""), @NiagaraProperty(name="backupInProgress", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="backupName", type="String", defaultValue=""), @NiagaraProperty(name="backupFolder", type="BOrd", defaultValue="BOrd.make(\"file:^backups\")"), @NiagaraProperty(name="addTimestamp", type="boolean", defaultValue="true"), @NiagaraProperty(name="backupSchedule", type="BBackupSchedule", defaultValue="BBackupSchedule.DEFAULT"), @NiagaraProperty(name="backupDayOfMonth", type="int", defaultValue="1", flags=4, facets={@Facet(name="BFacets.MIN", value="BDouble.make( -30 )"), @Facet(name="BFacets.MAX", value="BDouble.make( 31 )")}), @NiagaraProperty(name="backupDayOfWeek", type="BWeekday", defaultValue="BWeekday.monday", flags=4), @NiagaraProperty(name="backupTimeOfDay", type="BTime", defaultValue="BTime.DEFAULT", flags=4), @NiagaraProperty(name="lastBackup", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="nextBackup", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=5), @NiagaraProperty(name="logBackup", type="boolean", defaultValue="false", flags=65604), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=65604)})
@NiagaraActions(value={@NiagaraAction(name="runBackup", flags=16), @NiagaraAction(name="abortBackup", flags=16)})
@NiagaraTopic(name="backupComplete", eventType="BBoolean")
public class BOssStationBackup
extends BComponent {
    public static final Property enabled = BOssStationBackup.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssStationBackup.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssStationBackup.newProperty((int)65, (String)"", null);
    public static final Property backupInProgress = BOssStationBackup.newProperty((int)65, (boolean)false, null);
    public static final Property backupName = BOssStationBackup.newProperty((int)0, (String)"", null);
    public static final Property backupFolder = BOssStationBackup.newProperty((int)0, (BValue)BOrd.make((String)"file:^backups"), null);
    public static final Property addTimestamp = BOssStationBackup.newProperty((int)0, (boolean)true, null);
    public static final Property backupSchedule = BOssStationBackup.newProperty((int)0, (BValue)BBackupSchedule.DEFAULT, null);
    public static final Property backupDayOfMonth = BOssStationBackup.newProperty((int)4, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)-30.0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BDouble.make((double)31.0))));
    public static final Property backupDayOfWeek = BOssStationBackup.newProperty((int)4, (BValue)BWeekday.monday, null);
    public static final Property backupTimeOfDay = BOssStationBackup.newProperty((int)4, (BValue)BTime.DEFAULT, null);
    public static final Property lastBackup = BOssStationBackup.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property nextBackup = BOssStationBackup.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Property logBackup = BOssStationBackup.newProperty((int)65604, (boolean)false, null);
    public static final Property debugEnabled = BOssStationBackup.newProperty((int)65604, (boolean)false, null);
    public static final Action runBackup = BOssStationBackup.newAction((int)16, null);
    public static final Action abortBackup = BOssStationBackup.newAction((int)16, null);
    public static final Topic backupComplete = BOssStationBackup.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssStationBackup.class);
    private StationBackupTask backupTask = null;
    private Clock.Ticket backupTimer = null;
    private static final Logger log = OssModuleLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getBackupInProgress() {
        return this.getBoolean(backupInProgress);
    }

    public void setBackupInProgress(boolean v) {
        this.setBoolean(backupInProgress, v, null);
    }

    public String getBackupName() {
        return this.getString(backupName);
    }

    public void setBackupName(String v) {
        this.setString(backupName, v, null);
    }

    public BOrd getBackupFolder() {
        return (BOrd)this.get(backupFolder);
    }

    public void setBackupFolder(BOrd v) {
        this.set(backupFolder, (BValue)v, null);
    }

    public boolean getAddTimestamp() {
        return this.getBoolean(addTimestamp);
    }

    public void setAddTimestamp(boolean v) {
        this.setBoolean(addTimestamp, v, null);
    }

    public BBackupSchedule getBackupSchedule() {
        return (BBackupSchedule)this.get(backupSchedule);
    }

    public void setBackupSchedule(BBackupSchedule v) {
        this.set(backupSchedule, (BValue)v, null);
    }

    public int getBackupDayOfMonth() {
        return this.getInt(backupDayOfMonth);
    }

    public void setBackupDayOfMonth(int v) {
        this.setInt(backupDayOfMonth, v, null);
    }

    public BWeekday getBackupDayOfWeek() {
        return (BWeekday)this.get(backupDayOfWeek);
    }

    public void setBackupDayOfWeek(BWeekday v) {
        this.set(backupDayOfWeek, (BValue)v, null);
    }

    public BTime getBackupTimeOfDay() {
        return (BTime)this.get(backupTimeOfDay);
    }

    public void setBackupTimeOfDay(BTime v) {
        this.set(backupTimeOfDay, (BValue)v, null);
    }

    public BAbsTime getLastBackup() {
        return (BAbsTime)this.get(lastBackup);
    }

    public void setLastBackup(BAbsTime v) {
        this.set(lastBackup, (BValue)v, null);
    }

    public BAbsTime getNextBackup() {
        return (BAbsTime)this.get(nextBackup);
    }

    public void setNextBackup(BAbsTime v) {
        this.set(nextBackup, (BValue)v, null);
    }

    public boolean getLogBackup() {
        return this.getBoolean(logBackup);
    }

    public void setLogBackup(boolean v) {
        this.setBoolean(logBackup, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void runBackup() {
        this.invoke(runBackup, null, null);
    }

    public void abortBackup() {
        this.invoke(abortBackup, null, null);
    }

    public void fireBackupComplete(BBoolean event) {
        this.fire(backupComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
            this.resolveBackupName();
        } else {
            this.setStatus(BStatus.disabled);
        }
    }

    public void atSteadyState() {
        this.applyBackupSchedule();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
                this.applyBackupSchedule();
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
                this.applyBackupSchedule();
                this.doAbortBackup();
            }
        } else if (property == backupSchedule) {
            switch (this.getBackupSchedule().getOrdinal()) {
                case 1: {
                    this.setFlags((Slot)backupDayOfMonth, 4);
                    this.setFlags((Slot)backupDayOfWeek, 4);
                    this.setFlags((Slot)backupTimeOfDay, 4);
                    this.setFlags((Slot)nextBackup, 5);
                    break;
                }
                case 2: {
                    this.setFlags((Slot)backupDayOfMonth, 4);
                    this.setFlags((Slot)backupDayOfWeek, 4);
                    this.setFlags((Slot)backupTimeOfDay, 0);
                    this.setFlags((Slot)nextBackup, 1);
                    break;
                }
                case 3: {
                    this.setFlags((Slot)backupDayOfMonth, 4);
                    this.setFlags((Slot)backupDayOfWeek, 0);
                    this.setFlags((Slot)backupTimeOfDay, 0);
                    this.setFlags((Slot)nextBackup, 1);
                    break;
                }
                case 4: {
                    this.setFlags((Slot)backupDayOfMonth, 0);
                    this.setFlags((Slot)backupDayOfWeek, 4);
                    this.setFlags((Slot)backupTimeOfDay, 0);
                    this.setFlags((Slot)nextBackup, 1);
                    break;
                }
                default: {
                    this.setBackupSchedule(BBackupSchedule.DEFAULT);
                }
            }
            this.applyBackupSchedule();
        } else if (property == backupDayOfMonth) {
            if (this.getBackupSchedule().getOrdinal() == 4) {
                this.applyBackupSchedule();
            }
        } else if (property == backupDayOfWeek) {
            if (this.getBackupSchedule().getOrdinal() == 3) {
                this.applyBackupSchedule();
            }
        } else if (property == backupTimeOfDay && (this.getBackupSchedule().getOrdinal() == 2 || this.getBackupSchedule().getOrdinal() == 3 || this.getBackupSchedule().getOrdinal() == 4)) {
            this.applyBackupSchedule();
        }
    }

    public void doRunBackup() {
        this.debugMsg("Backing-up station");
        if (!OssStationBackupLicense.checkLicense()) {
            this.setFault("ossStationBackup is not licensed", true);
            return;
        }
        if (!this.getEnabled()) {
            log.warning("Backup disabled");
            return;
        }
        if (this.backupTask == null || !this.backupTask.isAlive()) {
            this.backupTask = new StationBackupTask(this);
            this.backupTask.start();
        } else {
            log.fine("Backup task already running");
        }
    }

    public void doAbortBackup() {
        if (this.backupTask != null) {
            this.backupTask.abort();
            this.backupTask = null;
        }
    }

    protected void applyBackupSchedule() {
        if (this.backupTimer != null) {
            this.backupTimer.cancel();
        }
        this.backupTimer = null;
        if (!OssStationBackupLicense.checkLicense()) {
            this.setFault("ossStationBackup is not licensed", true);
            return;
        }
        if (!this.getEnabled()) {
            this.debugMsg("Backup disabled");
            this.setNextBackup(BAbsTime.NULL);
            return;
        }
        this.debugMsg("Backup schedule: " + (Object)((Object)this.getBackupSchedule()));
        BAbsTime nextBackupTime = ScheduleCalc.getNext(this.getBackupSchedule(), this.getBackupTimeOfDay(), this.getBackupDayOfWeek(), this.getBackupDayOfMonth());
        if (nextBackupTime != null) {
            this.backupTimer = Clock.schedule((BComponent)this, (BAbsTime)nextBackupTime, (Action)runBackup, null);
            this.setNextBackup(nextBackupTime);
            this.debugMsg("Backup scheduled for: " + nextBackupTime);
        } else {
            this.debugMsg("Backup schedule set to manual");
            this.setNextBackup(BAbsTime.NULL);
        }
    }

    public void resolveBackupName() {
        String localBackupName = this.getBackupName().trim();
        if (localBackupName.isEmpty()) {
            localBackupName = null;
            try {
                localBackupName = Sys.getStation().getStationName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (localBackupName == null) {
                try {
                    localBackupName = Sys.getHostName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (localBackupName == null) {
                localBackupName = "localhost";
            }
        }
        this.setBackupName(localBackupName);
    }

    public void setFault(String faultMessage) {
        this.setFault(faultMessage, false);
    }

    public void setFault(String faultMessage, boolean logFault) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(faultMessage);
        if (logFault) {
            log.severe(faultMessage);
        }
    }

    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.fine(debugMessage);
        }
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossStationBackup/icons/oss-icon.png");
    }
}

