/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.resources;

import com.tridium.ui.BOptionDialog;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.BFolder;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;
import solutions.onesight.ossRestApiServer.resources.BApiResourceAddDialog;
import solutions.onesight.ossRestApiServer.resources.BApiResourceAllocation;
import solutions.onesight.ossRestApiServer.resources.BApiResourceDiscoveryJob;
import solutions.onesight.ossRestApiServer.resources.BApiResourceEditDialog;
import solutions.onesight.ossRestApiServer.resources.BApiResourceEntry;
import solutions.onesight.ossRestApiServer.resources.BApiResourceList;
import solutions.onesight.ossRestApiServer.resources.BApiResourceType;

@NiagaraType(agent={@AgentOn(types={"ossRestApiServer:ApiResourceList"})})
public class BApiResourceManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BApiResourceManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colPath = new MgrColumn.PropPath(new Property[]{BApiResourceAllocation.resourcePath});
    MgrColumn colResourceType = new MgrColumn.PropPath(new Property[]{BApiResourceAllocation.resourceType});
    MgrColumn colResourceStatus = new MgrColumn.PropPath(new Property[]{BApiResourceAllocation.status});
    MgrColumn colResourceFaultCause = new MgrColumn.PropPath(new Property[]{BApiResourceAllocation.faultCause});
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colPath, this.colResourceType, this.colResourceStatus, this.colResourceFaultCause};
    public static final int NEW_PATH_FIELD_SIZE = 50;

    public Type getType() {
        return TYPE;
    }

    public BApiResourceList getResourceListNode() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BApiResourceList) {
            return (BApiResourceList)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cxt) {
        super.doLoadValue(obj, cxt);
        this.getModel().getTable().setMultipleSelection(false);
        this.updateLearnData();
    }

    public void updateLearnData() {
        BApiResourceDiscoveryJob learnJob = (BApiResourceDiscoveryJob)this.getLearn().getJob();
        if (learnJob != null) {
            this.getLearn().updateRoots(learnJob.getResourcePaths().getChildren(BApiResourceEntry.class));
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    class Learn
    extends MgrLearn {
        Learn(BFolderManager manager) {
            super((BAbstractManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BApiResourceEntry.resourcePath), new MgrColumn.Prop(BApiResourceEntry.resourceType)};
        }

        public void toRow(Object discovery, MgrEditRow row) {
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return null;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BApiResourceDiscoveryJob) {
                BApiResourceManager.this.updateLearnData();
            }
        }

        public boolean isMatchable(Object discovery, BComponent database) {
            return false;
        }
    }

    class Controller
    extends FolderController {
        private final MgrController.MgrCommand findHistories;
        private final MgrController.MgrCommand findPoints;
        private final BFolderManager manager;

        Controller(BFolderManager manager) {
            super(manager);
            this.manager = manager;
            this.findHistories = new FindHistoriesCommand((BWidget)manager);
            this.findHistories.setFlags(7);
            this.findHistories.setEnabled(true);
            this.findPoints = new FindPointsCommand((BWidget)manager);
            this.findPoints.setFlags(7);
            this.findPoints.setEnabled(true);
            this.match.setEnabled(false);
            this.match.setFlags(0);
            this.tagIt.setEnabled(false);
            this.tagIt.setFlags(0);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.findPoints, this.findHistories, this.cancel, this.add};
        }

        public CommandArtifact doNew(Context cxt) {
            BApiResourceAddDialog discoverDialog = new BApiResourceAddDialog();
            int dialogResult = BDialog.open((BWidget)this.getManager(), (String)"Choose discovery type", (Object)discoverDialog.getPane(), (int)3);
            if (dialogResult == 1) {
                if (discoverDialog.getResourceType() == 2) {
                    String historyPath = BDialog.prompt((BWidget)this.getManager(), (String)"Enter history path", (String)"", (int)50);
                    if (historyPath == null || historyPath.isEmpty()) {
                        BDialog.error((BWidget)this.getManager(), (String)"History Path Invalid", (Object)"History path is blank");
                    } else {
                        BApiResourceManager.this.getResourceListNode().add(historyPath, BApiResourceType.History);
                    }
                }
                if (discoverDialog.getResourceType() == 1) {
                    String pointPath = BDialog.prompt((BWidget)this.getManager(), (String)"Enter point path", (String)"", (int)50);
                    if (pointPath == null || pointPath.isEmpty()) {
                        BDialog.error((BWidget)this.getManager(), (String)"Point Path Invalid", (Object)"Point path is blank");
                    } else {
                        BApiResourceManager.this.getResourceListNode().add(pointPath, BApiResourceType.Point);
                    }
                }
            }
            return null;
        }

        public CommandArtifact doEdit(Context cxt) {
            for (BComponent editItem : this.getSelectedComponents()) {
                if (!(editItem instanceof BApiResourceAllocation)) continue;
                BApiResourceAllocation resourceItem = (BApiResourceAllocation)editItem;
                String originalName = resourceItem.getName().trim();
                String originalPath = resourceItem.getResourcePath().trim();
                BApiResourceEditDialog editDialog = new BApiResourceEditDialog(resourceItem.getResourceType().getDisplayTag(null), originalName, originalPath);
                boolean inputInProgress = true;
                while (inputInProgress) {
                    int dialogResult = BDialog.open((BWidget)this.manager, (String)"Edit Resource", (Object)((Object)editDialog), (int)3);
                    if (dialogResult == 1) {
                        String newName = editDialog.getResourceName().trim();
                        String newPath = editDialog.getResourcePath().trim();
                        if (newName.isEmpty()) {
                            BDialog.error((BWidget)this.getManager(), (String)"Invalid resource name", (Object)"New resource name blank");
                            continue;
                        }
                        if (newPath.isEmpty()) {
                            BDialog.error((BWidget)this.getManager(), (String)"Invalid resource path", (Object)"New resource path blank");
                            continue;
                        }
                        inputInProgress = false;
                        if (newName.contentEquals(originalName) && newPath.contentEquals(originalPath)) continue;
                        BApiResourceList resourceList = BApiResourceManager.this.getResourceListNode();
                        BValue existingSlot = resourceList.get(newName);
                        if (existingSlot != null && existingSlot.equals((Object)resourceItem)) {
                            existingSlot = null;
                        }
                        if (existingSlot == null) {
                            if (resourceList.isExisting(newPath)) {
                                BDialog.error((BWidget)this.getManager(), (String)"Invalid resource path", (Object)"New resource path already exists");
                                continue;
                            }
                            resourceList.remove(originalName);
                            resourceItem.setResourcePath(newPath);
                            resourceList.add(newName, (BValue)resourceItem);
                            continue;
                        }
                        BDialog.error((BWidget)this.getManager(), (String)"Invalid resource name", (Object)"New resource name already exists");
                        continue;
                    }
                    if (dialogResult != 2) continue;
                    inputInProgress = false;
                }
            }
            return null;
        }

        public CommandArtifact doAdd(Context cxt) throws Exception {
            if (BApiResourceManager.this.getLearn() == null) {
                return null;
            }
            for (Object discoverItem : this.getLearnTable().getSelectedObjects()) {
                BApiResourceEntry resourceItem = (BApiResourceEntry)discoverItem;
                BApiResourceManager.this.getResourceListNode().add(resourceItem);
                this.getManager().loadValue((BObject)BApiResourceManager.this.getResourceListNode());
            }
            return null;
        }

        class FindPointsCommand
        extends MgrController.MgrCommand {
            public FindPointsCommand(BWidget mgr) {
                super(mgr, "Find Points");
            }

            public CommandArtifact doInvoke() throws Exception {
                BComponent rootNode = BApiResourceManager.this.getResourceListNode().getComponentSpace().getRootComponent().getParentComponent();
                BNavTree navTree = new BNavTree((BINavNode)rootNode);
                navTree.setReadonly(true);
                navTree.setController((TreeController)new SelectionController());
                BBorderPane navBorder = new BBorderPane((BWidget)new BTreePane((BTree)navTree), BBorder.solid);
                navBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
                navBorder.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)0.0));
                BConstrainedPane conPane = new BConstrainedPane((BWidget)navBorder);
                conPane.setMinWidth(400.0);
                conPane.setMinHeight(400.0);
                BLabel noteLabel = new BLabel("If there is no selection then all points will be listed");
                BBorderPane labelBorder = new BBorderPane((BWidget)conPane, noteLabel, BBorder.none);
                labelBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
                labelBorder.setPadding(BInsets.make((double)12.0, (double)2.0, (double)0.0, (double)2.0));
                int button = BDialog.open((BWidget)Controller.this.getManager(), (String)"Choose Root", (Object)labelBorder, (int)3);
                if (button == 1) {
                    BComponent searchNode = null;
                    NavTreeNode node = (NavTreeNode)navTree.getSelection().getNode();
                    if (node != null) {
                        Object nodeObj = node.getSubject();
                        if (nodeObj instanceof BComponent) {
                            searchNode = (BComponent)nodeObj;
                        }
                    } else {
                        searchNode = rootNode;
                    }
                    if (searchNode != null) {
                        Controller.this.learnMode.setSelected(true);
                        BOrd ordToDiscoveryJob = BApiResourceManager.this.getResourceListNode().doSubmitPointDiscoveryJob(searchNode.getNavOrd());
                        BApiResourceManager.this.getLearn().setJob(ordToDiscoveryJob);
                    }
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/find.png")));
            }

            class SelectionController
            extends TreeController {
                SelectionController() {
                }

                protected void doSelectAction(TreeNode target, double x, double y) {
                    BOptionDialog dlg = (BOptionDialog)this.getTree().getShell();
                    dlg.getOkButton().invokeAction();
                }
            }
        }

        class FindHistoriesCommand
        extends MgrController.MgrCommand {
            public FindHistoriesCommand(BWidget mgr) {
                super(mgr, "Find Histories");
            }

            public CommandArtifact doInvoke() throws Exception {
                Controller.this.learnMode.setSelected(true);
                BComponent rootNode = BApiResourceManager.this.getResourceListNode().getComponentSpace().getRootComponent();
                BOrd ordToDiscoveryJob = BApiResourceManager.this.getResourceListNode().doSubmitHistoryDiscoveryJob(rootNode.getNavOrd());
                BApiResourceManager.this.getLearn().setJob(ordToDiscoveryJob);
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://icons/x16/find.png")));
            }
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BApiResourceManager.this.cols;
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }
    }
}

