/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;
import solutions.onesight.ossRestApiServer.BOssApiClientApplication;
import solutions.onesight.ossRestApiServer.BOssApiClientCredentials;
import solutions.onesight.ossRestApiServer.BOssRestApiService;

@NiagaraType(agent={@AgentOn(types={"ossRestApiServer:OssApiClientCredentials"})})
public class BGenerateClientCredentialsView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BGenerateClientCredentialsView.class);
    private BTextEditorPane clientSecret;
    private BTextField clientId;
    private BTextField appName;
    private BOssApiClientCredentials credentials;
    private BOssApiClientApplication application;
    private BOssRestApiService service;
    private boolean firstTime = true;
    private static final Lexicon lex = Lexicon.make((String)"ossRestApiServer");

    public Type getType() {
        return TYPE;
    }

    public BGenerateClientCredentialsView() {
        BGridPane mainGrid = new BGridPane(2);
        mainGrid.setValign(BValign.make((int)0));
        mainGrid.setHalign(BHalign.make((int)0));
        mainGrid.setRowGap(3.0);
        BLabel appNameLabel = new BLabel("OAuth Client Application Name: ");
        BLabel clientIdLabel = new BLabel("OAuth Client Id: ");
        BLabel clientSecretLabel = new BLabel("OAuth Client Secret: ");
        BLabel title = new BLabel("Generate Client Credentials");
        BFont font = BFont.make((String)BFont.DEFAULT.getName(), (double)18.0, (int)4);
        title.setFont(font);
        this.appName = new BTextField(" Application Name goes here", 80);
        this.appName.setAllowCopying(true);
        this.appName.setEditable(false);
        this.clientId = new BTextField(" Client ID goes here", 80);
        this.clientId.setAllowCopying(true);
        this.clientId.setEditable(false);
        this.clientSecret = new BTextEditorPane();
        this.clientSecret.setVisibleColumns(80);
        this.clientSecret.setVisibleRows(10);
        ((BTextEditor)this.clientSecret.getContent()).setEditable(false);
        this.clientSecret.setText("null");
        mainGrid.add("title", (BValue)title);
        mainGrid.add("spacer", (BValue)new BLabel(" "));
        mainGrid.add("appNameLabel", (BValue)appNameLabel);
        mainGrid.add("appNAme", (BValue)this.appName);
        mainGrid.add("clientIdLabel", (BValue)clientIdLabel);
        mainGrid.add("clientId", (BValue)this.clientId);
        mainGrid.add("clientSecretLabel", (BValue)clientSecretLabel);
        mainGrid.add("editor", (BValue)this.clientSecret);
        BGridPane buttonsGrid = new BGridPane(3);
        GenerateClientCredentialsBtnCmd GenerateClientCredentialsCmd = new GenerateClientCredentialsBtnCmd((BWidget)this);
        ResetSecretBtnCmd ResetCredentialsCmd = new ResetSecretBtnCmd((BWidget)this);
        BButton GenerateClientCredentialsBtn = new BButton((Command)GenerateClientCredentialsCmd, true, false);
        GenerateClientCredentialsBtn.setText("Generate Credentials");
        buttonsGrid.add("generateClientCredentials", (BValue)GenerateClientCredentialsBtn);
        BButton ResetSecretBtn = new BButton((Command)ResetCredentialsCmd, true, false);
        ResetSecretBtn.setText("Reset Client Secret");
        buttonsGrid.add("resetSecret", (BValue)ResetSecretBtn);
        BEdgePane rootPane = new BEdgePane();
        rootPane.setBottom((BWidget)buttonsGrid);
        rootPane.setLeft((BWidget)mainGrid);
        this.setContent((BWidget)rootPane);
    }

    public void getClientsCredentialDetails(BOssApiClientCredentials credentials) {
        try {
            if (!credentials.isNull()) {
                BOssApiClientApplication application = (BOssApiClientApplication)credentials.getParent();
                this.appName.setText(application.getApplicationName());
                this.clientId.setText(credentials.getClientId());
                this.clientSecret.setText("Client secret can only be viewed when it is first generated");
            }
            if (this.appName.getText().isEmpty()) {
                this.appName.setText("You must give the application a name before credentials can be generated");
                this.clientSecret.setText("");
            }
        }
        catch (NullPointerException credException) {
            this.clientId.setText(" Client ID is null");
            this.clientSecret.setText("Client secret is null");
            credException.printStackTrace();
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        if (!this.firstTime) {
            return;
        }
        try {
            this.credentials = (BOssApiClientCredentials)value;
            this.application = (BOssApiClientApplication)this.credentials.getParent();
            this.firstTime = false;
            this.getClientsCredentialDetails(this.credentials);
        }
        catch (Exception loadException) {
            loadException.printStackTrace();
        }
    }

    public void deactivated() {
        this.clientSecret.setText("Client secret can only be viewed once");
        try {
            this.saveValue();
        }
        catch (Exception disableException) {
            disableException.printStackTrace();
        }
        super.deactivated();
    }

    public class ResetSecretBtnCmd
    extends Command {
        ResetSecretBtnCmd(BWidget owner) {
            super(owner, lex, "ossRestApiServer.cmd.ResetCredentials");
        }

        public CommandArtifact doInvoke() {
            if (BGenerateClientCredentialsView.this.appName.getText().equalsIgnoreCase("You must give the application a name before credentials can be generated") || BGenerateClientCredentialsView.this.appName.getText().isEmpty()) {
                String message = "Credentials have not been generated. ";
                BDialog.open((BWidget)this.getOwner(), (String)"Generate Client Credentials", (Object)message, (int)1, (BImage)BDialog.INFO_ICON);
                return null;
            }
            String message = "WARNING! Resetting the client credentials will cause any third party client application which is using them to lose communications. This cannot be undone - Are you sure you wish to reset the credentials ?";
            int result = BDialog.open((BWidget)this.getOwner(), (String)"Are you sure", (Object)message, (int)12, (BImage)BDialog.WARNING_ICON);
            if (result == 4) {
                String secret = BGenerateClientCredentialsView.this.application.changeClientSecret();
                BGenerateClientCredentialsView.this.clientSecret.setText(secret);
                BGenerateClientCredentialsView.this.application.grantUpdate();
            }
            return null;
        }
    }

    public class GenerateClientCredentialsBtnCmd
    extends Command {
        GenerateClientCredentialsBtnCmd(BWidget owner) {
            super(owner, lex, "ossRestApiServer.cmd.generateClientCredentialsButton");
        }

        public CommandArtifact doInvoke() {
            if (BGenerateClientCredentialsView.this.appName.getText().equalsIgnoreCase("You must give the application a name before credentials can be generated") || BGenerateClientCredentialsView.this.appName.getText().isEmpty()) {
                String message = "Application must have a name before credentials can be generated";
                BDialog.open((BWidget)this.getOwner(), (String)"Generate Client Credentials", (Object)message, (int)1, (BImage)BDialog.INFO_ICON);
                return null;
            }
            if (BGenerateClientCredentialsView.this.clientId.getText().isEmpty()) {
                String message = "WARNING: Please copy the client secret immediately after generation - Once you navigate away from this page the client secret will no longer be viewable. \n \n You should now send the client credentials (ID and secret) to the application owner in a secure manner.";
                BDialog.open((BWidget)this.getOwner(), (String)"Generate Client Credentials", (Object)message, (int)1, (BImage)BDialog.WARNING_ICON);
                BGenerateClientCredentialsView.this.application.generateClientCredentials();
                BGenerateClientCredentialsView.this.clientId.setText(BGenerateClientCredentialsView.this.credentials.getClientId());
                String secret = BGenerateClientCredentialsView.this.application.changeClientSecret();
                BGenerateClientCredentialsView.this.clientSecret.setText(secret);
                BGenerateClientCredentialsView.this.application.doGenerateAuthorizationGrant();
            } else {
                String message = "Client credentials already exist";
                BDialog.open((BWidget)this.getOwner(), (String)"Generate Client Credentials", (Object)message, (int)1, (BImage)BDialog.INFO_ICON);
            }
            return null;
        }
    }
}

