/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossRestApiServer.OssRestApiServerLicense;
import solutions.onesight.ossRestApiServer.OssRestApiServerLog;
import solutions.onesight.ossRestApiServer.resources.BApiResourceAllocation;
import solutions.onesight.ossRestApiServer.resources.BApiResourceDiscoveryJob;
import solutions.onesight.ossRestApiServer.resources.BApiResourceEntry;
import solutions.onesight.ossRestApiServer.resources.BApiResourceType;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="submitHistoryDiscoveryJob", parameterType="baja:Ord", defaultValue="BOrd.make( \"\" )", returnType="baja:Ord", flags=4), @NiagaraAction(name="submitPointDiscoveryJob", parameterType="baja:Ord", defaultValue="BOrd.make( \"\" )", returnType="baja:Ord", flags=4), @NiagaraAction(name="refresh")})
public final class BApiResourceList
extends BComponent {
    public static final Action submitHistoryDiscoveryJob = BApiResourceList.newAction((int)4, (BValue)BOrd.make((String)""), null);
    public static final Action submitPointDiscoveryJob = BApiResourceList.newAction((int)4, (BValue)BOrd.make((String)""), null);
    public static final Action refresh = BApiResourceList.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BApiResourceList.class);
    private final Set<String> historySet = new HashSet<String>(10);
    private final Set<String> pointSet = new HashSet<String>(10);

    public BOrd submitHistoryDiscoveryJob(BOrd parameter) {
        return (BOrd)this.invoke(submitHistoryDiscoveryJob, (BValue)parameter, null);
    }

    public BOrd submitPointDiscoveryJob(BOrd parameter) {
        return (BOrd)this.invoke(submitPointDiscoveryJob, (BValue)parameter, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.scanResources();
    }

    public BOrd doSubmitHistoryDiscoveryJob(BOrd rootOrd) {
        BApiResourceDiscoveryJob resourceDiscovery = new BApiResourceDiscoveryJob(BApiResourceType.History, rootOrd);
        return resourceDiscovery.submit(null);
    }

    public BOrd doSubmitPointDiscoveryJob(BOrd rootOrd) {
        BApiResourceDiscoveryJob resourceDiscovery = new BApiResourceDiscoveryJob(BApiResourceType.Point, rootOrd);
        return resourceDiscovery.submit(null);
    }

    public void doRefresh() {
        this.scanResources();
    }

    public void add(String resourcePath, BApiResourceType resourceType) {
        if (!this.isExisting(resourcePath)) {
            this.add(resourceType.toString().toLowerCase() + "1?", (BValue)new BApiResourceAllocation(resourcePath, resourceType));
        }
    }

    public void add(BApiResourceEntry resourceEntry) {
        this.add(resourceEntry.getResourcePath(), resourceEntry.getResourceType());
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context cxt) {
        if (this.isRunning() && value instanceof BApiResourceAllocation) {
            this.registerResource((BApiResourceAllocation)value);
        }
    }

    public void removed(Property prop, BValue oldValue, Context cxt) {
        if (this.isRunning() && oldValue instanceof BApiResourceAllocation) {
            this.removeResource((BApiResourceAllocation)oldValue);
        }
    }

    public void scanResources() {
        this.lease();
        OssRestApiServerLicense.resetResourceCount();
        this.historySet.clear();
        this.pointSet.clear();
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BApiResourceAllocation)) continue;
            this.registerResource((BApiResourceAllocation)childItem);
        }
    }

    public boolean isExisting(String resourcePath) {
        boolean pathFound = false;
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BApiResourceAllocation) || !((BApiResourceAllocation)childItem).getResourcePath().equals(resourcePath)) continue;
            pathFound = true;
            break;
        }
        return pathFound;
    }

    public boolean registerResource(BApiResourceAllocation newResource) {
        String faultMessage;
        boolean success = false;
        BApiResourceType type = newResource.getResourceType();
        if (type.equals((Object)BApiResourceType.History)) {
            OssRestApiServerLicense.incrementHistoryCount();
            if (OssRestApiServerLicense.checkHistoryLimit()) {
                this.historySet.add(newResource.getResourcePath());
                newResource.setStatus(BStatus.ok);
                newResource.setFaultCause("");
                success = true;
            } else {
                newResource.setStatus(BStatus.fault);
                faultMessage = OssRestApiServerLicense.isHistoryLicensed() ? (OssRestApiServerLicense.getResourceLimit() > 0 ? "Exceeded resource license limit" : "Exceeded history license limit") : "Histories not licensed";
                newResource.setFaultCause(faultMessage);
                OssRestApiServerLog.getLog().warning(faultMessage);
            }
        }
        if (type.equals((Object)BApiResourceType.Point)) {
            OssRestApiServerLicense.incrementPointCount();
            if (OssRestApiServerLicense.checkPointLimit()) {
                this.pointSet.add(newResource.getResourcePath());
                newResource.setStatus(BStatus.ok);
                newResource.setFaultCause("");
                success = true;
            } else {
                newResource.setStatus(BStatus.fault);
                faultMessage = OssRestApiServerLicense.isPointsLicensed() ? (OssRestApiServerLicense.getResourceLimit() > 0 ? "Exceeded resource license limit" : "Exceeded point license limit") : "Points not licensed";
                newResource.setFaultCause(faultMessage);
                OssRestApiServerLog.getLog().warning(faultMessage);
            }
        }
        return success;
    }

    public void removeResource(BApiResourceAllocation resource) {
        BApiResourceType type = resource.getResourceType();
        if (type.equals((Object)BApiResourceType.History)) {
            this.historySet.remove(resource.getResourcePath());
            OssRestApiServerLicense.decrementHistoryCount();
        }
        if (type.equals((Object)BApiResourceType.Point)) {
            this.pointSet.remove(resource.getResourcePath());
            OssRestApiServerLicense.decrementPointCount();
        }
    }

    public String[] getSubtree(String nodePath) {
        ArrayList<String> resources = new ArrayList<String>();
        for (BComponent childItem : this.getChildComponents()) {
            if (!(childItem instanceof BApiResourceAllocation) || !((BApiResourceAllocation)childItem).getResourcePath().startsWith(nodePath)) continue;
            resources.add(((BApiResourceAllocation)childItem).getResourcePath());
        }
        return resources.toArray(new String[0]);
    }

    public boolean checkHistory(String historyPath) {
        return this.historySet.contains(historyPath);
    }

    public boolean checkPoint(String pointPath) {
        return this.pointSet.contains(pointPath);
    }

    public boolean checkTree(String pointPath) {
        for (String point : this.pointSet) {
            if (!point.startsWith(pointPath)) continue;
            return true;
        }
        return false;
    }
}

