/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.resources;

import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import solutions.onesight.ossRestApiServer.resources.BApiResourceEntry;
import solutions.onesight.ossRestApiServer.resources.BApiResourceType;

@NiagaraType
@NiagaraProperty(name="resourcePaths", type="BFolder", defaultValue="new BFolder()", flags=7)
public final class BApiResourceDiscoveryJob
extends BSimpleJob {
    public static final Property resourcePaths = BApiResourceDiscoveryJob.newProperty((int)7, (BValue)new BFolder(), null);
    public static final Type TYPE = Sys.loadType(BApiResourceDiscoveryJob.class);
    private BApiResourceType resourceType = BApiResourceType.Invalid;
    private BOrd rootOrd = null;
    private int foundCount = 0;
    private boolean cancelOperation = false;

    public BFolder getResourcePaths() {
        return (BFolder)this.get(resourcePaths);
    }

    public void setResourcePaths(BFolder v) {
        this.set(resourcePaths, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BApiResourceDiscoveryJob() {
        this.resourceType = BApiResourceType.Invalid;
        this.rootOrd = null;
        this.cancelOperation = false;
    }

    public BApiResourceDiscoveryJob(BApiResourceType newResourceType, BOrd newRootOrd) {
        this.resourceType = newResourceType;
        this.rootOrd = newRootOrd;
        this.cancelOperation = false;
    }

    public void run(Context cxt) throws Exception {
        this.progress(0);
        this.foundCount = 0;
        if (this.resourceType.equals((Object)BApiResourceType.Point)) {
            this.discoverPoints();
        } else if (this.resourceType.equals((Object)BApiResourceType.History)) {
            this.discoverHistory();
        } else {
            this.log().message("ERROR: Invalid resource type: " + this.resourceType.getOrdinal());
            throw new IllegalArgumentException("Invalid resource type: " + this.resourceType.getOrdinal());
        }
        this.progress(100);
    }

    private void discoverPoints() {
        if (this.rootOrd == null) {
            this.log().message("ERROR: Point root is not defined");
            throw new NullPointerException();
        }
        try {
            this.log().message("Points search in " + this.rootOrd.encodeToString());
            int slotIndex = this.rootOrd.encodeToString().indexOf("slot:");
            String pointRoot = "";
            if (slotIndex >= 0) {
                pointRoot = this.rootOrd.encodeToString().substring(slotIndex) + "|";
            }
            BComponent stationRoot = (BComponent)this.rootOrd.get();
            stationRoot.lease();
            BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
            String pointsBqlQuery = pointRoot + "bql:select slotPath as 'slotPath' from control:ControlPoint order by slotPath";
            BITable table = null;
            try {
                table = (BITable)BOrd.make((String)pointsBqlQuery).get((BObject)station);
            }
            catch (SyntaxException querySyntaxException) {
                if (querySyntaxException.getCause() instanceof IOException) {
                    throw new IllegalArgumentException(querySyntaxException.getCause().getMessage());
                }
                throw querySyntaxException;
            }
            ColumnList columns = table.getColumns();
            TableCursor cursor = table.cursor();
            while (cursor.next()) {
                for (int i = 0; i < columns.size(); ++i) {
                    Column c = columns.get(i);
                    if (!c.getDisplayName(null).equals("slotPath")) continue;
                    String slotPath = cursor.cell(c).toString();
                    if (slotPath.startsWith("slot:")) {
                        slotPath = slotPath.substring(5);
                    }
                    this.log().message("Found point: " + slotPath);
                    this.getResourcePaths().add("point1?", (BValue)new BApiResourceEntry(slotPath, BApiResourceType.Point));
                    ++this.foundCount;
                }
            }
            this.log().message("Found " + this.foundCount + " points");
        }
        catch (Exception discoverEx) {
            this.log().message("ERROR: Point discovery exception: " + discoverEx);
            throw discoverEx;
        }
    }

    private void discoverHistory() {
        if (this.rootOrd == null || this.rootOrd.toString().isEmpty()) {
            this.log().message("ERROR: History search root is not defined");
            throw new NullPointerException();
        }
        try {
            this.log().message("History search");
            BComponent stationRoot = ((BComponent)this.rootOrd.get()).getComponentSpace().getRootComponent();
            stationRoot.lease();
            String historyBqlQuery = "history:|bql:select id";
            BITable table = null;
            try {
                table = (BITable)BOrd.make((String)historyBqlQuery).get((BObject)stationRoot);
            }
            catch (SyntaxException querySyntaxException) {
                if (querySyntaxException.getCause() instanceof IOException) {
                    throw new IllegalArgumentException(querySyntaxException.getCause().getMessage());
                }
                throw querySyntaxException;
            }
            ColumnList columns = table.getColumns();
            TableCursor cursor = table.cursor();
            while (cursor.next()) {
                for (int i = 0; i < columns.size(); ++i) {
                    Column c = columns.get(i);
                    if (!c.getDisplayName(null).equals("Id")) continue;
                    String slotPath = cursor.cell(c).toString();
                    this.log().message("Found history: " + slotPath);
                    this.getResourcePaths().add("history1?", (BValue)new BApiResourceEntry(slotPath, BApiResourceType.History));
                    ++this.foundCount;
                }
            }
            this.log().message("Found " + this.foundCount + " histories");
        }
        catch (Exception discoverEx) {
            this.log().message("ERROR: History discovery exception: " + discoverEx);
            throw discoverEx;
        }
    }

    public void doCancel(Context cxt) {
        this.cancelOperation = true;
    }
}

