/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.auth.login;

import com.tridium.authn.NiagaraFailedLoginException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.authn.AuthenticationUtil;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import solutions.onesight.ossRestApiServer.BOssRestApiService;

public class OAuthLoginModule
implements LoginModule {
    private static final BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> sharedState;
    private Map<String, ?> options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private BUser user = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        BOssRestApiService.log.finest("OAuth Login Module initialised");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        char[] password;
        char[] tempPassword;
        String username;
        BOssRestApiService.log.finest("OAuth Login Module login() method was called");
        if (this.callbackHandler == null) {
            throw new LoginException("CallbackHandler cannot be null for username and password login");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("name"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            if (username.isEmpty()) {
                return false;
            }
            tempPassword = ((PasswordCallback)callbacks[1]).getPassword();
            password = new char[tempPassword.length];
            System.arraycopy(tempPassword, 0, password, 0, tempPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (UnsupportedCallbackException var8) {
            String msg = "Provided callback handler could not handle: " + var8.getCallback().toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)var8);
            throw new LoginException(msg);
        }
        catch (Exception var9) {
            String msg = "Error handling callbacks:" + var9.toString();
            AuthenticationUtil.debug((Level)Level.SEVERE, (String)msg, (Throwable)var9);
            throw new LoginException(msg);
        }
        this.user = userService.getUser(username);
        if (this.user != null && this.user.getAuthenticator() instanceof BPasswordCache && ((BPasswordCache)this.user.getAuthenticator()).validate(new String(password))) {
            this.succeeded = true;
            return true;
        }
        tempPassword = password;
        int var12 = password.length;
        for (int var6 = 0; var6 < var12; ++var6) {
            char var10000 = tempPassword[var6];
            boolean bl = false;
        }
        this.succeeded = false;
        Object loginException = null;
        loginException = this.user != null ? new NiagaraFailedLoginException(this.user.getName(), "Login failed: Invalid username or password.") : (this.user != null && this.user.getAuthenticator() instanceof BPasswordCache ? new FailedLoginException("Login failed: expected a username and password.") : new FailedLoginException("Login failed: Invalid username or password."));
        this.user = null;
        throw loginException;
    }

    @Override
    public boolean commit() {
        return !this.succeeded ? false : AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (!OAuthLoginModule.this.subject.getPrincipals().contains(OAuthLoginModule.this.user)) {
                    OAuthLoginModule.this.subject.getPrincipals().add((Principal)OAuthLoginModule.this.user);
                }
                OAuthLoginModule.this.commitSucceeded = true;
                return true;
            }
        });
    }

    @Override
    public boolean abort() {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (OAuthLoginModule.this.user != null) {
                    OAuthLoginModule.this.subject.getPrincipals().remove(OAuthLoginModule.this.user);
                }
                OAuthLoginModule.this.succeeded = false;
                OAuthLoginModule.this.commitSucceeded = false;
                OAuthLoginModule.this.user = null;
                return true;
            }
        });
    }

    private static BUserService getUserService() {
        return (BUserService)Sys.getService((Type)BUserService.TYPE);
    }
}

