/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.auth.login;

import com.tridium.saml.authnScheme.SAMLCallback;
import java.io.IOException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.BWebCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"ossRestApiServer:OAuthAuthenticationScheme"})})
public class BWebOAuthCallbackHandler
extends BWebCallbackHandler {
    public static final Type TYPE = Sys.loadType(BWebOAuthCallbackHandler.class);
    private String username = null;

    public Type getType() {
        return TYPE;
    }

    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String uriPath = req.getRequestURI();
        if (uriPath.equalsIgnoreCase("/ossRestApiServer/token")) {
            resp.sendRedirect("ossRestApiServer/noauth/");
            return 1;
        }
        if (uriPath.equalsIgnoreCase("/ossRestApiServer/token/renew")) {
            resp.sendRedirect("ossRestApiServer/token/renew");
            return 1;
        }
        if (uriPath.startsWith("/ossRestApiServer/query")) {
            resp.sendRedirect("ossRestApiServer/query/");
            return 1;
        }
        return 0;
    }

    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        Callback[] cb = callbacks;
        int cblen = callbacks.length;
        for (int cbIndex = 0; cbIndex < cblen; ++cbIndex) {
            Callback callback = cb[cbIndex];
            if (callback instanceof SAMLCallback) continue;
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }
}

