/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.auth;

import java.util.Random;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="value", type="baja:Password", defaultValue="BPassword.DEFAULT", flags=1), @NiagaraProperty(name="timeGenerated", type="baja:AbsTime", defaultValue="BAbsTime.make()", flags=1), @NiagaraProperty(name="validTime", type="baja:RelTime", defaultValue="BRelTime.make(10000)", flags=1)})
public class BAuthToken
extends BComponent {
    public static final Property value = BAuthToken.newProperty((int)1, (BValue)BPassword.DEFAULT, null);
    public static final Property timeGenerated = BAuthToken.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property validTime = BAuthToken.newProperty((int)1, (BValue)BRelTime.make((long)10000L), null);
    public static final Type TYPE = Sys.loadType(BAuthToken.class);
    private static final BIcon icon = BIcon.std((String)"colorWheel.png");
    public static final BAuthToken DEFAULT = new BAuthToken("invalid", BAbsTime.make((long)0L), BRelTime.make((long)0L));

    public BPassword getValue() {
        return (BPassword)this.get(value);
    }

    public void setValue(BPassword v) {
        this.set(value, (BValue)v, null);
    }

    public BAbsTime getTimeGenerated() {
        return (BAbsTime)this.get(timeGenerated);
    }

    public void setTimeGenerated(BAbsTime v) {
        this.set(timeGenerated, (BValue)v, null);
    }

    public BRelTime getValidTime() {
        return (BRelTime)this.get(validTime);
    }

    public void setValidTime(BRelTime v) {
        this.set(validTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAuthToken(String value, BAbsTime timeGenerated, BRelTime validTime) {
        this.setValue(BPassword.make((String)value));
        this.setTimeGenerated(timeGenerated);
        this.setValidTime(validTime);
    }

    public BAuthToken() {
        this.setValue(BPassword.make((String)BAuthToken.makeInvalidPassword()));
        this.setTimeGenerated(BAbsTime.make((long)0L));
        this.setValidTime(BRelTime.make((long)0L));
    }

    public boolean isDefault() {
        return this.getValue().getValue().equalsIgnoreCase("invalid");
    }

    public boolean tokenHasExpired() {
        BAbsTime timeGenerated = this.getTimeGenerated();
        BRelTime validPeriod = this.getValidTime();
        BAbsTime expiry = timeGenerated.add(validPeriod);
        return BAbsTime.now().isAfter(expiry);
    }

    public BIcon getIcon() {
        return icon;
    }

    public static String makeInvalidPassword() {
        return new String("invalid" + System.currentTimeMillis() / (long)new Random().nextInt(7654321));
    }
}

