/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer.auth;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import solutions.onesight.ossRestApiServer.BOssApiAuthGrant;
import solutions.onesight.ossRestApiServer.BOssApiClientApplication;
import solutions.onesight.ossRestApiServer.BOssRestApiService;
import solutions.onesight.ossRestApiServer.OssRestApiServerLicense;
import solutions.onesight.ossRestApiServer.auth.BAuthServer;
import solutions.onesight.ossRestApiServer.auth.BAuthToken;
import solutions.onesight.ossRestApiServer.auth.OAuthClientApp;

public class AuthServlet
extends UnauthenticatedServlet {
    private int maxFailedAuthAttempts = 50;
    private boolean debugEnabled = false;
    private ArrayList<OAuthClientApp> appList;
    private final BOssRestApiService apiService = (BOssRestApiService)Sys.getService((Type)BOssRestApiService.TYPE);
    private static final int DEFAULT_MAX_FAILED_AUTH_ATTEMPTS = 50;
    private static final long serialVersionUID = 3L;

    public boolean checkSchemeIsAllowed(HttpServletRequest request) {
        BAuthServer authServer = this.apiService.getAuthServer();
        if (!authServer.getHttpsOnly()) {
            return true;
        }
        String scheme = request.getScheme();
        return scheme.equalsIgnoreCase("https");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block8: {
            try {
                OssRestApiServerLicense.checkLicense();
                if (!this.apiService.isRunning()) {
                    this.failureResponse(response, 400, "OssRestApiServer not running");
                    return;
                }
                if (this.apiService.isDisabled()) {
                    this.failureResponse(response, 400, "OssRestApiServer disabled");
                    return;
                }
                BOssRestApiService.log.finest("POST request received by Auth Servlet");
                String pathInfo = request.getPathInfo();
                BOssRestApiService.log.finest("request path Info is " + pathInfo);
                if (!this.checkSchemeIsAllowed(request)) {
                    this.failureResponse(response, 400, "HTTP not permitted");
                    return;
                }
                if (pathInfo != null && pathInfo.equalsIgnoreCase("/renew")) {
                    BOssRestApiService.log.finest("Handling token refresh request...");
                    this.processRefreshRequest(request, response);
                    return;
                }
                BOssRestApiService.log.finest("Handling token request...");
                this.processTokenRequest(request, response);
            }
            catch (FeatureNotLicensedException fnle) {
                this.failureResponse(response, 400, "OssRestApiServer is not licensed to run on this host");
            }
            catch (OAuthProblemException authEx) {
                this.failureResponse(response, 400, "Invalid token request");
            }
            catch (Exception ex) {
                this.failureResponse(response, 400, "Unexpected error");
                if (!this.debugEnabled) break block8;
                ex.printStackTrace();
            }
        }
    }

    private void processTokenRequest(HttpServletRequest request, HttpServletResponse response) throws OAuthProblemException, IOException, OAuthSystemException {
        OAuthTokenRequest oauthRequest = new OAuthTokenRequest(request);
        OAuthValidationResult validationResult = this.validateClient(oauthRequest);
        boolean success = validationResult.succeeded;
        if (success) {
            this.generateTokensAndSendResponse(validationResult, response);
        } else {
            BOssRestApiService.log.finest(validationResult.toString());
            try {
                BOssApiClientApplication thisClientApp = this.getThisClientsBOssApiClientApplication(validationResult.clientAttemptingAuth);
                BOssApiAuthGrant thisAuthGrant = thisClientApp.getAuthGrant();
                thisAuthGrant.setFaultCause(validationResult.toFaultString());
                thisAuthGrant.setFaultTime(BAbsTime.now());
            }
            catch (NullPointerException ex) {
                BOssRestApiService.log.finest("No client was found that matches the Client ID supplied");
                response.setContentType("text/html");
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "Bearer");
                response.getWriter().println("<head><title>UNAUTHORIZED</title></head>");
                response.getWriter().println("<body>Authentication failed</body>");
                return;
            }
            response.setContentType("text/html");
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Bearer");
            response.getWriter().println("<head><title>Authentication Error</title></head>");
            if (this.debugEnabled) {
                response.getWriter().println("<body><pre>" + validationResult + "</pre></body>");
            } else {
                response.getWriter().println("<body>Request validation failed</body>");
            }
        }
    }

    private void generateTokensAndSendResponse(OAuthValidationResult validationResult, HttpServletResponse response) {
        try {
            try {
                OAuthIssuerImpl oauthIssuerImpl = new OAuthIssuerImpl(new MD5Generator());
                String accessToken = oauthIssuerImpl.accessToken();
                String refreshToken = oauthIssuerImpl.refreshToken();
                BAuthToken bAccessToken = new BAuthToken(accessToken, BAbsTime.now(), BRelTime.make((long)this.getTokenExpiryTime()));
                BOssApiClientApplication thisClientApp = this.getThisClientsBOssApiClientApplication(validationResult.clientAttemptingAuth);
                BOssApiAuthGrant thisAuthGrant = thisClientApp.getAuthGrant();
                thisAuthGrant.setAuthToken(bAccessToken);
                thisAuthGrant.setRefreshToken(BPassword.make((String)refreshToken));
                Sys.getStation().save();
                OAuthResponse r = OAuthASResponse.tokenResponse(200).setAccessToken(accessToken).setExpiresIn(Long.toString(this.getTokenExpiryTime())).setRefreshToken(refreshToken).buildJSONMessage();
                response.setContentType("application/json; charset=UTF-8");
                response.addHeader("token_type", "bearer");
                response.addHeader("Cache-Control", "no-store");
                response.addHeader("Pragma", "no-cache");
                response.setStatus(r.getResponseStatus());
                PrintWriter pw = response.getWriter();
                pw.print(r.getBody());
                pw.flush();
                pw.close();
            }
            catch (OAuthSystemException authException) {
                BOssRestApiService.log.warning("OAuth System Exception");
                authException.printStackTrace();
                response.setContentType("text/html");
                response.setStatus(500);
                response.getWriter().println("<head><title>OAuth System Exception</title></head>");
                response.getWriter().println("<body>OAuth System Exception</body>");
            }
        }
        catch (IOException authException) {
            BOssRestApiService.log.severe("OAuth IO Exception");
            authException.printStackTrace();
        }
    }

    private void processRefreshRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String tokenAttemptingAuth = request.getHeader("authorization");
        if (tokenAttemptingAuth == null) {
            BOssRestApiService.log.warning("No token found - Unauthenticated request received.");
            response.setContentType("text/html");
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Bearer");
            response.getWriter().println("<head><title>Authentication Error</title></head>");
            response.getWriter().println("<body>Invalid authentication token</body>");
            return;
        }
        try {
            tokenAttemptingAuth = tokenAttemptingAuth.substring(tokenAttemptingAuth.indexOf("Bearer ") + 7);
            BOssRestApiService.log.finest("tokenAttemptingAuth is " + tokenAttemptingAuth);
        }
        catch (Exception ex) {
            BOssRestApiService.log.warning("Invalid token received");
            response.setContentType("text/html");
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Bearer");
            response.getWriter().println("<head><title>Authentication Error</title></head>");
            response.getWriter().println("<body>Invalid authentication token</body>");
            return;
        }
        BOssApiClientApplication[] allClientApps = (BOssApiClientApplication[])this.apiService.getChildren(BOssApiClientApplication.class);
        for (int i = 0; i < allClientApps.length; ++i) {
            BOssApiClientApplication currentApp = allClientApps[i];
            try {
                final BOssApiAuthGrant currentGrant = currentApp.getAuthGrant();
                String currentTokenValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        BPassword refreshToken = (BPassword)currentGrant.get("refreshToken");
                        return refreshToken.getValue();
                    }
                });
                this.debugEnabled = currentApp.getDebugEnabled();
                if (!currentTokenValue.equalsIgnoreCase(tokenAttemptingAuth)) continue;
                BOssRestApiService.log.finest("Request successfully authorized");
                currentGrant.setFaultCause("");
                currentGrant.setFaultTime(BAbsTime.make());
                OAuthValidationResult validationResult = new OAuthValidationResult(currentApp.getOAuthClientApp(), true, true, true, true, true, true, true, true);
                this.generateTokensAndSendResponse(validationResult, response);
                return;
            }
            catch (NullPointerException ex) {
                BOssRestApiService.log.warning("One or more client applications do not have an authorisation grant");
                if (!this.debugEnabled) continue;
                BOssRestApiService.log.warning("processRefreshRequest threw an exception - check for client applications without an auth grant");
                ex.printStackTrace();
            }
        }
        BOssRestApiService.log.finest("No matching refresh token was found");
        response.setContentType("text/html");
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "Bearer");
        response.getWriter().println("<head><title>Authentication Error</title></head>");
        response.getWriter().println("<body>Request validation failed</body>");
    }

    private OAuthValidationResult validateClient(OAuthTokenRequest request) {
        boolean succeeded;
        OAuthClientApp clientAttemptingAuth = this.checkClientIdAndReturnAppData(request);
        boolean clientIdIsRegistered = clientAttemptingAuth != null;
        boolean clientIdNotAlreadyAuthorized = this.clientIdIsNotAlreadyAuthorized(clientAttemptingAuth);
        boolean maxFailAuthAttemptsOk = !this.exceededMaxFailedAuthAttempts(clientAttemptingAuth);
        boolean clientSecretIsValid = this.clientSecretIsValid(request, clientAttemptingAuth);
        boolean validTimeOk = this.clientGrantIsNotExpired(clientAttemptingAuth);
        boolean clientApplicationEnabled = this.clientIsEnabled(clientAttemptingAuth);
        boolean scopeIsAllowed = this.clientScopeIsValid(request, clientAttemptingAuth);
        boolean bl = succeeded = clientIdIsRegistered && validTimeOk && scopeIsAllowed && clientApplicationEnabled && clientIdNotAlreadyAuthorized && maxFailAuthAttemptsOk && clientSecretIsValid;
        if (succeeded) {
            BOssApiClientApplication app = this.getThisClientsBOssApiClientApplication(clientAttemptingAuth);
            app.getAuthGrant().authorize();
        }
        if (!succeeded) {
            this.recordFailedAuthAttempt(clientAttemptingAuth);
        }
        OAuthValidationResult result = new OAuthValidationResult(clientAttemptingAuth, succeeded, clientIdIsRegistered, validTimeOk, scopeIsAllowed, clientApplicationEnabled, clientIdNotAlreadyAuthorized, maxFailAuthAttemptsOk, clientSecretIsValid);
        BOssRestApiService.log.finest(result.toString());
        return result;
    }

    private OAuthClientApp checkClientIdAndReturnAppData(OAuthTokenRequest oauthRequest) {
        this.buildRegisteredApplicationList();
        String clientIdProvided = oauthRequest.getClientId();
        for (int i = 0; i < this.appList.size(); ++i) {
            String currentClientId = this.appList.get((int)i).clientID;
            if (!clientIdProvided.equalsIgnoreCase(currentClientId)) continue;
            BOssApiClientApplication currentClientApp = this.getThisClientsBOssApiClientApplication(currentClientId);
            this.debugEnabled = currentClientApp.getDebugEnabled();
            return this.appList.get(i);
        }
        BOssRestApiService.log.finest("No matching client ID found");
        return null;
    }

    private boolean clientSecretIsValid(OAuthTokenRequest oauthRequest, OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            BOssRestApiService.log.finest("Null Client - checkForRegisteredClientId must match a registered client before client secret validation can occur.");
            return false;
        }
        String secretProvided = oauthRequest.getClientSecret();
        String expectedSecret = clientAttemptingAuth.clientSecret;
        secretProvided = secretProvided.replace("\n", "");
        expectedSecret = expectedSecret.replace("\n", "");
        return secretProvided.equalsIgnoreCase(expectedSecret);
    }

    private boolean clientScopeIsValid(OAuthTokenRequest oauthRequest, OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            BOssRestApiService.log.finest("Null Client - checkForRegisteredClientId must match a registered client before client scope validation can occur.");
            return false;
        }
        Set<String> scopes = oauthRequest.getScopes();
        Iterator<String> n = scopes.iterator();
        boolean requestedReadAccess = false;
        boolean requestedWriteAccess = false;
        while (n.hasNext()) {
            String next = n.next().toString();
            if (next.equalsIgnoreCase("write")) {
                requestedWriteAccess = true;
                continue;
            }
            if (next.equalsIgnoreCase("read")) {
                requestedReadAccess = true;
                continue;
            }
            BOssRestApiService.log.warning("Unexpected scope requested: " + next);
        }
        boolean allowedWriteAccess = clientAttemptingAuth.writeAccess;
        if (requestedWriteAccess) {
            return allowedWriteAccess;
        }
        return true;
    }

    private boolean clientIdIsNotAlreadyAuthorized(OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            return false;
        }
        BAuthServer authServer = this.apiService.getAuthServer();
        if (!authServer.getBlockCredentialReuse()) {
            return true;
        }
        return !clientAttemptingAuth.authorized;
    }

    private boolean clientGrantIsNotExpired(OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            return false;
        }
        return !clientAttemptingAuth.grantExpired;
    }

    private boolean clientIsEnabled(OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            return false;
        }
        return clientAttemptingAuth.enabled;
    }

    private boolean exceededMaxFailedAuthAttempts(OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            return false;
        }
        BAuthServer authServer = this.apiService.getAuthServer();
        if (!authServer.getBlockRepeatedFailedAuthAttempts()) {
            return false;
        }
        this.maxFailedAuthAttempts = this.getMaxFailedAuthAttempts();
        return clientAttemptingAuth.failedAuthAttempts >= this.maxFailedAuthAttempts;
    }

    private void recordFailedAuthAttempt(OAuthClientApp clientAttemptingAuth) {
        try {
            ++clientAttemptingAuth.failedAuthAttempts;
            this.getThisClientsBOssApiClientApplication(clientAttemptingAuth).setFailedAuthAttempts(clientAttemptingAuth.failedAuthAttempts);
        }
        catch (NullPointerException ex) {
            BOssRestApiService.log.finest("Cannot record a failed auth attempt for a null client");
        }
    }

    public void buildRegisteredApplicationList() {
        this.appList = new ArrayList();
        final BComponent[] appComponentList = (BComponent[])this.apiService.getChildren(BOssApiClientApplication.class);
        for (int i = 0; i < appComponentList.length; ++i) {
            String appName = ((BOssApiClientApplication)appComponentList[i]).getApplicationName();
            String clientID = ((BOssApiClientApplication)appComponentList[i]).getClientCredentials().getClientId();
            final int appIndex = i;
            String clientSecret = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return ((BOssApiClientApplication)appComponentList[appIndex]).getClientCredentials().getClientSecret().getValue();
                }
            });
            boolean enabled = ((BOssApiClientApplication)appComponentList[i]).getEnabled();
            boolean writeAllowed = ((BOssApiClientApplication)appComponentList[i]).writeIsAllowed();
            boolean grantExpired = ((BOssApiClientApplication)appComponentList[i]).grantHasExpired();
            boolean authorized = ((BOssApiClientApplication)appComponentList[i]).getAuthorized();
            int failedAuthAttempts = ((BOssApiClientApplication)appComponentList[i]).getFailedAuthAttempts();
            this.appList.add(new OAuthClientApp(appName, enabled, writeAllowed, grantExpired, clientID, clientSecret, authorized, failedAuthAttempts));
        }
    }

    private BOssApiClientApplication getThisClientsBOssApiClientApplication(OAuthClientApp clientAttemptingAuth) {
        if (clientAttemptingAuth == null) {
            BOssRestApiService.log.finest("Client is null - Could not return a BOssApiClientApplication");
            return null;
        }
        BComponent[] appComponentList = (BComponent[])this.apiService.getChildren(BOssApiClientApplication.class);
        for (int i = 0; i < appComponentList.length; ++i) {
            BOssApiClientApplication nextClient = (BOssApiClientApplication)appComponentList[i];
            String nextClientID = nextClient.getClientCredentials().getClientId();
            if (!clientAttemptingAuth.clientID.equals(nextClientID)) continue;
            return nextClient;
        }
        BOssRestApiService.log.finest("Could not find a matching BOssApiClientApplication for thisClient. client is not registered");
        return null;
    }

    private BOssApiClientApplication getThisClientsBOssApiClientApplication(String clientId) {
        if (clientId == null) {
            BOssRestApiService.log.finest("Client is null - Could not return a BOssApiClientApplication");
            return null;
        }
        BComponent[] appComponentList = (BComponent[])this.apiService.getChildren(BOssApiClientApplication.class);
        for (int i = 0; i < appComponentList.length; ++i) {
            BOssApiClientApplication nextClient = (BOssApiClientApplication)appComponentList[i];
            String nextClientID = nextClient.getClientCredentials().getClientId();
            if (!clientId.equals(nextClientID)) continue;
            return nextClient;
        }
        BOssRestApiService.log.finest("Could not find a matching BOssApiClientApplication for thisClient - client is not registered");
        return null;
    }

    private int getMaxFailedAuthAttempts() {
        BComponent[] authServer = (BComponent[])this.apiService.getChildren(BAuthServer.class);
        if (authServer.length < 1) {
            BOssRestApiService.log.severe("OssRestApiService does not have a valid auth server");
            return 50;
        }
        return ((BAuthServer)authServer[0]).getMaxFailedAuthAttempts();
    }

    private long getTokenExpiryTime() {
        BComponent[] authServer = (BComponent[])this.apiService.getChildren(BAuthServer.class);
        if (authServer.length < 1) {
            BOssRestApiService.log.severe("Warning: OssRestApiService does not have a valid auth server");
            return 3600000L;
        }
        BRelTime expiry = ((BAuthServer)authServer[0]).getTokenExpiryTime();
        return expiry.getMillis();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block6: {
            try {
                OssRestApiServerLicense.checkLicense();
                if (!this.apiService.isRunning()) {
                    this.failureResponse(response, 400, "OssRestApiServer not running");
                    return;
                }
                if (this.apiService.isDisabled()) {
                    this.failureResponse(response, 400, "OssRestApiServer disabled");
                    return;
                }
                if (!this.checkSchemeIsAllowed(request)) {
                    BOssRestApiService.log.finest("Received a request with an Invalid Scheme - HTTP requests are not allowed.");
                    response.setContentType("text/html");
                    response.setStatus(400);
                    response.getWriter().println("<head><title>Invalid Request</title></head>");
                    response.getWriter().println("<body>HTTP not permitted</body>");
                    return;
                }
                BOssRestApiService.log.finest("GET request received by Auth Servlet - GET is not permitted");
                response.setContentType("text/html");
                response.setStatus(405);
                response.getWriter().println("<head><title>Invalid Request</title></head>");
                response.getWriter().println("<body>GET requests are not permitted</body>");
            }
            catch (FeatureNotLicensedException fnle) {
                this.failureResponse(response, 400, "OssRestApiServer is not licensed to run on this host");
            }
            catch (Exception ex) {
                this.failureResponse(response, 400, "Unexpected error");
                if (!this.debugEnabled) break block6;
                ex.printStackTrace();
            }
        }
    }

    private void failureResponse(HttpServletResponse response, int statusCode, String logMessage) throws IOException {
        BOssRestApiService.log.severe(logMessage);
        response.setContentType("text/html");
        response.setStatus(statusCode);
        response.getWriter().println("<head><title>Bad Request</title></head>");
        response.getWriter().println("<body>");
        response.getWriter().println("<h1>Bad Request</h1>");
        response.getWriter().println("<p>" + logMessage + "</p>");
        response.getWriter().println("</body>");
    }

    public class OAuthValidationResult {
        OAuthClientApp clientAttemptingAuth;
        boolean succeeded;
        boolean clientIdIsRegistered;
        boolean validTimeOk;
        boolean scopeIsAllowed;
        boolean clientApplicationEnabled;
        boolean clientIdNotAlreadyAuthorized;
        boolean maxFailAuthAttemptsOk;
        boolean clientSecretIsValid;

        public OAuthValidationResult(OAuthClientApp clientAttemptingAuth, boolean succeeded, boolean clientIdIsRegistered, boolean validTimeOk, boolean scopeIsAllowed, boolean clientApplicationEnabled, boolean clientIdNotAlreadyAuthorized, boolean maxFailAuthAttemptsOk, boolean clientSecretIsValid) {
            this.clientAttemptingAuth = clientAttemptingAuth;
            this.succeeded = succeeded;
            this.clientIdIsRegistered = clientIdIsRegistered;
            this.validTimeOk = validTimeOk;
            this.scopeIsAllowed = scopeIsAllowed;
            this.clientApplicationEnabled = clientApplicationEnabled;
            this.clientIdNotAlreadyAuthorized = clientIdNotAlreadyAuthorized;
            this.maxFailAuthAttemptsOk = maxFailAuthAttemptsOk;
            this.clientSecretIsValid = clientSecretIsValid;
        }

        public String toString() {
            String result = "The result of validating the OAuth token request was:";
            result = result + "\n  > Client ID Registered: " + this.clientIdIsRegistered;
            result = result + "\n  > Grant expiry ok: " + this.validTimeOk;
            result = result + "\n  > Scope is ok: " + this.scopeIsAllowed;
            result = result + "\n  > Niagara component enabled: " + this.clientApplicationEnabled;
            result = result + "\n  > Credentials are not reused: " + this.clientIdNotAlreadyAuthorized;
            result = result + "\n  > Below max Auth fails: " + this.maxFailAuthAttemptsOk;
            result = result + "\n  > Secret valid: " + this.clientSecretIsValid;
            result = result + "\nOverall Success = " + this.succeeded + "\n";
            return result;
        }

        public String toFaultString() {
            String result = "Authentication failed: ";
            if (!this.clientIdIsRegistered) {
                result = result + "ClientID ";
            }
            if (!this.clientSecretIsValid) {
                result = result + "ClientSecret ";
            }
            if (!this.clientApplicationEnabled) {
                result = result + "Enabled ";
            }
            if (!this.validTimeOk) {
                result = result + "GrantExpiry ";
            }
            if (!this.scopeIsAllowed) {
                result = result + "Scope ";
            }
            if (!this.clientIdNotAlreadyAuthorized) {
                result = result + "AlreadyAuthorized ";
            }
            if (!this.maxFailAuthAttemptsOk) {
                result = result + "MaxAuthFails ";
            }
            return result;
        }
    }
}

