/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.naming.NoPermissionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.math.NumberUtils;
import solutions.onesight.ossRestApiServer.AlarmUtils;
import solutions.onesight.ossRestApiServer.ApiRequest;
import solutions.onesight.ossRestApiServer.BOssApiAuthGrant;
import solutions.onesight.ossRestApiServer.BOssApiClientApplication;
import solutions.onesight.ossRestApiServer.BOssRestApiService;
import solutions.onesight.ossRestApiServer.HistoryUtils;
import solutions.onesight.ossRestApiServer.OssRestApiServerLicense;
import solutions.onesight.ossRestApiServer.OssRestApiServerLog;
import solutions.onesight.ossRestApiServer.PointUtils;
import solutions.onesight.ossRestApiServer.auth.BAuthServer;
import solutions.onesight.ossRestApiServer.auth.BAuthToken;

public class QueryServlet
extends UnauthenticatedServlet {
    private final BOssRestApiService svc = (BOssRestApiService)Sys.getService((Type)BOssRestApiService.TYPE);
    private boolean debugEnabled = false;
    public static Logger log = OssRestApiServerLog.getLog();
    public static Logger logData = OssRestApiServerLog.getDataLog();
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int i;
        String[] pointPaths;
        BUser accessUser;
        String pathInfo;
        ApiRequest apiRequest;
        block49: {
            log.finest("GET request received");
            try {
                OssRestApiServerLicense.checkLicense();
                if (!this.svc.isRunning()) {
                    this.failureResponse(resp, "OssRestApiServer not running");
                    return;
                }
                if (this.svc.isDisabled()) {
                    this.failureResponse(resp, "OssRestApiServer disabled");
                    return;
                }
                if (!this.checkSchemeIsAllowed(req)) {
                    this.failureResponse(resp, "HTTP not permitted", "Request has an Invalid Scheme - HTTP requests are not allowed.");
                    return;
                }
                apiRequest = new ApiRequest(req, resp, false);
                if (!this.checkAuth(apiRequest)) {
                    log.severe("GET request - authorisation failed");
                    return;
                }
                this.setResponseParams(resp);
                pathInfo = req.getPathInfo().replaceAll("/+", "/");
                log.finest("GET pathInfo: " + pathInfo);
                accessUser = apiRequest.getAccessUser();
                log.finest("Processing GET request with user " + accessUser);
                if (this.checkPath(pathInfo, "/listPoints")) {
                    log.finest("Listing points ...");
                    if (!OssRestApiServerLicense.isPointsLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access points");
                        return;
                    }
                    PointUtils.pointListRequest(this.svc, apiRequest);
                    logData.finest("listPoints request");
                    return;
                }
                if (this.checkPath(pathInfo, "/listAlarms")) {
                    log.finest("Listing alarms ...");
                    if (!OssRestApiServerLicense.isAlarmsLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access Alarms");
                        return;
                    }
                    String source = req.getParameter("source");
                    if (source != null) {
                        AlarmUtils.alarmSourceRequest(this.svc, apiRequest, source);
                    } else {
                        AlarmUtils.alarmBulkRequest(this.svc, apiRequest);
                    }
                    logData.finest("listAlarms request");
                    return;
                }
                if (this.checkPath(pathInfo, "/listHistories")) {
                    log.finest("Listing histories ...");
                    if (!OssRestApiServerLicense.isHistoryLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access histories");
                        return;
                    }
                    HistoryUtils.listHistories(this.svc.getResources(), apiRequest);
                    logData.finest("listHistories request");
                    return;
                }
                if (this.checkPath(pathInfo, "/readPoint/")) {
                    log.finest("Read point: " + pathInfo);
                    if (!OssRestApiServerLicense.isPointsLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access points");
                        return;
                    }
                    pathInfo = pathInfo.substring(10);
                    if (!this.svc.getResources().checkPoint(pathInfo)) {
                        this.failureResponse(resp, "Point resource not allocated: " + pathInfo);
                        return;
                    }
                    String slotPath = "slot:" + pathInfo;
                    OrdTarget pointOrd = BOrd.make((String)slotPath).resolve((BObject)Sys.getStation(), (Context)accessUser);
                    if (!pointOrd.canRead()) {
                        throw new NoPermissionException();
                    }
                    PointUtils.pointValueRequest(this.svc, apiRequest, slotPath);
                    logData.finest("Point read: " + pathInfo);
                    return;
                }
                if (this.checkPath(pathInfo, "/readTree/")) {
                    log.finest("Read point: " + pathInfo);
                    if (!OssRestApiServerLicense.isPointsLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access points");
                        return;
                    }
                    if (!OssRestApiServerLicense.isPointUnlimited()) {
                        this.failureResponse(resp, "OssRestApiServer readTree endpoint requires an unlimited point license");
                        return;
                    }
                    pathInfo = pathInfo.substring(9);
                    if (!this.svc.getResources().checkTree(pathInfo)) {
                        this.failureResponse(resp, "No point resources allocated: " + pathInfo);
                        return;
                    }
                } else {
                    if (this.checkPath(pathInfo, "/writePoint/")) {
                        log.finest("Write point: " + pathInfo);
                        if (!OssRestApiServerLicense.isWriteLicensed()) {
                            this.failureResponse(resp, "OssRestApiServer write feature not licensed");
                            return;
                        }
                        this.failureResponse(resp, "WritePoint is an illegal GET request, use PUT");
                        return;
                    }
                    if (this.checkPath(pathInfo, "/history/")) {
                        log.finest("Read history: " + pathInfo);
                        if (!OssRestApiServerLicense.isHistoryLicensed()) {
                            this.failureResponse(resp, "OssRestApiServer not licensed to access histories");
                            return;
                        }
                        log.finest("History request processing...");
                        pathInfo = pathInfo.substring(8);
                        log.finest("History path is " + pathInfo);
                        if (!this.svc.getResources().checkHistory(pathInfo)) {
                            this.failureResponse(resp, "History resource not allocated: " + pathInfo);
                            return;
                        }
                        if (!HistoryUtils.checkAccess(pathInfo, apiRequest.getAccessUser())) {
                            this.failureResponse(resp, "No permissions to access history: " + pathInfo);
                            return;
                        }
                        boolean objectFormat = false;
                        String formatParam = req.getParameter("format");
                        if (formatParam != null && formatParam.equals("object")) {
                            objectFormat = true;
                            log.finest("History data in object format");
                        }
                        boolean textTimeFormat = false;
                        String timeParam = req.getParameter("time");
                        if (timeParam != null && timeParam.equals("text")) {
                            textTimeFormat = true;
                            log.finest("History time in text format");
                        }
                        String period = "";
                        String rangeParam = req.getParameter("range");
                        if (rangeParam != null) {
                            String rangeField = HistoryUtils.checkRange(rangeParam);
                            if (rangeField == null) {
                                this.failureResponse(resp, "Invalid history range parameter: '" + rangeParam + "'");
                                return;
                            }
                            period = "?period=" + rangeField;
                            log.finest("History range = " + rangeField);
                        } else {
                            String beginParam = req.getParameter("begin");
                            String endParam = req.getParameter("end");
                            if (beginParam != null || endParam != null) {
                                String startField = "";
                                if (beginParam != null) {
                                    startField = ";start=" + beginParam;
                                    log.finest("History begin = " + beginParam);
                                }
                                String endField = "";
                                if (endParam != null) {
                                    endField = ";end=" + endParam;
                                    log.finest("History end = " + endParam);
                                }
                                period = "?period=timeRange" + startField + endField;
                            }
                        }
                        String bql = "history:" + pathInfo + period + "|bql:select timestamp.millis, value, status";
                        log.finest("Getting history data with query: " + bql);
                        HistoryUtils.historyDataRequest(this.svc, apiRequest, bql, textTimeFormat, objectFormat);
                        logData.finest("History read: " + pathInfo);
                        return;
                    }
                    if (!this.checkPath(pathInfo, "/bql/")) {
                        this.failureResponse(resp, "Invalid GET request received", "GET request received by query servlet is malformed. URL is incorrect");
                        return;
                    }
                    log.finest("BQL query: " + pathInfo);
                    if (!OssRestApiServerLicense.isBqlLicensed()) {
                        this.failureResponse(resp, "OssRestApiServer not licensed to access BQL queries");
                        return;
                    }
                    pathInfo = pathInfo.substring(5);
                    this.bqlQueryRequest(apiRequest, pathInfo);
                    logData.finest("BQL read: " + pathInfo);
                    return;
                }
                pointPaths = this.svc.getResources().getSubtree(pathInfo);
                i = 0;
                break block49;
            }
            catch (NotRunningException notRunningEx) {
                this.failureResponse(resp, "OssRestApiService not running");
                return;
            }
            catch (NoPermissionException permEx) {
                this.failureResponse(resp, "No permissions to access resource");
                return;
            }
            catch (IllegalArgumentException argEx) {
                this.failureResponse(resp, "Invalid query: " + argEx.getMessage());
                return;
            }
            catch (SyntaxException synEx) {
                this.failureResponse(resp, "Invalid query syntax");
                return;
            }
            catch (UnresolvedException resEx) {
                this.failureResponse(resp, "Resource does not exist");
                return;
            }
            catch (FeatureNotLicensedException fnle) {
                this.failureResponse(resp, "OssRestApiServer is not licensed to run on this host");
                return;
            }
            catch (ServiceNotFoundException snfe) {
                this.failureResponse(resp, "OssRestApiServer service must be installed into station services before query requests can be handled");
                return;
            }
            catch (Exception ex) {
                this.failureResponse(resp, "Unexpected error: " + ex.getCause());
                ex.printStackTrace();
            }
            return;
        }
        while (true) {
            if (i >= pointPaths.length) {
                PointUtils.pointTreeRequest(this.svc, apiRequest, pointPaths);
                logData.finest("Point read: " + pathInfo);
                return;
            }
            pointPaths[i] = "slot:" + pointPaths[i];
            OrdTarget pointOrd = BOrd.make((String)pointPaths[i]).resolve((BObject)Sys.getStation(), (Context)accessUser);
            if (!pointOrd.canRead()) {
                throw new NoPermissionException();
            }
            ++i;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block31: {
            log.finest("PUT request received");
            try {
                OssRestApiServerLicense.checkLicense();
                if (this.svc.isDisabled()) {
                    this.failureResponse(resp, "OssRestApiServer disabled");
                    return;
                }
                if (!this.checkSchemeIsAllowed(req)) {
                    this.failureResponse(resp, "HTTP not permitted", "Request has an Invalid Scheme - HTTP requests are not allowed.");
                    return;
                }
                ApiRequest apiRequest = new ApiRequest(req, resp, true);
                if (!this.checkAuth(apiRequest)) {
                    return;
                }
                this.setResponseParams(resp);
                String pathInfo = req.getPathInfo();
                log.finest("PUT pathInfo: " + pathInfo);
                if (!this.checkPath(pathInfo, "/writePoint/")) {
                    this.failureResponse(resp, "Invalid PUT request", "PUT requests should start with a write command");
                }
                if (!OssRestApiServerLicense.isWriteLicensed()) {
                    this.failureResponse(resp, "OssRestApiServer write feature not licensed");
                    return;
                }
                BUser accessUser = apiRequest.getAccessUser();
                log.finest("Processing PUT request with user " + accessUser);
                String slotWritePath = pathInfo.substring(11);
                if (!this.svc.getResources().checkPoint(slotWritePath)) {
                    this.failureResponse(resp, "Point resource not allocated: " + slotWritePath);
                    return;
                }
                String writeValue = req.getParameter("value");
                if (writeValue == null) {
                    this.failureResponse(resp, "Write request must contain a value parameter");
                    return;
                }
                if ((writeValue = writeValue.trim()).isEmpty()) {
                    this.failureResponse(resp, "Point write value is empty");
                    return;
                }
                String priorityParam = req.getParameter("priority");
                int writePriority = 16;
                if (priorityParam != null) {
                    try {
                        writePriority = Integer.parseInt(priorityParam);
                    }
                    catch (Exception convertException) {
                        this.failureResponse(resp, "Invalid point write priority: '" + priorityParam + "'");
                        return;
                    }
                }
                slotWritePath = "slot:" + slotWritePath;
                if (writeValue.equalsIgnoreCase("null")) {
                    this.svc.writeRequest(accessUser, slotWritePath, writePriority, true);
                    break block31;
                }
                switch (this.svc.getPointType(slotWritePath)) {
                    case BOOLEAN: {
                        boolean boolVal = false;
                        try {
                            boolVal = this.checkBoolean(writeValue);
                        }
                        catch (Exception convertEx) {
                            this.failureResponse(resp, "PUT request has invalid value for boolean point type");
                            return;
                        }
                        log.finest("Attempting boolean point write of " + boolVal);
                        this.svc.processWriteRequest(accessUser, slotWritePath, boolVal, writePriority);
                        break;
                    }
                    case NUMERIC: {
                        if (NumberUtils.isCreatable(writeValue)) {
                            log.finest("Attempting numeric point write");
                            double doubleVal = Double.parseDouble(writeValue);
                            this.svc.processWriteRequest(accessUser, slotWritePath, doubleVal, writePriority);
                            break;
                        }
                        this.failureResponse(resp, "PUT request has invalid value for numeric point type");
                        break;
                    }
                    case ENUM: {
                        if (NumberUtils.isCreatable(writeValue)) {
                            log.finest("Attempting enum point write");
                            int valueAsIntVal = Integer.parseInt(writeValue);
                            this.svc.processWriteRequest(accessUser, slotWritePath, valueAsIntVal, writePriority);
                            break;
                        }
                        this.failureResponse(resp, "PUT request has invalid value for Enum point type");
                        break;
                    }
                    case STRING: {
                        String postprocessed = writeValue.replace("%26", "&").replace("%2B", "+").replace("%3D", "=").replace("%3F", "?");
                        log.finest("Attempting string point write");
                        this.svc.processWriteRequest(accessUser, slotWritePath, postprocessed, writePriority);
                        break;
                    }
                    default: {
                        this.failureResponse(resp, "Invalid PUT request", "Received invalid PUT request - Check path is correct");
                    }
                }
            }
            catch (FeatureNotLicensedException fnle) {
                this.failureResponse(resp, "OssRestApiServer is not licensed to run on this host");
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.failureResponse(resp, "Priority level must be between 1 and 16");
            }
            catch (ServiceNotFoundException snfe) {
                this.failureResponse(resp, "OssRestApiServer service must be installed into station services before query requests can be handled");
            }
            catch (NumberFormatException nfe) {
                this.failureResponse(resp, "Invalid write request received. Priority out of bounds", "Number format exception. Priority must be a valid integer between 1 and 16");
            }
            catch (IllegalArgumentException iae) {
                this.failureResponse(resp, "Invalid write request received");
            }
            catch (UnresolvedException ure) {
                this.failureResponse(resp, "The request path could not be resolved");
            }
            catch (NoPermissionException permEx) {
                this.failureResponse(resp, "Invalid write request permissions");
            }
            catch (Exception putException) {
                this.failureResponse(resp, "Unexpected error: " + putException.getMessage());
                putException.printStackTrace();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (OssRestApiServerLicense.isNotLicensed()) {
            this.failureResponse(resp, "OssRestApiServer is not licensed to run on this host");
        } else {
            this.failureResponse(resp, "Processing POST request on Resource Server - POST not allowed", "POST requests are not allowed. Use PUT or GET only");
        }
    }

    private void bqlQueryRequest(ApiRequest apiRequest, String query) throws UnresolvedException, FeatureNotLicensedException, IOException {
        JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
        BITable<BObject> table = this.svc.processBqlQuery(apiRequest.getAccessUser(), query);
        ColumnList columns = table.getColumns();
        TableCursor cursor = table.cursor();
        jsonWriter.beginArray();
        while (cursor.next()) {
            jsonWriter.beginObject();
            for (int i = 0; i < columns.size(); ++i) {
                Column c = columns.get(i);
                String dataValue = cursor.cell(c).toString();
                jsonWriter.name(c.getDisplayName(null)).value(dataValue);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    public boolean checkSchemeIsAllowed(HttpServletRequest request) {
        BAuthServer authServer = this.svc.getAuthServer();
        if (!authServer.getHttpsOnly()) {
            return true;
        }
        String scheme = request.getScheme();
        return scheme.equalsIgnoreCase("https");
    }

    private boolean checkAuth(ApiRequest apiRequest) throws IOException {
        log.finest("Checking authorisation...");
        HttpServletResponse response = apiRequest.getResponse();
        String tokenAttemptingAuth = apiRequest.getRequest().getHeader("authorization");
        if (tokenAttemptingAuth == null) {
            this.failureResponse(response, "Invalid authentication token");
            return false;
        }
        try {
            tokenAttemptingAuth = tokenAttemptingAuth.substring(tokenAttemptingAuth.indexOf("Bearer ") + 7);
        }
        catch (Exception trimException) {
            this.failureResponse(response, "Invalid authorisation text");
            return false;
        }
        BOssApiClientApplication[] allClientApps = (BOssApiClientApplication[])this.svc.getChildren(BOssApiClientApplication.class);
        for (int appIndex = 0; appIndex < allClientApps.length; ++appIndex) {
            try {
                BUser accessUser;
                BOssApiClientApplication currentApp = allClientApps[appIndex];
                final BOssApiAuthGrant currentGrant = currentApp.getAuthGrant();
                BAuthToken currentToken = currentGrant.getAuthToken();
                String currentTokenValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        BPassword authToken = currentGrant.getAuthToken().getValue();
                        return authToken.getValue();
                    }
                });
                if (!currentTokenValue.equalsIgnoreCase(tokenAttemptingAuth)) continue;
                log.finest("Token is a match for client application " + currentApp.getApplicationName());
                this.debugEnabled = currentApp.getDebugEnabled();
                if (!currentApp.getEnabled()) {
                    this.failureResponse(response, "OssRestApiServer client application disabled");
                    return false;
                }
                if (currentToken.tokenHasExpired()) {
                    this.failureResponse(response, 401, "Token was received and matched but has expired");
                    return false;
                }
                String username = currentApp.getReadAccessUser().trim();
                if (apiRequest.isWriteAccessRequested()) {
                    if (!this.appHasWriteAccess(currentApp)) {
                        this.failureResponse(response, "Write access not allowed");
                        return false;
                    }
                    username = currentApp.getWriteAccessUser().trim();
                }
                if ((accessUser = BUserService.getService().getUser(username.trim())) == null) {
                    this.failureResponse(response, "Invalid access user");
                    return false;
                }
                apiRequest.setAccessUser(accessUser);
                log.finest("Request is authorized");
                return true;
            }
            catch (NullPointerException appException) {
                log.warning("One or more client applications do not have an authorisation grant");
                if (!this.debugEnabled) continue;
                log.severe("processRefreshRequest threw an exception - check for client applications without an auth grant");
                appException.printStackTrace();
            }
        }
        this.failureResponse(response, 401, "No matching authorisation token was found");
        return false;
    }

    private boolean appHasWriteAccess(BOssApiClientApplication clientApp) {
        return clientApp.writeIsAllowed();
    }

    private void setResponseParams(HttpServletResponse resp) {
        resp.setContentType("application/json; charset=UTF-8");
        resp.setHeader("Connection", "keep-alive");
        resp.addHeader("Expires", "-1");
        resp.addHeader("Cache-Control", "no-store");
        resp.setHeader("transfer-encoding", "chunked");
    }

    private boolean checkPath(String path, String checkStr) {
        try {
            return path.substring(0, checkStr.length()).equalsIgnoreCase(checkStr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkBoolean(String booleanStr) {
        if (booleanStr.equalsIgnoreCase("true")) {
            return true;
        }
        if (booleanStr.equalsIgnoreCase("false")) {
            return false;
        }
        if (booleanStr.equalsIgnoreCase("yes")) {
            return true;
        }
        if (booleanStr.equalsIgnoreCase("no")) {
            return false;
        }
        if (booleanStr.equalsIgnoreCase("1")) {
            return true;
        }
        if (booleanStr.equalsIgnoreCase("0")) {
            return false;
        }
        return Boolean.parseBoolean(booleanStr);
    }

    private void failureResponse(HttpServletResponse response, String failMessage) throws IOException {
        this.failureResponse(response, failMessage, failMessage);
    }

    private void failureResponse(HttpServletResponse response, int statusCode, String failMessage) throws IOException {
        this.failureResponse(response, statusCode, failMessage, failMessage);
    }

    private void failureResponse(HttpServletResponse response, String logMessage, String debugHtmlMessage) throws IOException {
        this.failureResponse(response, 400, logMessage, debugHtmlMessage);
    }

    private void failureResponse(HttpServletResponse response, int statusCode, String logMessage, String debugHtmlMessage) throws IOException {
        log.severe(logMessage);
        response.setContentType("text/html");
        response.setStatus(statusCode);
        response.getWriter().println("<head><title>Bad Request</title></head>");
        response.getWriter().println("<body>");
        response.getWriter().println("<h1>Bad Request</h1>");
        if (this.debugEnabled) {
            response.getWriter().println("<p>" + debugHtmlMessage + "</p>");
        }
        response.getWriter().println("</body>");
    }
}

