/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.Context;
import solutions.onesight.ossRestApiServer.ApiRequest;
import solutions.onesight.ossRestApiServer.BOssRestApiService;

public class PointUtils {
    public static void pointListRequest(BOssRestApiService svc, ApiRequest apiRequest) throws IOException {
        String bql = "bql:select slotPath as 'slotPath' from control:ControlPoint order by slotPath";
        BITable<BObject> table = svc.processBqlQuery(apiRequest.getAccessUser(), bql);
        ColumnList columns = table.getColumns();
        TableCursor cursor = table.cursor();
        JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
        jsonWriter.beginArray();
        while (cursor.next()) {
            for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
                Column queryColumn = columns.get(colIndex);
                String dataValue = cursor.cell(queryColumn).toString();
                if (!queryColumn.getName().equals("slotPath") || !dataValue.startsWith("slot:")) continue;
                dataValue = dataValue.substring(5);
                if (!svc.getResources().checkPoint(dataValue)) continue;
                jsonWriter.value(dataValue);
            }
        }
        jsonWriter.endArray();
    }

    public static void pointValueRequest(BOssRestApiService svc, ApiRequest apiRequest, String slotPath) throws IOException {
        BObject pointObj;
        BComponent stationRoot = (BComponent)BOrd.make((String)"station:|slot:/").get();
        stationRoot.lease();
        BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
        try {
            pointObj = BOrd.make((String)slotPath).get((BObject)station, (Context)apiRequest.getAccessUser());
        }
        catch (Exception resolveException) {
            throw new UnresolvedException("Resource does not exist");
        }
        if (!(pointObj instanceof BControlPoint)) {
            throw new UnresolvedException("Resource invalid type");
        }
        BControlPoint pointNode = (BControlPoint)pointObj;
        pointNode.lease();
        JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
        jsonWriter.beginObject();
        jsonWriter.name("value").value(pointNode.getStatusValue().valueToString(null));
        jsonWriter.name("status").value(pointNode.getStatus().flagsToString(null));
        jsonWriter.endObject();
    }

    public static void pointTreeRequest(BOssRestApiService svc, ApiRequest apiRequest, String[] pointPaths) throws IOException {
        BComponent stationRoot = (BComponent)BOrd.make((String)"station:|slot:/").get();
        stationRoot.lease();
        BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
        JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
        jsonWriter.beginObject();
        jsonWriter.name("data");
        jsonWriter.beginArray();
        for (String slotPath : pointPaths) {
            BObject pointObj;
            try {
                pointObj = BOrd.make((String)slotPath).get((BObject)station, (Context)apiRequest.getAccessUser());
            }
            catch (Exception resolveException) {
                throw new UnresolvedException("Resource does not exist");
            }
            if (!(pointObj instanceof BControlPoint)) {
                throw new UnresolvedException("Resource invalid type");
            }
            BControlPoint pointNode = (BControlPoint)pointObj;
            pointNode.lease();
            jsonWriter.beginObject();
            jsonWriter.name("name").value(pointNode.getName());
            jsonWriter.name("path").value(pointNode.toPathString());
            jsonWriter.name("value").value(pointNode.getStatusValue().valueToString(null));
            jsonWriter.name("status").value(pointNode.getStatus().flagsToString(null));
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }
}

