/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.status.BStatus;
import javax.baja.sys.Sys;
import solutions.onesight.ossRestApiServer.BOssRestApiService;
import solutions.onesight.ossRestApiServer.OssRestApiServerLog;

public class OssRestApiServerLicense {
    private static int currentHistoryCount = 0;
    private static int currentPointCount = 0;
    private static boolean licensed = false;
    private static boolean licenseBqlEnabled = false;
    private static boolean licenseHistoryEnabled = false;
    private static boolean licenseAlarmsEnabled = false;
    private static boolean licensePointsEnabled = false;
    private static boolean licenseWriteEnabled = false;
    private static int licenseResourceLimit = 0;
    private static boolean licenseHistoryUnlimited = false;
    private static int licenseHistoryLimit = 0;
    private static boolean licensePointUnlimited = false;
    private static int licensePointLimit = 0;
    private static final String LICENSE_BQL_ENABLE = "bqlEnable";
    private static final String LICENSE_HISTORY_ENABLE = "historyEnable";
    private static final String LICENSE_POINTS_ENABLE = "pointsEnable";
    private static final String LICENSE_ALARMS_ENABLE = "alarmEnable";
    private static final String LICENSE_WRITE_ENABLE = "writeEnable";
    private static final String LICENSE_RESOURCE_LIMIT = "resourceLimit";
    private static final String LICENSE_HISTORY_LIMIT = "historyLimit";
    private static final String LICENSE_POINT_LIMIT = "pointLimit";
    private static final String LICENSE_VENDOR = "OneSightSolutions";
    private static final String LICENSE_FEATURE = "ossRestApiServer";

    public static void validateLicense(BOssRestApiService service) {
        licensed = false;
        licenseBqlEnabled = false;
        licenseHistoryEnabled = false;
        licenseAlarmsEnabled = false;
        licensePointsEnabled = false;
        licenseWriteEnabled = false;
        licenseHistoryUnlimited = false;
        licenseHistoryLimit = 0;
        licensePointUnlimited = false;
        licensePointLimit = 0;
        try {
            licensed = true;
            Feature licenseFeature = Sys.getLicenseManager().getFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            licenseBqlEnabled = licenseFeature.getb(LICENSE_BQL_ENABLE, false);
            licenseHistoryEnabled = licenseFeature.getb(LICENSE_HISTORY_ENABLE, false);
            licensePointsEnabled = licenseFeature.getb(LICENSE_POINTS_ENABLE, false);
            licenseAlarmsEnabled = licenseFeature.getb(LICENSE_ALARMS_ENABLE, false);
            licenseWriteEnabled = licenseFeature.getb(LICENSE_WRITE_ENABLE, false);
            String resourceFeature = licenseFeature.get(LICENSE_RESOURCE_LIMIT, "");
            if (resourceFeature != null && !resourceFeature.isEmpty()) {
                if (resourceFeature.equals("none")) {
                    licenseHistoryUnlimited = true;
                    licensePointUnlimited = true;
                    OssRestApiServerLog.getLog().finest("Resource license unlimited");
                } else {
                    licenseResourceLimit = licenseFeature.geti(LICENSE_RESOURCE_LIMIT, 0);
                    OssRestApiServerLog.getLog().finest("Resource license limit: " + licenseResourceLimit);
                }
            } else {
                if (licenseFeature.get(LICENSE_HISTORY_LIMIT, "").equals("none")) {
                    licenseHistoryUnlimited = true;
                    OssRestApiServerLog.getLog().finest("Resource license histories unlimited");
                } else {
                    licenseHistoryLimit = licenseFeature.geti(LICENSE_HISTORY_LIMIT, 0);
                    OssRestApiServerLog.getLog().finest("Resource license history limit: " + licenseHistoryLimit);
                }
                if (licenseFeature.get(LICENSE_POINT_LIMIT, "").equals("none")) {
                    licensePointUnlimited = true;
                    OssRestApiServerLog.getLog().finest("Resource license points unlimited");
                } else {
                    licensePointLimit = licenseFeature.geti(LICENSE_POINT_LIMIT, 0);
                    OssRestApiServerLog.getLog().finest("Resource license point limit: " + licensePointLimit);
                }
            }
            service.setStatus(BStatus.make((int)0));
            service.setFaultCause("");
        }
        catch (LicenseException licEx) {
            licensed = false;
            service.setStatus(BStatus.make((int)2));
            service.setFaultCause("OssRestApiServer is not licensed");
            OssRestApiServerLog.getLog().severe("OssRestApiServer is not licensed");
            throw new FeatureNotLicensedException();
        }
    }

    public static void checkLicense() throws FeatureNotLicensedException {
        if (OssRestApiServerLicense.isNotLicensed()) {
            throw new FeatureNotLicensedException();
        }
    }

    public static boolean isNotLicensed() {
        return !licensed;
    }

    public static boolean isBqlLicensed() {
        return licenseBqlEnabled;
    }

    public static boolean isHistoryLicensed() {
        return licenseHistoryEnabled;
    }

    public static boolean isPointsLicensed() {
        return licensePointsEnabled;
    }

    public static boolean isAlarmsLicensed() {
        return licenseAlarmsEnabled;
    }

    public static boolean isWriteLicensed() {
        return licenseWriteEnabled;
    }

    public static boolean isUnlimited() {
        return licenseHistoryUnlimited && licensePointUnlimited;
    }

    public static int getResourceLimit() {
        return licenseResourceLimit;
    }

    public static boolean isHistoryUnlimited() {
        return licenseHistoryUnlimited;
    }

    public static int getHistoryLimit() {
        return licenseHistoryLimit;
    }

    public static boolean isPointUnlimited() {
        return licensePointUnlimited;
    }

    public static int getPointLimit() {
        return licensePointLimit;
    }

    public static void resetResourceCount() {
        currentHistoryCount = 0;
        currentPointCount = 0;
    }

    public static void incrementHistoryCount() {
        ++currentHistoryCount;
    }

    public static void incrementPointCount() {
        ++currentPointCount;
    }

    public static void decrementHistoryCount() {
        --currentHistoryCount;
    }

    public static void decrementPointCount() {
        --currentPointCount;
    }

    public static boolean checkHistoryLimit() {
        if (!licenseHistoryEnabled) {
            return false;
        }
        if (licenseHistoryUnlimited) {
            return true;
        }
        if (licenseResourceLimit > 0) {
            return currentHistoryCount + currentPointCount <= licenseResourceLimit;
        }
        return currentHistoryCount <= licenseHistoryLimit;
    }

    public static boolean checkPointLimit() {
        if (!licensePointsEnabled) {
            return false;
        }
        if (licensePointUnlimited) {
            return true;
        }
        if (licenseResourceLimit > 0) {
            return currentHistoryCount + currentPointCount <= licenseResourceLimit;
        }
        return currentPointCount <= licensePointLimit;
    }
}

