/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import solutions.onesight.ossRestApiServer.ApiRequest;
import solutions.onesight.ossRestApiServer.BOssRestApiService;
import solutions.onesight.ossRestApiServer.resources.BApiResourceList;

public class HistoryUtils {
    public static void listHistories(BApiResourceList resourceList, ApiRequest apiRequest) {
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase historyDatabase = historyService.getDatabase();
        BIHistory[] histList = historyDatabase.getHistories();
        try {
            JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
            jsonWriter.beginArray();
            for (BIHistory histItem : histList) {
                String historyId = histItem.getId().encodeToString();
                if (!resourceList.checkHistory(historyId) || !histItem.getPermissions((Context)apiRequest.getAccessUser()).hasOperatorRead()) continue;
                jsonWriter.value(historyId);
            }
            jsonWriter.endArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void historyDataRequest(BOssRestApiService svc, ApiRequest apiRequest, String query, boolean textTimeFormat, boolean objectFormat) throws IOException {
        BITable<BObject> table = svc.processBqlQuery(apiRequest.getAccessUser(), query);
        ColumnList columns = table.getColumns();
        TableCursor cursor = table.cursor();
        GregorianCalendar convertTime = new GregorianCalendar();
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setGroupingUsed(false);
        formatter.setMinimumIntegerDigits(2);
        JsonWriter jsonWriter = new JsonWriter(apiRequest.getResponse().getWriter());
        jsonWriter.beginArray();
        while (cursor.next()) {
            String recordTime = null;
            String recordValue = null;
            String recordStatus = null;
            for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
                Column queryColumn = columns.get(colIndex);
                String dataValue = cursor.cell(queryColumn).toString();
                if (queryColumn.getName().equals("timestamp.millis")) {
                    recordTime = dataValue;
                }
                if (queryColumn.getName().equals("value")) {
                    recordValue = dataValue;
                }
                if (!queryColumn.getName().equals("status")) continue;
                recordStatus = ((BStatus)cursor.cell(queryColumn)).flagsToString(null);
            }
            if (textTimeFormat) {
                convertTime.setTimeInMillis(Long.parseLong(recordTime));
                recordTime = formatter.format(convertTime.get(1)) + "-" + formatter.format(convertTime.get(2) + 1) + "-" + formatter.format(convertTime.get(5)) + "T" + formatter.format(convertTime.get(11)) + ":" + formatter.format(convertTime.get(12)) + ":" + formatter.format(convertTime.get(13)) + "." + formatter.format(convertTime.get(14)) + "0Z";
            }
            if (objectFormat) {
                jsonWriter.beginObject();
                jsonWriter.name("time").value(recordTime);
                jsonWriter.name("value").value(recordValue);
                jsonWriter.name("status").value(recordStatus);
                jsonWriter.endObject();
                continue;
            }
            jsonWriter.beginArray();
            jsonWriter.value(recordTime);
            jsonWriter.value(recordValue);
            jsonWriter.value(recordStatus);
            jsonWriter.endArray();
        }
        jsonWriter.endArray();
    }

    public static boolean checkAccess(String historyPath, BUser accessUser) {
        boolean canRead = false;
        BPermissions historyPerm = null;
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase historyDatabase = historyService.getDatabase();
        try (HistoryDatabaseConnection historyConn = historyDatabase.getDbConnection((Context)accessUser);){
            BIHistory histItem = historyConn.getHistory(BHistoryId.make((String)historyPath));
            if (histItem != null) {
                historyPerm = histItem.getPermissions((Context)accessUser);
            }
        }
        catch (Exception ex) {
            throw new UnresolvedException("Invalid history path");
        }
        if (historyPerm != null) {
            if (historyPerm.hasOperatorRead()) {
                canRead = true;
            }
        } else {
            throw new UnresolvedException("History does not exist");
        }
        return canRead;
    }

    public static String checkRange(String rangeParam) {
        if (rangeParam != null && ((rangeParam = rangeParam.toLowerCase()).equalsIgnoreCase("today") || rangeParam.equalsIgnoreCase("last24hours") || rangeParam.equalsIgnoreCase("yesterday") || rangeParam.equalsIgnoreCase("weektodate") || rangeParam.equalsIgnoreCase("lastweek") || rangeParam.equalsIgnoreCase("last7days") || rangeParam.equalsIgnoreCase("monthtodate") || rangeParam.equalsIgnoreCase("lastmonth") || rangeParam.equalsIgnoreCase("yeartodate") || rangeParam.equalsIgnoreCase("lastyear"))) {
            return rangeParam;
        }
        return null;
    }
}

