/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import java.io.IOException;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.naming.NoPermissionException;
import solutions.onesight.ossRestApiServer.BOssApiClientApplication;
import solutions.onesight.ossRestApiServer.OssRestApiServerLicense;
import solutions.onesight.ossRestApiServer.OssRestApiServerLog;
import solutions.onesight.ossRestApiServer.PointType;
import solutions.onesight.ossRestApiServer.auth.BAuthServer;
import solutions.onesight.ossRestApiServer.resources.BApiResourceList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="resources", type="ossRestApiServer:ApiResourceList", defaultValue="new BApiResourceList()", flags=1), @NiagaraProperty(name="authServer", type="ossRestApiServer:AuthServer", defaultValue="new BAuthServer()", flags=1), @NiagaraProperty(name="httpHasBeenEnabled", type="boolean", defaultValue="false", flags=69)})
@NiagaraAction(name="addApplication")
public class BOssRestApiService
extends BAbstractService {
    public static final Property resources = BOssRestApiService.newProperty((int)1, (BValue)new BApiResourceList(), null);
    public static final Property authServer = BOssRestApiService.newProperty((int)1, (BValue)new BAuthServer(), null);
    public static final Property httpHasBeenEnabled = BOssRestApiService.newProperty((int)69, (boolean)false, null);
    public static final Action addApplication = BOssRestApiService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssRestApiService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.make((String)"module://ossRestApiServer/icons/oss-icon-16.png");
    public static Logger log = OssRestApiServerLog.getLog();
    public static Logger logData = OssRestApiServerLog.getDataLog();

    public BApiResourceList getResources() {
        return (BApiResourceList)this.get(resources);
    }

    public void setResources(BApiResourceList v) {
        this.set(resources, (BValue)v, null);
    }

    public BAuthServer getAuthServer() {
        return (BAuthServer)this.get(authServer);
    }

    public void setAuthServer(BAuthServer v) {
        this.set(authServer, (BValue)v, null);
    }

    public boolean getHttpHasBeenEnabled() {
        return this.getBoolean(httpHasBeenEnabled);
    }

    public void setHttpHasBeenEnabled(boolean v) {
        this.setBoolean(httpHasBeenEnabled, v, null);
    }

    public void addApplication() {
        this.invoke(addApplication, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        OssRestApiServerLicense.validateLicense(this);
        log.finest("OssRestApiServer Service Started");
    }

    public void stopped() {
        this.getAuthServer().stop();
    }

    public void doAddApplication() {
        BOssApiClientApplication newApplication = new BOssApiClientApplication();
        this.add("ClientApplication?", (BValue)newApplication);
    }

    public BITable<BObject> processBqlQuery(BUser accessUser, String query) throws UnresolvedException {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        BComponent stationRoot = (BComponent)BOrd.make((String)"station:|slot:/").get();
        stationRoot.lease();
        BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
        BITable table = null;
        try {
            table = (BITable)BOrd.make((String)query).get((BObject)station, (Context)accessUser);
        }
        catch (SyntaxException querySyntaxException) {
            if (querySyntaxException.getCause() instanceof IOException) {
                throw new IllegalArgumentException(querySyntaxException.getCause().getMessage());
            }
            throw querySyntaxException;
        }
        return table;
    }

    public PointType getPointType(String ord) throws Exception {
        BComponent stationRoot = (BComponent)BOrd.make((String)"station:|slot:/").get();
        stationRoot.lease();
        BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
        BControlPoint cp = (BControlPoint)BOrd.make((String)ord).get((BObject)station);
        if (cp instanceof BBooleanWritable) {
            log.finest("The point we checked was a boolean point");
            return PointType.BOOLEAN;
        }
        if (cp instanceof BNumericWritable) {
            log.finest("The point we checked was a numeric point");
            return PointType.NUMERIC;
        }
        if (cp instanceof BStringWritable) {
            log.finest("The point we checked was a string point");
            return PointType.STRING;
        }
        if (cp instanceof BEnumWritable) {
            log.finest("The point we checked was a enum point");
            return PointType.ENUM;
        }
        log.finest("The point we checked was not a valid point");
        return PointType.INVALID;
    }

    public void processWriteRequest(BUser accessUser, String targetPoint, double value, int priority) throws NoPermissionException {
        BStatusNumeric writeSlot = (BStatusNumeric)this.writeRequest(accessUser, targetPoint, priority);
        if (writeSlot != null) {
            writeSlot.setValue(value);
            logData.finest("Numeric write: " + targetPoint + " = " + value + " @" + priority);
        }
    }

    public void processWriteRequest(BUser accessUser, String targetPoint, boolean value, int priority) throws NoPermissionException {
        BStatusBoolean writeSlot = (BStatusBoolean)this.writeRequest(accessUser, targetPoint, priority);
        if (writeSlot != null) {
            writeSlot.setValue(value);
            logData.finest("Boolean write: " + targetPoint + " = " + value + " @" + priority);
        }
    }

    public void processWriteRequest(BUser accessUser, String targetPoint, String value, int priority) throws NoPermissionException {
        BStatusString writeSlot = (BStatusString)this.writeRequest(accessUser, targetPoint, priority);
        if (writeSlot != null) {
            String postprocess1 = value.replaceAll("%3A", ":");
            String postprocess2 = postprocess1.replaceAll("%3B", ";");
            writeSlot.setValue(postprocess2);
            logData.finest("String write: " + targetPoint + " = '" + postprocess2 + "' @" + priority);
        }
    }

    public void processWriteRequest(BUser accessUser, String targetPoint, int value, int priority) throws NoPermissionException {
        BStatusEnum writeSlot = (BStatusEnum)this.writeRequest(accessUser, targetPoint, priority);
        if (writeSlot != null) {
            writeSlot.setValue(BDynamicEnum.make((int)value));
            logData.finest("Enum write: " + targetPoint + " = " + value + " @" + priority);
        }
    }

    public BStatusValue writeRequest(BUser accessUser, String targetPoint, int priority) throws NoPermissionException {
        return this.writeRequest(accessUser, targetPoint, priority, false);
    }

    public BStatusValue writeRequest(BUser accessUser, String targetPoint, int priority, boolean nullStatus) throws NoPermissionException {
        BStatusValue correctSlot = null;
        OssRestApiServerLicense.checkLicense();
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (priority < 1 || priority > 16) {
            throw new IndexOutOfBoundsException();
        }
        BComponent stationRoot = (BComponent)BOrd.make((String)"station:|slot:/").get();
        stationRoot.lease();
        BStation station = (BStation)stationRoot.getComponentSpace().getRootComponent();
        try {
            OrdTarget pointOrd = BOrd.make((String)targetPoint).resolve((BObject)station, (Context)accessUser);
            if (!pointOrd.canWrite()) {
                throw new NoPermissionException();
            }
            BIWritablePoint writablePoint = (BIWritablePoint)pointOrd.get();
            correctSlot = writablePoint.getInStatusValue(BPriorityLevel.make((int)priority));
            correctSlot.setStatusNull(nullStatus);
        }
        catch (NotRunningException notRunningEx) {
            log.severe("OssRestApiService not running when resolving");
            throw new NotRunningException();
        }
        catch (UnresolvedException ure) {
            log.severe("Resolving ORD: " + targetPoint + " failed");
            throw new UnresolvedException();
        }
        catch (NoPermissionException permEx) {
            log.severe("No permission to write to '" + targetPoint + "'");
            throw new NoPermissionException();
        }
        return correctSlot;
    }

    public void setStatus(BStatus v) {
        if (OssRestApiServerLicense.isNotLicensed() || this.getHttpHasBeenEnabled()) {
            v = BStatus.make((int)2);
        }
        super.setStatus(v);
    }

    public void setFaultCause(String faultMessage) {
        if (this.getHttpHasBeenEnabled()) {
            faultMessage = "Allowing HTTP requests has compromised API security";
        }
        this.setString(faultCause, faultMessage, null);
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }
}

