/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.lang3.RandomStringUtils;
import solutions.onesight.ossRestApiServer.BOssApiAuthGrant;
import solutions.onesight.ossRestApiServer.BOssApiClientCredentials;
import solutions.onesight.ossRestApiServer.BOssRestApiService;
import solutions.onesight.ossRestApiServer.auth.OAuthClientApp;

@NiagaraProperties(value={@NiagaraProperty(name="applicationName", type="String", defaultValue=""), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="authorized", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="failedAuthAttempts", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="readAccessUser", type="String", defaultValue="admin"), @NiagaraProperty(name="writeAccessUser", type="String", defaultValue=""), @NiagaraProperty(name="clientCredentials", type="ossRestApiServer:OssApiClientCredentials", defaultValue="new BOssApiClientCredentials()")})
@NiagaraActions(value={@NiagaraAction(name="generateAuthorizationGrant", flags=4), @NiagaraAction(name="deauthorize", flags=4), @NiagaraAction(name="resetFailedAuths")})
public class BOssApiClientApplication
extends BComponent {
    public static final Property applicationName = BOssApiClientApplication.newProperty((int)0, (String)"", null);
    public static final Property enabled = BOssApiClientApplication.newProperty((int)0, (boolean)true, null);
    public static final Property authorized = BOssApiClientApplication.newProperty((int)65, (boolean)false, null);
    public static final Property debugEnabled = BOssApiClientApplication.newProperty((int)0, (boolean)false, null);
    public static final Property failedAuthAttempts = BOssApiClientApplication.newProperty((int)65, (int)0, null);
    public static final Property readAccessUser = BOssApiClientApplication.newProperty((int)0, (String)"admin", null);
    public static final Property writeAccessUser = BOssApiClientApplication.newProperty((int)0, (String)"", null);
    public static final Property clientCredentials = BOssApiClientApplication.newProperty((int)0, (BValue)new BOssApiClientCredentials(), null);
    public static final Action generateAuthorizationGrant = BOssApiClientApplication.newAction((int)4, null);
    public static final Action deauthorize = BOssApiClientApplication.newAction((int)4, null);
    public static final Action resetFailedAuths = BOssApiClientApplication.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssApiClientApplication.class);
    private static final BIcon icon = BIcon.std((String)"securityHigh.png");
    private static final String validSecretChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz$%^&#@~;:.,_+-+";

    public String getApplicationName() {
        return this.getString(applicationName);
    }

    public void setApplicationName(String v) {
        this.setString(applicationName, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public boolean getAuthorized() {
        return this.getBoolean(authorized);
    }

    public void setAuthorized(boolean v) {
        this.setBoolean(authorized, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public int getFailedAuthAttempts() {
        return this.getInt(failedAuthAttempts);
    }

    public void setFailedAuthAttempts(int v) {
        this.setInt(failedAuthAttempts, v, null);
    }

    public String getReadAccessUser() {
        return this.getString(readAccessUser);
    }

    public void setReadAccessUser(String v) {
        this.setString(readAccessUser, v, null);
    }

    public String getWriteAccessUser() {
        return this.getString(writeAccessUser);
    }

    public void setWriteAccessUser(String v) {
        this.setString(writeAccessUser, v, null);
    }

    public BOssApiClientCredentials getClientCredentials() {
        return (BOssApiClientCredentials)this.get(clientCredentials);
    }

    public void setClientCredentials(BOssApiClientCredentials v) {
        this.set(clientCredentials, (BValue)v, null);
    }

    public void generateAuthorizationGrant() {
        this.invoke(generateAuthorizationGrant, null, null);
    }

    public void deauthorize() {
        this.invoke(deauthorize, null, null);
    }

    public void resetFailedAuths() {
        this.invoke(resetFailedAuths, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!(this.getParent() instanceof BOssRestApiService)) {
            BOssRestApiService.log.severe("OssApiClientApplication should be placed in a OssRestApiService");
            throw new BajaRuntimeException("Incorrect parent");
        }
    }

    public OAuthClientApp getOAuthClientApp() {
        String clientSecret = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return BOssApiClientApplication.this.getClientCredentials().getClientSecret().getValue();
            }
        });
        OAuthClientApp thisApp = new OAuthClientApp(this.getApplicationName(), this.getEnabled(), this.writeIsAllowed(), this.grantHasExpired(), this.getClientCredentials().getClientId(), clientSecret, this.getAuthorized(), this.getFailedAuthAttempts());
        return thisApp;
    }

    public boolean writeIsAllowed() {
        BOssApiAuthGrant grant = this.getAuthGrant();
        if (grant == null) {
            return false;
        }
        return grant.getWriteAccess();
    }

    public boolean hasAuthGrant() {
        boolean hasAGrant = ((BOssApiAuthGrant[])this.getChildren(BOssApiAuthGrant.class)).length > 0;
        return hasAGrant;
    }

    public BOssApiAuthGrant getAuthGrant() {
        if (this.hasAuthGrant()) {
            BOssApiAuthGrant[] grantChildren = (BOssApiAuthGrant[])this.getChildren(BOssApiAuthGrant.class);
            BOssApiAuthGrant grant = grantChildren[0];
            return grant;
        }
        return null;
    }

    public boolean grantHasExpired() {
        BOssApiAuthGrant grant = this.getAuthGrant();
        if (grant == null) {
            return true;
        }
        return grant.grantHasExpired();
    }

    public void doGenerateAuthorizationGrant() {
        BOssRestApiService.log.finest("Generating authorisation grant");
        if (this.checkAllInfoIsComplete()) {
            if (((BOssApiAuthGrant[])this.getChildren(BOssApiAuthGrant.class)).length == 0) {
                BOssRestApiService.log.finest("Authorization grant generated");
                this.add("AuthGrant", (BValue)new BOssApiAuthGrant());
                this.getAuthGrant().doRegenerateGrant();
            } else {
                BOssRestApiService.log.finest("Application can only have one authorisation grant");
            }
        } else {
            BOssRestApiService.log.finest("Before an authorisation grant can be generated all application information must be present, and you must have generated a client ID and secret");
        }
    }

    public boolean checkAllInfoIsComplete() {
        return !this.getApplicationName().isEmpty() && !this.getClientCredentials().getClientId().isEmpty();
    }

    public void generateClientCredentials() {
        BOssRestApiService.log.finest("Generating client credentials");
        BOssApiClientCredentials cc = this.getClientCredentials();
        if (cc.getClientId().isEmpty()) {
            cc.setClientId(this.generateClientID());
        }
        this.changeClientSecret();
    }

    public String changeClientSecret() {
        BOssRestApiService.log.finest("Regenerating client secret");
        BOssApiClientCredentials cc = this.getClientCredentials();
        String newPwString = this.generateSecret();
        BPassword newPw = BPassword.make((String)newPwString);
        cc.setClientSecret(newPw);
        return newPwString;
    }

    public void grantUpdate() {
        BOssApiAuthGrant authGrant = this.getAuthGrant();
        if (authGrant != null) {
            authGrant.doRegenerateGrant();
        }
    }

    public void doDeauthorize() {
        this.setAuthorized(false);
        this.getAuthGrant().setAuthorized(false);
        this.getAuthGrant().setAuthorizationTime(BAbsTime.NULL);
    }

    public void doResetFailedAuths() {
        this.setFailedAuthAttempts(0);
    }

    private String generateSecret() {
        String secret = RandomStringUtils.random(256, validSecretChars);
        secret = this.wordWrap(secret, 64);
        return secret;
    }

    private String generateClientID() {
        String id = RandomStringUtils.randomAlphabetic(32);
        BOssRestApiService.log.finest("New client added. Client id is " + id);
        return id;
    }

    private String wordWrap(String toWrap, int length) {
        for (int i = length - 1; i < toWrap.length(); i += length) {
            toWrap = toWrap.substring(0, i) + "\n" + toWrap.substring(i, toWrap.length());
        }
        return toWrap;
    }

    private String unWordWrap(String toUnWrap) {
        return toUnWrap.replace("\n", "");
    }

    public BIcon getIcon() {
        return icon;
    }
}

