/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossRestApiServer;

import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import solutions.onesight.ossRestApiServer.BOssApiClientApplication;
import solutions.onesight.ossRestApiServer.auth.BAuthToken;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authorized", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="authorizationTime", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="timeGenerated", type="baja:AbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="validTime", type="baja:RelTime", defaultValue="BRelTime.makeDays(7)"), @NiagaraProperty(name="writeAccess", type="boolean", defaultValue="false"), @NiagaraProperty(name="faultCause", type="String", defaultValue=" ", flags=65), @NiagaraProperty(name="faultTime", type="baja:AbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="authToken", type="ossRestApiServer:AuthToken", defaultValue="BAuthToken.DEFAULT", flags=69), @NiagaraProperty(name="refreshToken", type="baja:Password", defaultValue="BPassword.DEFAULT", flags=69)})
@NiagaraAction(name="regenerateGrant", flags=4)
public class BOssApiAuthGrant
extends BComponent {
    public static final Property authorized = BOssApiAuthGrant.newProperty((int)65, (boolean)false, null);
    public static final Property authorizationTime = BOssApiAuthGrant.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property timeGenerated = BOssApiAuthGrant.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property validTime = BOssApiAuthGrant.newProperty((int)0, (BValue)BRelTime.makeDays((int)7), null);
    public static final Property writeAccess = BOssApiAuthGrant.newProperty((int)0, (boolean)false, null);
    public static final Property faultCause = BOssApiAuthGrant.newProperty((int)65, (String)" ", null);
    public static final Property faultTime = BOssApiAuthGrant.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property authToken = BOssApiAuthGrant.newProperty((int)69, (BValue)BAuthToken.DEFAULT, null);
    public static final Property refreshToken = BOssApiAuthGrant.newProperty((int)69, (BValue)BPassword.DEFAULT, null);
    public static final Action regenerateGrant = BOssApiAuthGrant.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BOssApiAuthGrant.class);
    private static final BIcon icon = BIcon.std((String)"license.png");

    public boolean getAuthorized() {
        return this.getBoolean(authorized);
    }

    public void setAuthorized(boolean v) {
        this.setBoolean(authorized, v, null);
    }

    public BAbsTime getAuthorizationTime() {
        return (BAbsTime)this.get(authorizationTime);
    }

    public void setAuthorizationTime(BAbsTime v) {
        this.set(authorizationTime, (BValue)v, null);
    }

    public BAbsTime getTimeGenerated() {
        return (BAbsTime)this.get(timeGenerated);
    }

    public void setTimeGenerated(BAbsTime v) {
        this.set(timeGenerated, (BValue)v, null);
    }

    public BRelTime getValidTime() {
        return (BRelTime)this.get(validTime);
    }

    public void setValidTime(BRelTime v) {
        this.set(validTime, (BValue)v, null);
    }

    public boolean getWriteAccess() {
        return this.getBoolean(writeAccess);
    }

    public void setWriteAccess(boolean v) {
        this.setBoolean(writeAccess, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getFaultTime() {
        return (BAbsTime)this.get(faultTime);
    }

    public void setFaultTime(BAbsTime v) {
        this.set(faultTime, (BValue)v, null);
    }

    public BAuthToken getAuthToken() {
        return (BAuthToken)this.get(authToken);
    }

    public void setAuthToken(BAuthToken v) {
        this.set(authToken, (BValue)v, null);
    }

    public BPassword getRefreshToken() {
        return (BPassword)this.get(refreshToken);
    }

    public void setRefreshToken(BPassword v) {
        this.set(refreshToken, (BValue)v, null);
    }

    public void regenerateGrant() {
        this.invoke(regenerateGrant, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean grantHasExpired() {
        BAbsTime timeGenerated = this.getTimeGenerated();
        BRelTime validPeriod = this.getValidTime();
        BAbsTime expiry = timeGenerated.add(validPeriod);
        return BAbsTime.now().isAfter(expiry);
    }

    public void doRegenerateGrant() {
        this.setTimeGenerated(BAbsTime.now());
        this.setAuthToken(new BAuthToken());
        this.setRefreshToken(BPassword.make((String)BAuthToken.makeInvalidPassword()));
    }

    public void authorize() {
        this.setAuthorized(true);
        BOssApiClientApplication parent = (BOssApiClientApplication)this.getParent();
        parent.setAuthorized(true);
        this.setAuthorizationTime(BAbsTime.now());
        this.setFaultCause("");
    }

    public BIcon getIcon() {
        return icon;
    }
}

