/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.onesightsolutions.ossFTP.OssFtpLog;
import com.onesightsolutions.ossFTP.ProtocolClient;
import com.onesightsolutions.ossFTP.StatusUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import javax.baja.sys.BAbsTime;

public class OssSftpClient
extends ProtocolClient {
    private StatusUpdater status;
    private String server;
    private String user;
    private String password;
    private int port;
    private int timeout;
    public static final int DEFAULT_PORT = 22;

    public OssSftpClient(StatusUpdater newStatus, String newServer, String newUser, String newPassword, int newPort, int newTimeout) {
        this.status = newStatus;
        this.server = newServer;
        this.user = newUser;
        this.password = newPassword;
        this.port = newPort;
        this.timeout = newTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileTransfer(String filePath, String remoteFileName, String remotePath) {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = jsch.getSession(this.user, this.server, this.port);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setTimeout(this.timeout);
            session.setPassword(this.password);
            OssFtpLog.debug("Connecting to server '" + this.server + "' on port " + this.port);
            try {
                session.connect();
            }
            catch (JSchException connectException) {
                this.status.setFault("Failed to connect", "Failed to connect to server '" + this.server + "'");
                try {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                    if (session != null) {
                        session.disconnect();
                    }
                }
                catch (Exception ex) {
                    this.status.setFault(ex.getMessage());
                    ex.printStackTrace();
                }
                return;
            }
            OssFtpLog.debug("Connected");
            sftpChannel = (ChannelSftp)session.openChannel("sftp");
            if (sftpChannel == null) {
                this.status.setFault("Failed to open SFTP channel");
                return;
            }
            sftpChannel.connect();
            if (!remotePath.isEmpty()) {
                if (!this.dirCheck(sftpChannel, remotePath)) {
                    this.status.setFault("Bad destination directory", "The destination directory does not exist or is not accessible");
                    return;
                }
                sftpChannel.cd(remotePath);
            }
            OssFtpLog.debug("Uploading file to SFTP server ...");
            if (this.uploadSingleFile(sftpChannel, filePath, remoteFileName)) {
                this.status.setLastSent(BAbsTime.now());
                this.status.clearFault();
            }
        }
        catch (Exception generalException) {
            this.status.setFault("File transfer exception", "File transfer exception: " + generalException.getMessage());
            generalException.printStackTrace();
        }
        finally {
            try {
                if (sftpChannel != null) {
                    sftpChannel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
            }
            catch (Exception ex) {
                this.status.setFault(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directoryTransfer(String localDirectory, String remoteDirectory) {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = jsch.getSession(this.user, this.server, this.port);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setTimeout(this.timeout);
            session.setPassword(this.password);
            OssFtpLog.debug("Connecting to server '" + this.server + "' on port " + this.port);
            try {
                session.connect();
            }
            catch (JSchException connectException) {
                this.status.setFault("Failed to connect", "Failed to connect to server '" + this.server + "'");
                try {
                    if (sftpChannel != null) {
                        sftpChannel.disconnect();
                    }
                    if (session != null) {
                        session.disconnect();
                    }
                }
                catch (Exception ex) {
                    this.status.setFault(ex.getMessage());
                    ex.printStackTrace();
                }
                return;
            }
            OssFtpLog.debug("Connected");
            sftpChannel = (ChannelSftp)session.openChannel("sftp");
            if (sftpChannel == null) {
                this.status.setFault("Failed to open SFTP channel");
                return;
            }
            sftpChannel.connect();
            if (this.uploadDirectory(sftpChannel, remoteDirectory, localDirectory)) {
                OssFtpLog.status("Directory transfer succeeded");
                this.status.clearFault();
                this.status.setLastSent(BAbsTime.now());
            }
        }
        catch (Exception generalException) {
            this.status.setFault("Directory transfer exception", "Directory transfer exception: " + generalException.getMessage());
            generalException.printStackTrace();
        }
        finally {
            try {
                if (sftpChannel != null) {
                    sftpChannel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
            }
            catch (Exception ex) {
                this.status.setFault(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private boolean uploadDirectory(ChannelSftp sftpChannel, String remoteDirectory, String localDirectory) throws IOException {
        File[] subFiles;
        File localDir;
        OssFtpLog.debug("Local directory: " + localDirectory);
        try {
            localDir = new File(localDirectory);
            if (!localDir.exists()) {
                this.status.setFault("Local directory does not exist");
                return false;
            }
            if (!localDir.canRead()) {
                this.status.setFault("Local directory is not accessible");
                return false;
            }
        }
        catch (AccessControlException ex) {
            this.status.setFault("Invalid local directory", "Local directory access exception: " + ex);
            return false;
        }
        try {
            subFiles = localDir.listFiles();
        }
        catch (AccessControlException ex) {
            this.status.setFault("Invalid local directory", "Local directory access exception: " + ex);
            return false;
        }
        if (subFiles == null) {
            this.status.setFault("Invalid local directory", "Invalid local directory (probably a file)");
            return false;
        }
        if (subFiles.length < 1) {
            this.status.setFault("Local directory empty");
            return false;
        }
        try {
            if (!this.dirCheck(sftpChannel, remoteDirectory)) {
                sftpChannel.mkdir(remoteDirectory);
            }
            if (!this.dirCheck(sftpChannel, remoteDirectory)) {
                this.status.setFault("Invalid remote directory", "Could not create remote directory: " + remoteDirectory);
                return false;
            }
            OssFtpLog.debug("Created the directory: " + remoteDirectory);
            sftpChannel.cd(remoteDirectory);
        }
        catch (Exception pathException) {
            this.status.setFault("Failed to change directory", "Failed to change to directory: " + remoteDirectory);
            return false;
        }
        for (File fileEntry : subFiles) {
            String currentEntryName = fileEntry.getName();
            if (!(fileEntry.isFile() ? !this.uploadSingleFile(sftpChannel, fileEntry.getAbsolutePath(), currentEntryName) : fileEntry.isDirectory() && !this.uploadDirectory(sftpChannel, currentEntryName, fileEntry.getAbsolutePath()))) continue;
            return false;
        }
        try {
            sftpChannel.cd("..");
        }
        catch (Exception pathException) {
            this.status.setFault("Directory change failed", "Could not return to parent directory");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadSingleFile(ChannelSftp sftpChannel, String localFilePath, String remoteFilePath) throws IOException {
        FileInputStream inputStream;
        try {
            File localFile = new File(localFilePath);
            inputStream = new FileInputStream(localFile);
        }
        catch (FileNotFoundException fileException) {
            this.status.setFault("Local file not found");
            return false;
        }
        try {
            sftpChannel.put(inputStream, remoteFilePath);
        }
        catch (Exception sftpException) {
            this.status.setFault("Upload failed", "Upload failed: " + sftpException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            ((InputStream)inputStream).close();
        }
        if (!this.fileCheck(sftpChannel, remoteFilePath)) {
            this.status.setFault("File upload failed");
            return false;
        }
        OssFtpLog.status("SFTP file upload successful: " + remoteFilePath);
        return true;
    }

    private boolean fileCheck(ChannelSftp sftpChannel, String filePath) {
        boolean fileValidFlag = false;
        try {
            SftpATTRS fileAttr = sftpChannel.stat(filePath);
            fileValidFlag = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileValidFlag;
    }

    private boolean dirCheck(ChannelSftp sftpChannel, String dirPath) {
        boolean dirValidFlag = false;
        try {
            SftpATTRS dirAttr = sftpChannel.stat(dirPath);
            dirValidFlag = dirAttr.isDir();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dirValidFlag;
    }
}

