/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.sys.Sys;

public class OssFtpLicense {
    private static boolean licensed = false;
    private static boolean licenseTransfersUnlimited = false;
    private static int licenseTransferLimit = 0;
    private static final String LICENSE_VENDOR = "OneSightSolutions";
    private static final String LICENSE_FEATURE = "oneSightFtp";
    private static final String LICENSE_LIMIT_ATTRIBUTE = "transferLimit";
    private static final int LICENSE_LIMIT_DEFAULT = 1;

    public static synchronized boolean checkLicense() {
        licensed = false;
        licenseTransfersUnlimited = false;
        licenseTransferLimit = 0;
        try {
            Feature ftpFeature = Sys.getLicenseManager().checkFeature(LICENSE_VENDOR, LICENSE_FEATURE);
            if (ftpFeature != null && !ftpFeature.isExpired()) {
                String attributeValue = ftpFeature.get(LICENSE_LIMIT_ATTRIBUTE);
                if (attributeValue != null) {
                    if (ftpFeature.get(LICENSE_LIMIT_ATTRIBUTE).equals("none")) {
                        licenseTransfersUnlimited = true;
                    } else {
                        licenseTransferLimit = ftpFeature.geti(LICENSE_LIMIT_ATTRIBUTE, 1);
                    }
                } else {
                    licenseTransfersUnlimited = true;
                }
                licensed = true;
            }
        }
        catch (LicenseException licEx) {
            licensed = false;
        }
        return licensed;
    }

    public static synchronized boolean isLicensed() {
        return licensed;
    }

    public static synchronized boolean isUnlimited() {
        return licenseTransfersUnlimited;
    }

    public static synchronized int getLicenseLimit() {
        return licenseTransferLimit;
    }

    public static synchronized boolean checkLicenseLimit(int transferCount) {
        if (licenseTransfersUnlimited) {
            return false;
        }
        return transferCount > licenseTransferLimit;
    }
}

