/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.OssFtpLog;
import com.onesightsolutions.ossFTP.ProtocolClient;
import com.onesightsolutions.ossFTP.StatusUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.AccessControlException;
import javax.baja.sys.BAbsTime;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.net.ftp.FTPClient;

public class OssFtpClient
extends ProtocolClient {
    private StatusUpdater status;
    private String server;
    private String user;
    private String password;
    private int port;
    private int timeout;
    private boolean usePassiveMode;
    public static final int DEFAULT_PORT = 21;

    public OssFtpClient(StatusUpdater newStatus, String newServer, String newUser, String newPassword, int newPort, int newTimeout, boolean newUsePassiveFlag) {
        this.status = newStatus;
        this.server = newServer;
        this.user = newUser;
        this.password = newPassword;
        this.port = newPort;
        this.timeout = newTimeout;
        this.usePassiveMode = newUsePassiveFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fileTransfer(String filePath, String remoteFileName, String remotePath) {
        FTPClient ftpClient = new FTPClient();
        try {
            OssFtpLog.debug("Connecting to server '" + this.server + "' on port " + this.port);
            try {
                ftpClient.connect(this.server, this.port);
            }
            catch (ConnectException connectException) {
                this.status.setFault("Failed to connect", "Failed to connect to server '" + this.server + "'");
                try {
                    if (!ftpClient.isConnected()) return;
                    ftpClient.logout();
                    ftpClient.disconnect();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            OssFtpLog.debug("Connected");
            ftpClient.login(this.user, this.password);
            int ftpReplyCode = ftpClient.getReplyCode();
            if (ftpReplyCode == 530) {
                this.status.setFault("Login failed", "Login failed for user '" + this.user + "'");
                return;
            }
            if (this.usePassiveMode) {
                ftpClient.enterLocalPassiveMode();
            } else {
                ftpClient.enterLocalActiveMode();
            }
            ftpClient.setConnectTimeout(this.timeout);
            ftpClient.setDataTimeout(this.timeout);
            ftpClient.setSoTimeout(100000);
            ftpClient.setFileType(2);
            if (!remotePath.isEmpty()) {
                ftpClient.changeWorkingDirectory(remotePath);
                ftpReplyCode = ftpClient.getReplyCode();
                if (ftpReplyCode >= 300) {
                    this.status.setFault("Bad destination directory", "The destination directory does not exist or is not accessible");
                    return;
                }
            }
            OssFtpLog.debug("Uploading file to FTP server ...");
            if (!this.uploadSingleFile(ftpClient, filePath, remoteFileName)) return;
            this.status.setLastSent(BAbsTime.now());
            this.status.clearFault();
            return;
        }
        catch (SocketException ex) {
            this.status.setFault("File transfer failed", "File transfer failed: " + ex.getMessage());
            return;
        }
        catch (AccessControlException ex) {
            this.status.setFault("File access denied", "File access exception: " + ex.getMessage());
            return;
        }
        catch (SSLHandshakeException ex) {
            this.status.setFault("Security exception", "Security exception: " + ex.getMessage());
            return;
        }
        catch (Exception ex) {
            this.status.setFault("File transfer exception", "File transfer exception: " + ex.getMessage());
            return;
        }
        finally {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directoryTransfer(String localDirectory, String remoteDirectory) {
        FTPClient ftpClient = new FTPClient();
        try {
            OssFtpLog.debug("Connecting to server '" + this.server + "' on port " + this.port);
            try {
                ftpClient.connect(this.server, this.port);
            }
            catch (ConnectException connectException) {
                this.status.setFault("Failed to connect", "Failed to connect to server '" + this.server + "'");
                try {
                    if (ftpClient.isConnected()) {
                        ftpClient.logout();
                        ftpClient.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            OssFtpLog.debug("Connected");
            ftpClient.login(this.user, this.password);
            int ftpReplyCode = ftpClient.getReplyCode();
            if (ftpReplyCode == 530) {
                this.status.setFault("Login failed", "Login failed for user '" + this.user + "'");
                return;
            }
            if (this.usePassiveMode) {
                ftpClient.enterLocalPassiveMode();
            } else {
                ftpClient.enterLocalActiveMode();
            }
            ftpClient.setDataTimeout(this.timeout);
            ftpClient.setFileType(2);
            if (this.uploadDirectory(ftpClient, remoteDirectory, localDirectory)) {
                OssFtpLog.status("Directory transfer succeeded");
                this.status.clearFault();
                this.status.setLastSent(BAbsTime.now());
            }
        }
        catch (Exception ex) {
            this.status.setFault("File transfer exception", "File transfer exception: " + ex.getMessage());
        }
        finally {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean uploadDirectory(FTPClient ftpClient, String remoteDirectory, String localDirectory) throws IOException {
        File[] subFiles;
        File localDir;
        OssFtpLog.debug("Local directory: " + localDirectory);
        try {
            localDir = new File(localDirectory);
            if (!localDir.exists()) {
                this.status.setFault("Local directory does not exist");
                return false;
            }
            if (!localDir.canRead()) {
                this.status.setFault("Local directory is not accessible");
                return false;
            }
        }
        catch (AccessControlException ex) {
            this.status.setFault("Invalid local directory", "Local directory access exception: " + ex);
            return false;
        }
        try {
            subFiles = localDir.listFiles();
        }
        catch (AccessControlException ex) {
            this.status.setFault("Invalid local directory", "Local directory access exception: " + ex);
            return false;
        }
        if (subFiles == null) {
            this.status.setFault("Invalid local directory", "Invalid local directory (probably a file)");
            return false;
        }
        if (subFiles.length < 1) {
            this.status.setFault("Local directory empty");
            return false;
        }
        ftpClient.changeWorkingDirectory(remoteDirectory);
        int returnCode = ftpClient.getReplyCode();
        if (returnCode >= 300) {
            if (!ftpClient.makeDirectory(remoteDirectory)) {
                this.status.setFault("Invalid remote directory", "Could not create remote directory: " + remoteDirectory);
                return false;
            }
            OssFtpLog.debug("Created the directory: " + remoteDirectory);
            ftpClient.changeWorkingDirectory(remoteDirectory);
            returnCode = ftpClient.getReplyCode();
            if (returnCode >= 300) {
                this.status.setFault("Invalid remote directory", "Invalid remote directory (could not CWD)");
                return false;
            }
        }
        for (File fileEntry : subFiles) {
            String currentEntryName = fileEntry.getName();
            if (!(fileEntry.isFile() ? !this.uploadSingleFile(ftpClient, fileEntry.getAbsolutePath(), currentEntryName) : fileEntry.isDirectory() && !this.uploadDirectory(ftpClient, currentEntryName, fileEntry.getAbsolutePath()))) continue;
            return false;
        }
        ftpClient.changeWorkingDirectory("..");
        returnCode = ftpClient.getReplyCode();
        if (returnCode >= 300) {
            this.status.setFault("Directory change failed", "Could not return to parent directory");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadSingleFile(FTPClient ftpClient, String localFilePath, String remoteFilePath) throws IOException {
        FileInputStream inputStream;
        boolean success = false;
        ftpClient.setFileType(2);
        try {
            File localFile = new File(localFilePath);
            inputStream = new FileInputStream(localFile);
        }
        catch (FileNotFoundException fileException) {
            this.status.setFault("Local file not found");
            return false;
        }
        try {
            success = ftpClient.storeFile(remoteFilePath, inputStream);
        }
        catch (Exception fileException) {
        }
        finally {
            ((InputStream)inputStream).close();
        }
        if (success) {
            OssFtpLog.status("FTP file upload successful: " + remoteFilePath);
        } else {
            String statusText = "Reason unknown";
            try {
                ftpClient.getReply();
                statusText = ftpClient.getReplyString();
                this.status.setFault("File upload failed", "File upload failed: " + statusText);
            }
            catch (Exception statusException) {
                this.status.setFault("File upload fault", "File upload fault: " + statusException.getMessage());
            }
        }
        return success;
    }
}

