/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.OssFtpLog;
import java.io.File;
import java.security.AccessControlException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;

public class FtpUtil {
    public static String prependTimestamp(String fileName) {
        String time = BAbsTime.now().getTime().toString();
        time = time.substring(0, 5);
        time = time.replace(":", "-");
        String date = BAbsTime.now().getDate().toString();
        return date + "_" + time + "_" + fileName;
    }

    public static boolean isValidName(String text) {
        Pattern pattern = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);
        Matcher matcher = pattern.matcher(text);
        boolean isMatch = matcher.matches();
        return isMatch;
    }

    public static String correctSlashes(String path) {
        return path.replace("/", "\\");
    }

    public static void printEnvVars() {
        OssFtpLog.debug("----------");
        OssFtpLog.debug("FTP Service - Listing Niagara Path Environment Variables:");
        File protectedHome = Sys.getProtectedStationHome();
        OssFtpLog.debug("  > Protected Home (^^): " + protectedHome.toPath().toString());
        try {
            OssFtpLog.debug("    - Read Access: " + protectedHome.canRead());
        }
        catch (AccessControlException e) {
            OssFtpLog.debug("    - Read Access: false");
        }
        File stationHome = Sys.getStationHome();
        OssFtpLog.debug("  > Station Home (^)   : " + stationHome.toPath().toString());
        try {
            OssFtpLog.debug("    - Read Access: " + stationHome.canRead());
        }
        catch (AccessControlException e) {
            OssFtpLog.debug("    - Read Access: false");
        }
        File userHome = Sys.getNiagaraUserHome();
        OssFtpLog.debug("  > User Home (~)      : " + userHome.toPath().toString());
        try {
            OssFtpLog.debug("    - Read Access: " + userHome.canRead());
        }
        catch (AccessControlException e) {
            OssFtpLog.debug("    - Read Access: false");
        }
        File sharedUserHome = Sys.getNiagaraSharedUserHome();
        OssFtpLog.debug("  > Shared User Home   : " + sharedUserHome.toPath().toString());
        try {
            OssFtpLog.debug("    - Read Access: " + sharedUserHome.canRead());
        }
        catch (AccessControlException e) {
            OssFtpLog.debug("    - Read Access: false");
        }
        File NiagaraHome = Sys.getNiagaraHome();
        OssFtpLog.debug("  > Niagara Home: (!)  : " + NiagaraHome.toPath().toString());
        try {
            OssFtpLog.debug("    - Read Access: " + NiagaraHome.canRead());
        }
        catch (AccessControlException e) {
            OssFtpLog.debug("    - Read Access: false");
        }
        OssFtpLog.debug("----------");
    }
}

