/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BTransfer
extends BComponent {
    public static final Type TYPE = Sys.loadType(BTransfer.class);
    private static int transferCount = 0;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        ++transferCount;
    }

    public void stopped() throws Exception {
        super.stopped();
        --transferCount;
    }

    protected String formatFilePath(String path) {
        if (path.startsWith("file:")) {
            path = path.substring(5);
        } else if (path.startsWith("local:|file:")) {
            path = path.substring(12);
        }
        if (path.startsWith("^")) {
            String front = Sys.getStationHome().toString();
            path = front + "\\" + path.substring(1);
        } else if (path.startsWith("!")) {
            String front = Sys.getNiagaraHome().toString();
            path = front + "\\" + path.substring(1);
        } else if (path.startsWith("~")) {
            String front = Sys.getNiagaraUserHome().toString();
            path = front + "\\" + path.substring(1);
        } else if (path.startsWith("^^")) {
            String front = Sys.getProtectedStationHome().toString();
            path = front + "\\" + path.substring(2);
        }
        path = path.replace("\\", "/");
        return path;
    }

    protected int getTransferCount() {
        return transferCount;
    }
}

