/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.BDirectoryTransfer;
import com.onesightsolutions.ossFTP.BFileTransfer;
import com.onesightsolutions.ossFTP.BSftpDirectoryTransfer;
import com.onesightsolutions.ossFTP.BSftpFileTransfer;
import com.onesightsolutions.ossFTP.OssFtpLicense;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="newFtpFileTransfer"), @NiagaraAction(name="newFtpDirectoryTransfer"), @NiagaraAction(name="newSftpFileTransfer"), @NiagaraAction(name="newSftpDirectoryTransfer")})
public class BOssFtpService
extends BAbstractService {
    public static final Action newFtpFileTransfer = BOssFtpService.newAction((int)0, null);
    public static final Action newFtpDirectoryTransfer = BOssFtpService.newAction((int)0, null);
    public static final Action newSftpFileTransfer = BOssFtpService.newAction((int)0, null);
    public static final Action newSftpDirectoryTransfer = BOssFtpService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssFtpService.class);
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.make((String)"module://ossFTP/icons/oss-icon-16.png");

    public void newFtpFileTransfer() {
        this.invoke(newFtpFileTransfer, null, null);
    }

    public void newFtpDirectoryTransfer() {
        this.invoke(newFtpDirectoryTransfer, null, null);
    }

    public void newSftpFileTransfer() {
        this.invoke(newSftpFileTransfer, null, null);
    }

    public void newSftpDirectoryTransfer() {
        this.invoke(newSftpDirectoryTransfer, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssFtpLicense.checkLicense()) {
            this.configFatal("ossFtp software is not licensed");
            throw new LicenseException("ossFtp software is not licensed");
        }
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
    }

    public void doNewFtpFileTransfer() {
        BFileTransfer[] kids = (BFileTransfer[])this.getChildren(BFileTransfer.class);
        BFileTransfer newChild = new BFileTransfer();
        newChild.getConnectionOptions().setPort(21);
        this.add("FtpFileTransfer" + (kids.length + 1), (BValue)newChild);
    }

    public void doNewFtpDirectoryTransfer() {
        BDirectoryTransfer[] kids = (BDirectoryTransfer[])this.getChildren(BDirectoryTransfer.class);
        BDirectoryTransfer newChild = new BDirectoryTransfer();
        newChild.getConnectionOptions().setPort(21);
        this.add("ftpDirectoryTransfer" + (kids.length + 1), (BValue)newChild);
    }

    public void doNewSftpFileTransfer() {
        BSftpFileTransfer[] kids = (BSftpFileTransfer[])this.getChildren(BSftpFileTransfer.class);
        BSftpFileTransfer newChild = new BSftpFileTransfer();
        newChild.getConnectionOptions().setPort(22);
        this.add("sftpFileTransfer" + (kids.length + 1), (BValue)newChild);
    }

    public void doNewSftpDirectoryTransfer() {
        BSftpDirectoryTransfer[] kids = (BSftpDirectoryTransfer[])this.getChildren(BSftpDirectoryTransfer.class);
        BSftpDirectoryTransfer newChild = new BSftpDirectoryTransfer();
        newChild.getConnectionOptions().setPort(22);
        this.add("sftpDirectoryTransfer" + (kids.length + 1), (BValue)newChild);
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public BIcon getIcon() {
        return icon;
    }
}

