/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.OssFtpLicense;
import java.io.File;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=73), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="folderPath", type="BOrd", defaultValue="BOrd.make( \"file:^\" )"), @NiagaraProperty(name="fileSuffix", type="String", defaultValue="new String( \"\" )"), @NiagaraProperty(name="retainLimitDays", type="int", defaultValue="28", facets={@Facet(name="BFacets.UNITS", value="BUnit.make( \"days\", BDimension.DEFAULT )")}), @NiagaraProperty(name="clearSubFolders", type="boolean", defaultValue="false"), @NiagaraProperty(name="lastClearTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastClearLimit", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="deletedFileCount", type="long", defaultValue="0", flags=1), @NiagaraProperty(name="deletedFileSize", type="long", defaultValue="0", flags=1, facets={@Facet(name="BFacets.UNITS", value="BUnit.make( \"bytes\", BDimension.DEFAULT )")}), @NiagaraProperty(name="retainedFileCount", type="long", defaultValue="0", flags=1), @NiagaraProperty(name="retainedFileSize", type="long", defaultValue="0", flags=1, facets={@Facet(name="BFacets.UNITS", value="BUnit.make( \"bytes\", BDimension.DEFAULT )")}), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="clearFiles")
public class BOssFileClear
extends BComponent {
    public static final Property enabled = BOssFileClear.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssFileClear.newProperty((int)73, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssFileClear.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property folderPath = BOssFileClear.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    public static final Property fileSuffix = BOssFileClear.newProperty((int)0, (String)new String(""), null);
    public static final Property retainLimitDays = BOssFileClear.newProperty((int)0, (int)28, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"days", (BDimension)BDimension.DEFAULT)));
    public static final Property clearSubFolders = BOssFileClear.newProperty((int)0, (boolean)false, null);
    public static final Property lastClearTime = BOssFileClear.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastClearLimit = BOssFileClear.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property deletedFileCount = BOssFileClear.newProperty((int)1, (int)0, null);
    public static final Property deletedFileSize = BOssFileClear.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (BDimension)BDimension.DEFAULT)));
    public static final Property retainedFileCount = BOssFileClear.newProperty((int)1, (int)0, null);
    public static final Property retainedFileSize = BOssFileClear.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (BDimension)BDimension.DEFAULT)));
    public static final Property debugEnabled = BOssFileClear.newProperty((int)4, (boolean)false, null);
    public static final Action clearFiles = BOssFileClear.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssFileClear.class);
    private FileClearTask clearTask = null;
    private static final Logger log = Logger.getLogger("ossFTP");
    private static final BIcon icon = BIcon.make((String)"module://ossFTP/icons/oss-icon-16.png");

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getFolderPath() {
        return (BOrd)this.get(folderPath);
    }

    public void setFolderPath(BOrd v) {
        this.set(folderPath, (BValue)v, null);
    }

    public String getFileSuffix() {
        return this.getString(fileSuffix);
    }

    public void setFileSuffix(String v) {
        this.setString(fileSuffix, v, null);
    }

    public int getRetainLimitDays() {
        return this.getInt(retainLimitDays);
    }

    public void setRetainLimitDays(int v) {
        this.setInt(retainLimitDays, v, null);
    }

    public boolean getClearSubFolders() {
        return this.getBoolean(clearSubFolders);
    }

    public void setClearSubFolders(boolean v) {
        this.setBoolean(clearSubFolders, v, null);
    }

    public BAbsTime getLastClearTime() {
        return (BAbsTime)this.get(lastClearTime);
    }

    public void setLastClearTime(BAbsTime v) {
        this.set(lastClearTime, (BValue)v, null);
    }

    public BAbsTime getLastClearLimit() {
        return (BAbsTime)this.get(lastClearLimit);
    }

    public void setLastClearLimit(BAbsTime v) {
        this.set(lastClearLimit, (BValue)v, null);
    }

    public long getDeletedFileCount() {
        return this.getLong(deletedFileCount);
    }

    public void setDeletedFileCount(long v) {
        this.setLong(deletedFileCount, v, null);
    }

    public long getDeletedFileSize() {
        return this.getLong(deletedFileSize);
    }

    public void setDeletedFileSize(long v) {
        this.setLong(deletedFileSize, v, null);
    }

    public long getRetainedFileCount() {
        return this.getLong(retainedFileCount);
    }

    public void setRetainedFileCount(long v) {
        this.setLong(retainedFileCount, v, null);
    }

    public long getRetainedFileSize() {
        return this.getLong(retainedFileSize);
    }

    public void setRetainedFileSize(long v) {
        this.setLong(retainedFileSize, v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public void clearFiles() {
        this.invoke(clearFiles, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (!OssFtpLicense.checkLicense()) {
            this.setFault("ossFtp software is not licensed");
            return;
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            }
        }
    }

    public void doClearFiles() {
        if (!OssFtpLicense.isLicensed()) {
            this.setFault("ossFtp software is not licensed");
            return;
        }
        if (!this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.debugMsg("File clear is disabled");
            return;
        }
        if (this.clearTask == null || !this.clearTask.isAlive()) {
            this.clearTask = new FileClearTask();
            this.clearTask.start();
        } else {
            this.debugMsg("File clear task already running");
        }
    }

    public void setFault(String faultMessage) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultMessage);
        this.errorMsg(faultMessage);
    }

    public void errorMsg(String errorMessage) {
        log.severe("[" + this.getName() + "] " + errorMessage);
    }

    public void debugMsg(String debugMessage) {
        if (this.getDebugEnabled()) {
            log.fine("[" + this.getName() + "] " + debugMessage);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    class FileClearTask
    extends Thread {
        private long retainTime = 0L;
        private long deletedfileCount = 0L;
        private long deletedfileSize = 0L;
        private long retainedFileCount = 0L;
        private long retainedFileSize = 0L;

        FileClearTask() {
        }

        @Override
        public void run() {
            BOssFileClear.this.debugMsg("Clearing files");
            if (!OssFtpLicense.isLicensed()) {
                BOssFileClear.this.setFault("ossFtp software is not licensed");
                return;
            }
            if (!BOssFileClear.this.getEnabled()) {
                BOssFileClear.this.setStatus(BStatus.makeDisabled((BStatus)BOssFileClear.this.getStatus(), (boolean)true));
                BOssFileClear.this.debugMsg("Disabled");
                return;
            }
            try {
                File localPath = this.getFile(BOssFileClear.this.getFolderPath());
                if (this.checkSourcePath(localPath)) {
                    return;
                }
                BOssFileClear.this.setStatus(BStatus.ok);
                BOssFileClear.this.setFaultCause("");
                this.deletedfileCount = 0L;
                this.deletedfileSize = 0L;
                this.retainedFileCount = 0L;
                this.retainedFileSize = 0L;
                long startTime = System.currentTimeMillis();
                BOssFileClear.this.setLastClearTime(BAbsTime.make((long)startTime));
                this.retainTime = startTime - (long)BOssFileClear.this.getRetainLimitDays() * 86400000L;
                BAbsTime clearLimit = BAbsTime.make((long)this.retainTime);
                BOssFileClear.this.setLastClearLimit(clearLimit);
                BOssFileClear.this.debugMsg("Clear time limit: " + clearLimit);
                this.processDirectory(localPath);
                long duration = System.currentTimeMillis() - startTime;
                BOssFileClear.this.setDeletedFileCount(this.deletedfileCount);
                BOssFileClear.this.setDeletedFileSize(this.deletedfileSize);
                BOssFileClear.this.setRetainedFileCount(this.retainedFileCount);
                BOssFileClear.this.setRetainedFileSize(this.retainedFileSize);
                BOssFileClear.this.debugMsg("Deleted " + this.deletedfileCount + " files ( in " + duration + " ms )");
            }
            catch (Exception clearException) {
                BOssFileClear.this.errorMsg("File Clear exception: " + clearException.getMessage());
                clearException.printStackTrace();
            }
            BOssFileClear.this.clearTask = null;
        }

        public void processDirectory(File srcDirectory) {
            if (srcDirectory == null) {
                return;
            }
            for (File dirItem : srcDirectory.listFiles()) {
                if (dirItem.isFile()) {
                    long fileSize = dirItem.length();
                    if (dirItem.getName().endsWith(BOssFileClear.this.getFileSuffix()) && dirItem.lastModified() < this.retainTime) {
                        if (dirItem.delete()) {
                            ++this.deletedfileCount;
                            this.deletedfileSize += fileSize;
                            BOssFileClear.this.debugMsg("Deleted file: " + dirItem.getName());
                        } else {
                            BOssFileClear.this.errorMsg("Failed to delete file: '" + dirItem.getName() + "'");
                        }
                    } else {
                        ++this.retainedFileCount;
                        this.retainedFileSize += fileSize;
                    }
                }
                if (!dirItem.isDirectory() || !BOssFileClear.this.getClearSubFolders()) continue;
                this.processDirectory(dirItem);
            }
        }

        private File getFile(BOrd srcOrd) {
            String path = srcOrd.toString();
            if (path.startsWith("file:^")) {
                path = path.substring(6);
            } else if (path.startsWith("local:|file:^")) {
                path = path.substring(13);
            } else {
                return null;
            }
            return new File(Sys.getStationHome().toString() + "/" + path);
        }

        private boolean checkSourcePath(File localPath) {
            if (localPath == null) {
                BOssFileClear.this.setFault("Clear folder path invalid");
                return true;
            }
            if (!localPath.exists()) {
                BOssFileClear.this.setFault("Clear folder path does not exist");
                return true;
            }
            if (!localPath.canRead()) {
                BOssFileClear.this.setFault("Clear folder path not readable");
                return true;
            }
            if (!localPath.isDirectory()) {
                BOssFileClear.this.setFault("Clear folder path not a directory");
                return true;
            }
            return false;
        }
    }
}

