/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.BConnectionOptions;
import com.onesightsolutions.ossFTP.BOssFtpService;
import com.onesightsolutions.ossFTP.BTransfer;
import com.onesightsolutions.ossFTP.FtpUtil;
import com.onesightsolutions.ossFTP.OssFtpClient;
import com.onesightsolutions.ossFTP.OssFtpLicense;
import com.onesightsolutions.ossFTP.OssFtpLog;
import com.onesightsolutions.ossFTP.OssSftpClient;
import com.onesightsolutions.ossFTP.ProtocolClient;
import com.onesightsolutions.ossFTP.StatusUpdater;
import java.security.AccessControlException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="fileToTransfer", type="baja:Ord", defaultValue="BOrd.make(\"local:|file:\")"), @NiagaraProperty(name="nameOnServer", type="String", defaultValue=""), @NiagaraProperty(name="pathOnServer", type="String", defaultValue=""), @NiagaraProperty(name="prependTimestamp", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="fault", type="boolean", defaultValue="true", flags=1, facets={@Facet(name="BFacets.TRUE_TEXT", value="\"Ok\""), @Facet(name="BFacets.FALSE_TEXT", value="\"Fault\"")}), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="lastFault", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastSent", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="useSftp", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="connectionOptions", type="ossFTP:ConnectionOptions", defaultValue="new BConnectionOptions()")})
@NiagaraAction(name="transferFile", flags=16)
public class BFileTransfer
extends BTransfer
implements StatusUpdater {
    public static final Property enabled = BFileTransfer.newProperty((int)0, (boolean)true, null);
    public static final Property fileToTransfer = BFileTransfer.newProperty((int)0, (BValue)BOrd.make((String)"local:|file:"), null);
    public static final Property nameOnServer = BFileTransfer.newProperty((int)0, (String)"", null);
    public static final Property pathOnServer = BFileTransfer.newProperty((int)0, (String)"", null);
    public static final Property prependTimestamp = BFileTransfer.newProperty((int)4, (boolean)false, null);
    public static final Property fault = BFileTransfer.newProperty((int)1, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"Ok"), (BFacets)BFacets.make((String)"falseText", (String)"Fault")));
    public static final Property faultCause = BFileTransfer.newProperty((int)1, (String)"", null);
    public static final Property lastFault = BFileTransfer.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastSent = BFileTransfer.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property useSftp = BFileTransfer.newProperty((int)4, (boolean)false, null);
    public static final Property connectionOptions = BFileTransfer.newProperty((int)0, (BValue)new BConnectionOptions(), null);
    public static final Action transferFile = BFileTransfer.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BFileTransfer.class);
    private Queue actionQueue = null;
    private ThreadPoolWorker worker = null;
    private boolean loaded = false;
    private static final BIcon icon = BIcon.std((String)"files/file.png");
    private static final String THREAD_WORKER_NAME = "FtpFileWorker";

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getFileToTransfer() {
        return (BOrd)this.get(fileToTransfer);
    }

    public void setFileToTransfer(BOrd v) {
        this.set(fileToTransfer, (BValue)v, null);
    }

    public String getNameOnServer() {
        return this.getString(nameOnServer);
    }

    public void setNameOnServer(String v) {
        this.setString(nameOnServer, v, null);
    }

    public String getPathOnServer() {
        return this.getString(pathOnServer);
    }

    public void setPathOnServer(String v) {
        this.setString(pathOnServer, v, null);
    }

    public boolean getPrependTimestamp() {
        return this.getBoolean(prependTimestamp);
    }

    public void setPrependTimestamp(boolean v) {
        this.setBoolean(prependTimestamp, v, null);
    }

    public boolean getFault() {
        return this.getBoolean(fault);
    }

    public void setFault(boolean v) {
        this.setBoolean(fault, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastFault() {
        return (BAbsTime)this.get(lastFault);
    }

    public void setLastFault(BAbsTime v) {
        this.set(lastFault, (BValue)v, null);
    }

    public BAbsTime getLastSent() {
        return (BAbsTime)this.get(lastSent);
    }

    @Override
    public void setLastSent(BAbsTime v) {
        this.set(lastSent, (BValue)v, null);
    }

    public boolean getUseSftp() {
        return this.getBoolean(useSftp);
    }

    public void setUseSftp(boolean v) {
        this.setBoolean(useSftp, v, null);
    }

    public BConnectionOptions getConnectionOptions() {
        return (BConnectionOptions)this.get(connectionOptions);
    }

    public void setConnectionOptions(BConnectionOptions v) {
        this.set(connectionOptions, (BValue)v, null);
    }

    public void transferFile() {
        this.invoke(transferFile, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.loaded = false;
        if (!(this.getParent() instanceof BOssFtpService)) {
            this.setFault("Invalid FileTransfer parent");
            return;
        }
        if (!OssFtpLicense.isLicensed()) {
            this.setFault("ossFtp software not licensed");
        }
        if (OssFtpLicense.checkLicenseLimit(this.getTransferCount())) {
            this.setFault("Transfer license limit exceeded: " + OssFtpLicense.getLicenseLimit());
            throw new LicenseException("ossFTP transfer license limit exceeded");
        }
        this.clearFault();
        this.loaded = true;
        this.actionQueue = new Queue();
        this.worker = new ThreadPoolWorker((Worker.ITodo)this.actionQueue);
        this.worker.start(THREAD_WORKER_NAME);
    }

    @Override
    public void stopped() {
        if (this.worker != null) {
            this.worker.stop();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.loaded) {
            return;
        }
        if (property.getName().equals("nameOnServer")) {
            String newName = this.getNameOnServer();
            if (!FtpUtil.isValidName(newName)) {
                this.setFault("nameOnServer - Invalid file name");
            } else if (this.getFaultCause().equals("nameOnServer - Invalid file name")) {
                this.clearFault();
            }
        } else if (property.getName().equals("fileToTransfer")) {
            String newName = this.getFileToTransfer().toString();
            if ((newName = this.formatFilePath(newName)).contains("/")) {
                newName = newName.substring(newName.lastIndexOf("/") + 1);
            }
            if (!FtpUtil.isValidName(newName)) {
                this.setFault("fileToTransfer - Invalid file name");
            } else {
                if (this.getFaultCause().equals("fileToTransfer - Invalid file name")) {
                    this.clearFault();
                }
                this.setNameOnServer(newName);
            }
        }
    }

    public void doTransferFile() {
        OssFtpLog.debug("Transfer file");
        if (!(this.getParent() instanceof BOssFtpService)) {
            this.setFault("Invalid File Transfer parent", "File Transfer component must be placed in FTP service");
            return;
        }
        if (!((BOssFtpService)this.getParent()).getEnabled()) {
            this.setFault("ossFTP service disabled");
            return;
        }
        if (!OssFtpLicense.isLicensed()) {
            this.setFault("ossFtp software is not licensed");
            return;
        }
        if (!this.loaded) {
            this.setFault("File Transfer failed to load");
            return;
        }
        if (!this.getEnabled()) {
            this.setFault("File Transfer disabled");
            return;
        }
        BConnectionOptions connection = this.getConnectionOptions();
        if (connection.isInvalid()) {
            this.setFault(connection.getFault());
            return;
        }
        BOrd localFileOrd = null;
        try {
            localFileOrd = this.getFileToTransfer().getOrd();
            localFileOrd.get();
        }
        catch (Exception ex) {
            localFileOrd = null;
        }
        if (localFileOrd == null) {
            this.setFault("Invalid local file");
            return;
        }
        String localFilePath = this.formatFilePath(localFileOrd.toString());
        if (localFilePath == null || localFilePath.isEmpty()) {
            this.setFault("Invalid local file path");
            return;
        }
        OssFtpLog.debug("Local file: '" + localFilePath + "'");
        String remoteFileName = this.getNameOnServer();
        if (this.getPrependTimestamp()) {
            remoteFileName = FtpUtil.prependTimestamp(remoteFileName);
        }
        OssFtpLog.debug("Remote filename: '" + remoteFileName + "'");
        OssFtpLog.debug("Remote path: '" + this.getPathOnServer() + "'");
        ProtocolClient transferClient = null;
        if (this.getUseSftp()) {
            transferClient = new OssSftpClient(this, connection.getFtpServer(), connection.getUsername(), connection.getPassword(), connection.getPort(), connection.getTimeoutDelay());
            OssFtpLog.debug("Transferring file via SFTP ...");
        } else {
            transferClient = new OssFtpClient(this, connection.getFtpServer(), connection.getUsername(), connection.getPassword(), connection.getPort(), connection.getTimeoutDelay(), connection.getUsePassiveMode());
            OssFtpLog.debug("Transferring file via FTP ...");
        }
        try {
            transferClient.fileTransfer(localFilePath, remoteFileName, this.getPathOnServer());
        }
        catch (AccessControlException ex) {
            OssFtpLog.error("Access Control Exception for " + localFilePath);
            this.setFault("Invalid file location", "File being transferred must be located in shared user home (" + Sys.getNiagaraSharedUserHome() + ")");
        }
        catch (Exception ex) {
            this.setFault(ex.getMessage());
        }
    }

    public IFuture post(Action ftpAction, BValue value, Context cxt) {
        if (ftpAction == transferFile) {
            if (this.actionQueue == null) {
                this.actionQueue = new Queue();
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.actionQueue);
                this.worker.start(THREAD_WORKER_NAME);
            }
            this.actionQueue.enqueue((Object)new Invocation((BComponent)this, ftpAction, value, cxt));
            return null;
        }
        return super.post(ftpAction, value, cxt);
    }

    @Override
    public void setFault(String faultText) {
        OssFtpLog.error(faultText);
        this.setFaultCause(faultText);
        this.setFault(false);
        this.setLastFault(BAbsTime.now());
    }

    @Override
    public void setFault(String faultText, String errorText) {
        OssFtpLog.error(errorText);
        this.setFaultCause(faultText);
        this.setFault(false);
        this.setLastFault(BAbsTime.now());
    }

    @Override
    public void clearFault() {
        this.setFaultCause("");
        this.setFault(true);
    }

    public BIcon getIcon() {
        return icon;
    }
}

