/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import com.onesightsolutions.ossFTP.BConnectionOptions;
import com.onesightsolutions.ossFTP.BOssFtpService;
import com.onesightsolutions.ossFTP.BTransfer;
import com.onesightsolutions.ossFTP.OssFtpClient;
import com.onesightsolutions.ossFTP.OssFtpLicense;
import com.onesightsolutions.ossFTP.OssFtpLog;
import com.onesightsolutions.ossFTP.OssSftpClient;
import com.onesightsolutions.ossFTP.ProtocolClient;
import com.onesightsolutions.ossFTP.StatusUpdater;
import java.security.AccessControlException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="directoryToTransfer", type="baja:Ord", defaultValue="BOrd.make(\"local:|file:\")"), @NiagaraProperty(name="pathOnServer", type="String", defaultValue=""), @NiagaraProperty(name="prependTimestamp", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="fault", type="boolean", defaultValue="true", flags=1, facets={@Facet(name="BFacets.TRUE_TEXT", value="\"Ok\""), @Facet(name="BFacets.FALSE_TEXT", value="\"Fault\"")}), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=1), @NiagaraProperty(name="lastFault", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="lastSent", type="baja:AbsTime", defaultValue="BAbsTime.DEFAULT", flags=1), @NiagaraProperty(name="useSftp", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="connectionOptions", type="ossFTP:ConnectionOptions", defaultValue="new BConnectionOptions()")})
@NiagaraAction(name="transferFiles", flags=16)
public class BDirectoryTransfer
extends BTransfer
implements StatusUpdater {
    public static final Property enabled = BDirectoryTransfer.newProperty((int)0, (boolean)true, null);
    public static final Property directoryToTransfer = BDirectoryTransfer.newProperty((int)0, (BValue)BOrd.make((String)"local:|file:"), null);
    public static final Property pathOnServer = BDirectoryTransfer.newProperty((int)0, (String)"", null);
    public static final Property prependTimestamp = BDirectoryTransfer.newProperty((int)4, (boolean)false, null);
    public static final Property fault = BDirectoryTransfer.newProperty((int)1, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"Ok"), (BFacets)BFacets.make((String)"falseText", (String)"Fault")));
    public static final Property faultCause = BDirectoryTransfer.newProperty((int)1, (String)"", null);
    public static final Property lastFault = BDirectoryTransfer.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastSent = BDirectoryTransfer.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property useSftp = BDirectoryTransfer.newProperty((int)4, (boolean)false, null);
    public static final Property connectionOptions = BDirectoryTransfer.newProperty((int)0, (BValue)new BConnectionOptions(), null);
    public static final Action transferFiles = BDirectoryTransfer.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BDirectoryTransfer.class);
    private Queue actionQueue = null;
    private ThreadPoolWorker worker = null;
    boolean loaded = false;
    private static final BIcon icon = BIcon.std((String)"unused/complex.png");
    private static final String THREAD_WORKER_NAME = "FtpDirectoryWorker";

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BOrd getDirectoryToTransfer() {
        return (BOrd)this.get(directoryToTransfer);
    }

    public void setDirectoryToTransfer(BOrd v) {
        this.set(directoryToTransfer, (BValue)v, null);
    }

    public String getPathOnServer() {
        return this.getString(pathOnServer);
    }

    public void setPathOnServer(String v) {
        this.setString(pathOnServer, v, null);
    }

    public boolean getPrependTimestamp() {
        return this.getBoolean(prependTimestamp);
    }

    public void setPrependTimestamp(boolean v) {
        this.setBoolean(prependTimestamp, v, null);
    }

    public boolean getFault() {
        return this.getBoolean(fault);
    }

    public void setFault(boolean v) {
        this.setBoolean(fault, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BAbsTime getLastFault() {
        return (BAbsTime)this.get(lastFault);
    }

    public void setLastFault(BAbsTime v) {
        this.set(lastFault, (BValue)v, null);
    }

    public BAbsTime getLastSent() {
        return (BAbsTime)this.get(lastSent);
    }

    @Override
    public void setLastSent(BAbsTime v) {
        this.set(lastSent, (BValue)v, null);
    }

    public boolean getUseSftp() {
        return this.getBoolean(useSftp);
    }

    public void setUseSftp(boolean v) {
        this.setBoolean(useSftp, v, null);
    }

    public BConnectionOptions getConnectionOptions() {
        return (BConnectionOptions)this.get(connectionOptions);
    }

    public void setConnectionOptions(BConnectionOptions v) {
        this.set(connectionOptions, (BValue)v, null);
    }

    public void transferFiles() {
        this.invoke(transferFiles, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.loaded = false;
        if (!(this.getParent() instanceof BOssFtpService)) {
            this.setFault("Invalid DirectoryTransfer parent");
            return;
        }
        if (!OssFtpLicense.isLicensed()) {
            this.setFault("ossFtp software not licensed");
        }
        if (OssFtpLicense.checkLicenseLimit(this.getTransferCount())) {
            this.setFault("Transfer license limit exceeded: " + OssFtpLicense.getLicenseLimit());
            throw new LicenseException("ossFTP transfer license limit exceeded");
        }
        this.clearFault();
        this.loaded = true;
        this.actionQueue = new Queue();
        this.worker = new ThreadPoolWorker((Worker.ITodo)this.actionQueue);
        this.worker.start(THREAD_WORKER_NAME);
    }

    @Override
    public void stopped() {
        if (this.worker != null) {
            this.worker.stop();
        }
    }

    public void doTransferFiles() {
        OssFtpLog.debug("Transfer directory");
        if (!(this.getParent() instanceof BOssFtpService)) {
            this.setFault("Invalid Directory Transfer parent", "File Transfer component must be placed in FTP service");
            return;
        }
        if (!((BOssFtpService)this.getParent()).getEnabled()) {
            this.setFault("ossFTP service disabled");
            return;
        }
        if (!OssFtpLicense.isLicensed()) {
            this.setFault("ossFtp software is not licensed");
            return;
        }
        if (!this.loaded) {
            this.setFault("Directory Transfer failed to load");
            return;
        }
        if (!this.getEnabled()) {
            this.setFault("Directory Transfer disabled");
            return;
        }
        BConnectionOptions connection = this.getConnectionOptions();
        if (connection.isInvalid()) {
            this.setFault(connection.getFault());
            return;
        }
        BOrd localDirectoryOrd = null;
        try {
            localDirectoryOrd = this.getDirectoryToTransfer().getOrd();
            localDirectoryOrd.get();
        }
        catch (Exception ex) {
            localDirectoryOrd = null;
        }
        if (localDirectoryOrd == null) {
            this.setFault("Invalid local directory");
            return;
        }
        String localDirectoryPath = this.formatFilePath(localDirectoryOrd.toString());
        if (localDirectoryPath == null || localDirectoryPath.isEmpty()) {
            this.setFault("Invalid local directory path");
            return;
        }
        OssFtpLog.debug("Local directory: '" + localDirectoryPath + "'");
        OssFtpLog.debug("Remote path: '" + this.getPathOnServer() + "'");
        ProtocolClient transferClient = null;
        if (this.getUseSftp()) {
            transferClient = new OssSftpClient(this, connection.getFtpServer(), connection.getUsername(), connection.getPassword(), connection.getPort(), connection.getTimeoutDelay());
            OssFtpLog.debug("Transferring directory via SFTP ...");
        } else {
            transferClient = new OssFtpClient(this, connection.getFtpServer(), connection.getUsername(), connection.getPassword(), connection.getPort(), connection.getTimeoutDelay(), connection.getUsePassiveMode());
            OssFtpLog.debug("Transferring directory via FTP ...");
        }
        try {
            transferClient.directoryTransfer(localDirectoryPath, this.getPathOnServer());
        }
        catch (AccessControlException ex) {
            OssFtpLog.error("Access Control Exception for " + localDirectoryPath);
            this.setFault("Invalid directory location", "Directory being transferred must be located in shared user home (" + Sys.getNiagaraSharedUserHome() + ")");
        }
        catch (Exception ex) {
            this.setFault(ex.getMessage());
        }
    }

    public IFuture post(Action ftpAction, BValue value, Context cxt) {
        if (ftpAction == transferFiles) {
            if (this.actionQueue == null) {
                this.actionQueue = new Queue();
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.actionQueue);
                this.worker.start(THREAD_WORKER_NAME);
            }
            this.actionQueue.enqueue((Object)new Invocation((BComponent)this, ftpAction, value, cxt));
            return null;
        }
        return super.post(ftpAction, value, cxt);
    }

    @Override
    public void setFault(String faultText) {
        OssFtpLog.error(faultText);
        this.setFaultCause(faultText);
        this.setFault(false);
        this.setLastFault(BAbsTime.now());
    }

    @Override
    public void setFault(String faultText, String errorText) {
        OssFtpLog.error(errorText);
        this.setFaultCause(faultText);
        this.setFault(false);
        this.setLastFault(BAbsTime.now());
    }

    @Override
    public void clearFault() {
        this.setFaultCause("");
        this.setFault(true);
    }

    public BIcon getIcon() {
        return icon;
    }
}

