/*
 * Decompiled with CFR 0.152.
 */
package com.onesightsolutions.ossFTP;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;

@NiagaraProperties(value={@NiagaraProperty(name="ftpServer", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="21", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65536")}), @NiagaraProperty(name="timeoutDelay", type="int", defaultValue="5000", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"millisecond\")")}), @NiagaraProperty(name="usePassiveMode", type="boolean", defaultValue="true"), @NiagaraProperty(name="serverCredentials", type="baja:UsernameAndPassword", defaultValue="new BUsernameAndPassword(\"User\", BPassword.DEFAULT)")})
public class BConnectionOptions
extends BComponent {
    public static final Property ftpServer = BConnectionOptions.newProperty((int)0, (String)"", null);
    public static final Property port = BConnectionOptions.newProperty((int)0, (int)21, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)65536)));
    public static final Property timeoutDelay = BConnectionOptions.newProperty((int)0, (int)5000, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")));
    public static final Property usePassiveMode = BConnectionOptions.newProperty((int)0, (boolean)true, null);
    public static final Property serverCredentials = BConnectionOptions.newProperty((int)0, (BValue)new BUsernameAndPassword("User", BPassword.DEFAULT), null);
    public static final Type TYPE = Sys.loadType(BConnectionOptions.class);

    public String getFtpServer() {
        return this.getString(ftpServer);
    }

    public void setFtpServer(String v) {
        this.setString(ftpServer, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public int getTimeoutDelay() {
        return this.getInt(timeoutDelay);
    }

    public void setTimeoutDelay(int v) {
        this.setInt(timeoutDelay, v, null);
    }

    public boolean getUsePassiveMode() {
        return this.getBoolean(usePassiveMode);
    }

    public void setUsePassiveMode(boolean v) {
        this.setBoolean(usePassiveMode, v, null);
    }

    public BUsernameAndPassword getServerCredentials() {
        return (BUsernameAndPassword)this.get(serverCredentials);
    }

    public void setServerCredentials(BUsernameAndPassword v) {
        this.set(serverCredentials, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BConnectionOptions() {
    }

    public BConnectionOptions(boolean sftpFlag) {
        if (sftpFlag) {
            this.setPort(22);
            this.setUsePassiveMode(false);
            this.setFlags(this.getSlot("usePassiveMode"), 5);
        }
    }

    public String getUsername() {
        return this.getServerCredentials().getUsername();
    }

    public String getPassword() {
        return this.getServerCredentials().getPassword().getValue();
    }

    public boolean isInvalid() {
        return this.getFtpServer().isEmpty() || this.getServerCredentials().getUsername().isEmpty() || this.getServerCredentials().getPassword().getValue().isEmpty() || this.getPort() < 1 || this.getPort() > 65535;
    }

    public String getFault() {
        if (this.getFtpServer().isEmpty()) {
            return "Server not specified";
        }
        if (this.getPort() < 1 || this.getPort() > 65535) {
            return "Invalid port";
        }
        if (this.getServerCredentials().getUsername().isEmpty()) {
            return "User not specified";
        }
        if (this.getServerCredentials().getPassword().getValue().isEmpty()) {
            return "Password is blank";
        }
        return "";
    }
}

