/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.KeyPair;
import java.security.cert.Certificate;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.workbench.view.BWbComponentView;
import solutions.onesight.ossEasyMqtt.file.FileUtils;
import solutions.onesight.ossEasyMqtt.mqtt.BClientCertificate;

@NiagaraType(agent={@AgentOn(types={"ossEasyMqtt:ClientCertificate"})})
public class BCertificateImportView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BCertificateImportView.class);
    private BTextEditorPane caCertificateText;
    private BTextEditorPane clientCertificateText;
    private BTextEditorPane clientPrivateKeyText;
    private BTextEditorPane textStatusReport;
    private BTextField caCertificateFile;
    private BTextField clientCertificateFile;
    private BTextField clientPrivateKeyFile;
    private BTextEditorPane fileStatusReport;
    private BClientCertificate certificateStore;

    public Type getType() {
        return TYPE;
    }

    public BCertificateImportView() {
        BLabel headingLabel = new BLabel("Import Client Certificates");
        headingLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)20.0));
        headingLabel.setPadding(BInsets.make((double)10.0, (double)10.0, (double)3.0, (double)10.0));
        headingLabel.setHalign(BHalign.left);
        BTabbedPane tabbedPane = new BTabbedPane();
        tabbedPane.addPane("Text Import", this.createTextImportWidget());
        tabbedPane.addPane("File Import", this.createFileImportWidget());
        BGridPane rootPane = new BGridPane(1, new BWidget[]{headingLabel, tabbedPane});
        rootPane.setValign(BValign.make((int)0));
        rootPane.setHalign(BHalign.make((int)0));
        rootPane.setRowGap(10.0);
        this.setContent((BWidget)new BScrollPane((BWidget)rootPane));
    }

    private BWidget createTextImportWidget() {
        BLabel headingLabel = new BLabel("Import Client Certificates from text");
        headingLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)20.0));
        headingLabel.setPadding(BInsets.make((double)10.0, (double)10.0, (double)0.0, (double)10.0));
        headingLabel.setHalign(BHalign.left);
        BLabel caCertificateLabel = new BLabel("CA Certificate: ");
        caCertificateLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        caCertificateLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        BLabel clientCertificateLabel = new BLabel("Client Certificate: ");
        clientCertificateLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        clientCertificateLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        BLabel clientPrivateKeyLabel = new BLabel("Client Private Key: ");
        clientPrivateKeyLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        clientPrivateKeyLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        this.caCertificateText = new BTextEditorPane("", 12, 70, true);
        this.clientCertificateText = new BTextEditorPane("", 12, 70, true);
        this.clientPrivateKeyText = new BTextEditorPane("", 12, 70, true);
        BGridPane textFieldGrid = new BGridPane(2, new BWidget[]{caCertificateLabel, this.caCertificateText, clientCertificateLabel, this.clientCertificateText, clientPrivateKeyLabel, this.clientPrivateKeyText});
        textFieldGrid.setValign(BValign.make((int)0));
        textFieldGrid.setHalign(BHalign.make((int)0));
        textFieldGrid.setRowGap(10.0);
        BLabel statusLabel = new BLabel("Certificate Import Status:");
        statusLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)14.0));
        statusLabel.setPadding(BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)20.0));
        this.textStatusReport = new BTextEditorPane("", 5, 60, false);
        BGridPane statusGrid = new BGridPane(2, new BWidget[]{statusLabel, this.textStatusReport});
        BBorderPane statusPane = new BBorderPane((BWidget)statusGrid);
        statusPane.setPadding(BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0));
        ImportCertificateTextButtonCommand importCommand = new ImportCertificateTextButtonCommand((BWidget)this);
        BButton importButton = new BButton((Command)importCommand, true, false);
        importButton.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        importButton.setText("Import Certificates");
        BBorderPane buttonPane = new BBorderPane((BWidget)importButton);
        buttonPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)10.0, (double)330.0));
        BGridPane textImportPane = new BGridPane(1, new BWidget[]{headingLabel, textFieldGrid, statusPane, buttonPane});
        textImportPane.setValign(BValign.make((int)0));
        textImportPane.setHalign(BHalign.make((int)0));
        textImportPane.setRowGap(10.0);
        return textImportPane;
    }

    private BWidget createFileImportWidget() {
        BLabel headingLabel = new BLabel("Import Client Certificates from files");
        headingLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)20.0));
        headingLabel.setPadding(BInsets.make((double)10.0, (double)10.0, (double)0.0, (double)10.0));
        headingLabel.setHalign(BHalign.left);
        BLabel caCertificateLabel = new BLabel("CA Certificate File: ");
        caCertificateLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        caCertificateLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        BLabel clientCertificateLabel = new BLabel("Client Certificate File: ");
        clientCertificateLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        clientCertificateLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        BLabel clientPrivateKeyLabel = new BLabel("Client Private Key File: ");
        clientPrivateKeyLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        clientPrivateKeyLabel.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0));
        this.caCertificateFile = new BTextField("", 80);
        this.clientCertificateFile = new BTextField("", 80);
        this.clientPrivateKeyFile = new BTextField("", 80);
        FileSelectButtonCommand caCertificateCommand = new FileSelectButtonCommand((BWidget)this, this.caCertificateFile);
        BButton caCertificateButton = new BButton((Command)caCertificateCommand, true, false);
        caCertificateButton.setText("Select File");
        FileSelectButtonCommand clientCertificateCommand = new FileSelectButtonCommand((BWidget)this, this.clientCertificateFile);
        BButton clientCertificateButton = new BButton((Command)clientCertificateCommand, true, false);
        clientCertificateButton.setText("Select File");
        FileSelectButtonCommand clientPrivateKeyCommand = new FileSelectButtonCommand((BWidget)this, this.clientPrivateKeyFile);
        BButton clientPrivateKeyButton = new BButton((Command)clientPrivateKeyCommand, true, false);
        clientPrivateKeyButton.setText("Select File");
        BGridPane fileSelectGrid = new BGridPane(3, new BWidget[]{caCertificateLabel, this.caCertificateFile, caCertificateButton, clientCertificateLabel, this.clientCertificateFile, clientCertificateButton, clientPrivateKeyLabel, this.clientPrivateKeyFile, clientPrivateKeyButton});
        fileSelectGrid.setValign(BValign.make((int)0));
        fileSelectGrid.setHalign(BHalign.make((int)0));
        fileSelectGrid.setRowGap(10.0);
        BBorderPane fileSelectPane = new BBorderPane((BWidget)fileSelectGrid);
        fileSelectPane.setPadding(BInsets.make((double)0.0, (double)20.0, (double)0.0, (double)0.0));
        BLabel statusLabel = new BLabel("Certificate Import Status:");
        statusLabel.setFont(BFont.make((BFont)BFont.DEFAULT, (double)14.0));
        statusLabel.setPadding(BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)20.0));
        this.fileStatusReport = new BTextEditorPane("", 5, 79, false);
        BGridPane statusGrid = new BGridPane(2, new BWidget[]{statusLabel, this.fileStatusReport});
        BBorderPane statusPane = new BBorderPane((BWidget)statusGrid);
        statusPane.setPadding(BInsets.make((double)5.0, (double)0.0, (double)5.0, (double)0.0));
        ImportCertificateFilesButtonCommand importCommand = new ImportCertificateFilesButtonCommand((BWidget)this);
        BButton importButton = new BButton((Command)importCommand, true, false);
        importButton.setFont(BFont.make((BFont)BFont.DEFAULT, (double)16.0));
        importButton.setText("Import Certificates");
        BBorderPane buttonPane = new BBorderPane((BWidget)importButton);
        buttonPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)400.0));
        BGridPane fileImportPane = new BGridPane(1, new BWidget[]{headingLabel, fileSelectPane, statusPane, buttonPane});
        fileImportPane.setValign(BValign.make((int)0));
        fileImportPane.setHalign(BHalign.make((int)0));
        fileImportPane.setRowGap(10.0);
        return fileImportPane;
    }

    private BWidget createErrorWidget(String errorText) {
        BFont errorFont = BFont.make((BFont)BFont.DEFAULT, (double)14.0);
        BLabel errorMessage = new BLabel(errorText, errorFont, BHalign.center);
        errorMessage.setPadding(BInsets.make((double)8.0, (double)10.0, (double)8.0, (double)10.0));
        errorMessage.setBackground(BBrush.makeSolid((BColor)BColor.make((int)235, (int)94, (int)84)));
        BBorder paneBorder = BBorder.make((double)3.0, (int)1, (BBrush)BBrush.makeSolid((BColor)BColor.red));
        BBorderPane errorPane = new BBorderPane((BWidget)errorMessage, paneBorder);
        errorPane.setMargin(BInsets.make((double)0.0, (double)10.0, (double)0.0, (double)0.0));
        errorPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        return errorPane;
    }

    protected void doLoadValue(BObject value, Context cxt) {
        try {
            this.certificateStore = (BClientCertificate)value;
        }
        catch (Exception loadException) {
            loadException.printStackTrace();
        }
    }

    public class ImportCertificateFilesButtonCommand
    extends Command {
        private String fileError;

        ImportCertificateFilesButtonCommand(BWidget owner) {
            super(owner, "Import Certificates");
            this.fileError = "";
        }

        public CommandArtifact doInvoke() {
            if (BCertificateImportView.this.certificateStore != null) {
                String fileText;
                Certificate cert;
                int count = 0;
                StringBuilder statusText = new StringBuilder();
                if (!BCertificateImportView.this.caCertificateFile.getText().isEmpty()) {
                    cert = null;
                    fileText = this.readFile(BCertificateImportView.this.caCertificateFile.getText());
                    if (fileText != null) {
                        cert = BClientCertificate.extractCertificate((String)fileText);
                        if (cert != null) {
                            BCertificateImportView.this.certificateStore.setCACertificateStore(BPassword.make((String)fileText));
                            ++count;
                            statusText.append("CA certificate OK");
                            statusText.append("\n");
                        } else {
                            statusText.append("CA certificate data is invalid");
                            statusText.append("\n");
                        }
                    } else {
                        statusText.append("CA certificate file is invalid: ");
                        statusText.append(this.fileError);
                        statusText.append("\n");
                    }
                    BCertificateImportView.this.certificateStore.setCACertificateValid(cert != null);
                } else {
                    statusText.append("CA certificate is blank");
                    statusText.append("\n");
                }
                if (!BCertificateImportView.this.clientCertificateFile.getText().isEmpty()) {
                    cert = null;
                    fileText = this.readFile(BCertificateImportView.this.clientCertificateFile.getText());
                    if (fileText != null) {
                        cert = BClientCertificate.extractCertificate((String)fileText);
                        if (cert != null) {
                            BCertificateImportView.this.certificateStore.setClientCertificateStore(BPassword.make((String)fileText));
                            ++count;
                            statusText.append("Client certificate OK");
                            statusText.append("\n");
                        } else {
                            statusText.append("Client certificate data is invalid");
                            statusText.append("\n");
                        }
                    } else {
                        statusText.append("Client certificate file is invalid: ");
                        statusText.append(this.fileError);
                        statusText.append("\n");
                    }
                    BCertificateImportView.this.certificateStore.setClientCertificateValid(cert != null);
                } else {
                    statusText.append("Client certificate is blank");
                    statusText.append("\n");
                }
                if (!BCertificateImportView.this.clientPrivateKeyFile.getText().isEmpty()) {
                    KeyPair pkey = null;
                    fileText = this.readFile(BCertificateImportView.this.clientPrivateKeyFile.getText());
                    if (fileText != null) {
                        pkey = BClientCertificate.extractKey((String)fileText, (String)"");
                        if (pkey != null) {
                            BCertificateImportView.this.certificateStore.setClientPrivateKeyStore(BPassword.make((String)fileText));
                            ++count;
                            statusText.append("Client private key OK");
                            statusText.append("\n");
                        } else {
                            statusText.append("Client private key data is invalid");
                            statusText.append("\n");
                        }
                    } else {
                        statusText.append("Client private key file is invalid: ");
                        statusText.append(this.fileError);
                        statusText.append("\n");
                    }
                    BCertificateImportView.this.certificateStore.setClientPrivateKeyValid(pkey != null);
                } else {
                    statusText.append("Client private key is blank");
                    statusText.append("\n");
                }
                BCertificateImportView.this.fileStatusReport.setText(statusText.toString());
                if (count < 3) {
                    BCertificateImportView.this.fileStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.red));
                    BDialog.error((BWidget)this.getOwner(), (String)"Import File Fault", (Object)BCertificateImportView.this.createErrorWidget(statusText.toString()));
                } else {
                    BCertificateImportView.this.fileStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.green));
                }
            }
            return null;
        }

        public String readFile(String filePath) {
            StringBuilder fileText = new StringBuilder();
            try {
                String fileLine;
                File sourceFile = FileUtils.getFile((String)filePath);
                if (sourceFile == null) {
                    this.fileError = "invalid file name";
                    return null;
                }
                if (!sourceFile.exists()) {
                    this.fileError = "file does not exist";
                    return null;
                }
                if (sourceFile.isDirectory()) {
                    this.fileError = "directory specified instead of file";
                    return null;
                }
                if (!sourceFile.canExecute()) {
                    this.fileError = "file is not readable";
                    return null;
                }
                BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
                while ((fileLine = reader.readLine()) != null) {
                    fileText.append(fileLine);
                    fileText.append("\n");
                }
                reader.close();
            }
            catch (FileNotFoundException fileException) {
                this.fileError = "file not found";
                return null;
            }
            catch (Exception readException) {
                this.fileError = "exception: " + readException;
                return null;
            }
            if (fileText == null || fileText.toString() == null || fileText.toString().isEmpty()) {
                this.fileError = "Failed to import file: " + filePath + "\n";
                return null;
            }
            return fileText.toString();
        }
    }

    public static class FileSelectButtonCommand
    extends Command {
        private final BTextField filePathField;

        FileSelectButtonCommand(BWidget newOwner, BTextField newFilePathField) {
            super(newOwner, "Select File");
            this.filePathField = newFilePathField;
        }

        public CommandArtifact doInvoke() {
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setCreateFileOnSave(false);
            chooser.setConfirmOverwrite(false);
            BOrd ord = chooser.show();
            if (ord != null && this.filePathField != null) {
                ord = ord.relativizeToSession();
                this.filePathField.setText(ord.toString());
            }
            return null;
        }
    }

    public class ImportCertificateTextButtonCommand
    extends Command {
        ImportCertificateTextButtonCommand(BWidget owner) {
            super(owner, "Import Certificates");
        }

        public CommandArtifact doInvoke() {
            if (BCertificateImportView.this.certificateStore != null) {
                Certificate cert;
                int count = 0;
                StringBuilder statusText = new StringBuilder();
                String textFieldValue = BCertificateImportView.this.caCertificateText.getText();
                if (!textFieldValue.isEmpty()) {
                    cert = BClientCertificate.extractCertificate((String)textFieldValue);
                    if (cert != null) {
                        BCertificateImportView.this.certificateStore.setCACertificateStore(BPassword.make((String)textFieldValue));
                        BCertificateImportView.this.certificateStore.setCACertificateValid(true);
                        ++count;
                        statusText.append("CA certificate OK");
                        statusText.append("\n");
                    } else {
                        BCertificateImportView.this.certificateStore.setCACertificateValid(false);
                        statusText.append("CA certificate data is invalid");
                        statusText.append("\n");
                    }
                } else {
                    statusText.append("CA certificate is blank");
                    statusText.append("\n");
                }
                textFieldValue = BCertificateImportView.this.clientCertificateText.getText();
                if (!textFieldValue.isEmpty()) {
                    cert = BClientCertificate.extractCertificate((String)textFieldValue);
                    if (cert != null) {
                        BCertificateImportView.this.certificateStore.setClientCertificateStore(BPassword.make((String)textFieldValue));
                        BCertificateImportView.this.certificateStore.setClientCertificateValid(true);
                        ++count;
                        statusText.append("Client certificate OK");
                        statusText.append("\n");
                    } else {
                        BCertificateImportView.this.certificateStore.setClientCertificateValid(false);
                        statusText.append("Client certificate data is invalid");
                        statusText.append("\n");
                    }
                } else {
                    statusText.append("Client certificate is blank");
                    statusText.append("\n");
                }
                textFieldValue = BCertificateImportView.this.clientPrivateKeyText.getText();
                if (!textFieldValue.isEmpty()) {
                    KeyPair pkey = BClientCertificate.extractKey((String)textFieldValue, (String)"");
                    if (pkey != null) {
                        BCertificateImportView.this.certificateStore.setClientPrivateKeyStore(BPassword.make((String)textFieldValue));
                        BCertificateImportView.this.certificateStore.setClientPrivateKeyValid(true);
                        ++count;
                        statusText.append("Client private key OK");
                        statusText.append("\n");
                    } else {
                        BCertificateImportView.this.certificateStore.setClientPrivateKeyValid(false);
                        statusText.append("Client private key data is invalid");
                        statusText.append("\n");
                    }
                } else {
                    statusText.append("Client private key is blank");
                    statusText.append("\n");
                }
                BCertificateImportView.this.textStatusReport.setText(statusText.toString());
                if (count < 3) {
                    BCertificateImportView.this.textStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.red));
                    BDialog.error((BWidget)this.getOwner(), (String)"Import Text Fault", (Object)BCertificateImportView.this.createErrorWidget(statusText.toString()));
                } else {
                    BCertificateImportView.this.textStatusReport.setViewportBackground(BBrush.makeSolid((BColor)BColor.green));
                }
            }
            return null;
        }
    }
}

