/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.folder;

import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import solutions.onesight.ossEasyMqtt.mqtt.BMqttQos;

@NiagaraType
public final class BNewSubscriberDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BNewSubscriberDialog.class);
    private final BTextField subscriberNameValue;
    private final BListDropDown subscriberEnabledValue;
    private final BTextField subscriberDescriptionValue;
    private final BTextField subscriberTopicValue;
    private final BListDropDown subscriberQosValue;
    static final BImage trueIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static final BImage falseIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    private static final int TEXT_FIELD_SIZE = 100;

    public Type getType() {
        return TYPE;
    }

    public BNewSubscriberDialog() {
        BGridPane containerPane = new BGridPane(2);
        BLabel subscriberNameLabel = new BLabel("Name: ");
        this.subscriberNameValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)subscriberNameLabel);
        containerPane.add(null, (BValue)this.subscriberNameValue);
        BLabel subscriberEnabledLabel = new BLabel("Enabled: ");
        this.subscriberEnabledValue = new BListDropDown();
        BList dropDownList = this.subscriberEnabledValue.getList();
        dropDownList.removeAllItems();
        dropDownList.addItem(falseIcon, (Object)"false");
        dropDownList.addItem(trueIcon, (Object)"true");
        this.subscriberEnabledValue.setSelectedIndex(1);
        containerPane.add(null, (BValue)subscriberEnabledLabel);
        containerPane.add(null, (BValue)this.subscriberEnabledValue);
        BLabel subscriberDescriptionLabel = new BLabel("Description: ");
        this.subscriberDescriptionValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)subscriberDescriptionLabel);
        containerPane.add(null, (BValue)this.subscriberDescriptionValue);
        BLabel subscriberTopicLabel = new BLabel("Topic: ");
        this.subscriberTopicValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)subscriberTopicLabel);
        containerPane.add(null, (BValue)this.subscriberTopicValue);
        BLabel subscriberQosLabel = new BLabel("QOS: ");
        this.subscriberQosValue = new BListDropDown();
        dropDownList = this.subscriberQosValue.getList();
        dropDownList.removeAllItems();
        dropDownList.addItem((Object)"At Most Once [0]");
        dropDownList.addItem((Object)"At Least Once [1]");
        dropDownList.addItem((Object)"Exactly Once [2]");
        this.subscriberQosValue.setSelectedIndex(0);
        containerPane.add(null, (BValue)subscriberQosLabel);
        containerPane.add(null, (BValue)this.subscriberQosValue);
        containerPane.setValign(BValign.center);
        containerPane.setHalign(BHalign.center);
        this.setContent((BWidget)containerPane);
    }

    public String getSubscriberName() {
        return this.subscriberNameValue.getText();
    }

    public boolean getSubscriberEnabled() {
        return this.subscriberEnabledValue.getSelectedIndex() == 1;
    }

    public String getSubscriberDescription() {
        return this.subscriberDescriptionValue.getText();
    }

    public String getSubscriberTopic() {
        return this.subscriberTopicValue.getText();
    }

    public BMqttQos getSubscriberQos() {
        BMqttQos selectedQos = BMqttQos.DEFAULT;
        switch (this.subscriberQosValue.getSelectedIndex()) {
            case 0: {
                selectedQos = BMqttQos.AtMostOnce;
                break;
            }
            case 1: {
                selectedQos = BMqttQos.AtLeastOnce;
                break;
            }
            case 2: {
                selectedQos = BMqttQos.ExactlyOnce;
            }
        }
        return selectedQos;
    }
}

