/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.folder;

import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import solutions.onesight.ossEasyMqtt.mqtt.BMqttQos;

@NiagaraType
public final class BNewPublisherDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType(BNewPublisherDialog.class);
    private final BTextField publisherNameValue;
    private final BListDropDown publisherEnabledValue;
    private final BTextField publisherDescriptionValue;
    private final BTextField publisherTopicValue;
    private final BListDropDown publisherQosValue;
    static final BImage trueIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    static final BImage falseIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
    private static final int TEXT_FIELD_SIZE = 100;

    public Type getType() {
        return TYPE;
    }

    public BNewPublisherDialog() {
        BGridPane containerPane = new BGridPane(2);
        BLabel publisherNameLabel = new BLabel("Name: ");
        this.publisherNameValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)publisherNameLabel);
        containerPane.add(null, (BValue)this.publisherNameValue);
        BLabel publisherEnabledLabel = new BLabel("Enabled: ");
        this.publisherEnabledValue = new BListDropDown();
        BList dropDownList = this.publisherEnabledValue.getList();
        dropDownList.removeAllItems();
        dropDownList.addItem(falseIcon, (Object)"false");
        dropDownList.addItem(trueIcon, (Object)"true");
        this.publisherEnabledValue.setSelectedIndex(1);
        containerPane.add(null, (BValue)publisherEnabledLabel);
        containerPane.add(null, (BValue)this.publisherEnabledValue);
        BLabel publisherDescriptionLabel = new BLabel("Description: ");
        this.publisherDescriptionValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)publisherDescriptionLabel);
        containerPane.add(null, (BValue)this.publisherDescriptionValue);
        BLabel publisherTopicLabel = new BLabel("Topic: ");
        this.publisherTopicValue = new BTextField("", 100, true);
        containerPane.add(null, (BValue)publisherTopicLabel);
        containerPane.add(null, (BValue)this.publisherTopicValue);
        BLabel publisherQosLabel = new BLabel("QOS: ");
        this.publisherQosValue = new BListDropDown();
        dropDownList = this.publisherQosValue.getList();
        dropDownList.removeAllItems();
        dropDownList.addItem((Object)"At Most Once [0]");
        dropDownList.addItem((Object)"At Least Once [1]");
        dropDownList.addItem((Object)"Exactly Once [2]");
        this.publisherQosValue.setSelectedIndex(0);
        containerPane.add(null, (BValue)publisherQosLabel);
        containerPane.add(null, (BValue)this.publisherQosValue);
        containerPane.setValign(BValign.center);
        containerPane.setHalign(BHalign.center);
        this.setContent((BWidget)containerPane);
    }

    public String getPublisherName() {
        return this.publisherNameValue.getText();
    }

    public boolean getPublisherEnabled() {
        return this.publisherEnabledValue.getSelectedIndex() == 1;
    }

    public String getPublisherDescription() {
        return this.publisherDescriptionValue.getText();
    }

    public String getPublisherTopic() {
        return this.publisherTopicValue.getText();
    }

    public BMqttQos getPublisherQos() {
        BMqttQos selectedQos = BMqttQos.DEFAULT;
        switch (this.publisherQosValue.getSelectedIndex()) {
            case 0: {
                selectedQos = BMqttQos.AtMostOnce;
                break;
            }
            case 1: {
                selectedQos = BMqttQos.AtLeastOnce;
                break;
            }
            case 2: {
                selectedQos = BMqttQos.ExactlyOnce;
            }
        }
        return selectedQos;
    }
}

