/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.folder;

import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;
import solutions.onesight.ossEasyMqtt.folder.BNewPublisherDialog;
import solutions.onesight.ossEasyMqtt.folder.BNewSubscriberDialog;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttFolder;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttPublisher;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttSubscriber;

@NiagaraType(agent={@AgentOn(types={"ossEasyMqtt:OssMqttFolder"})})
public class BMqttEndpointManager
extends BFolderManager {
    public static final Type TYPE = Sys.loadType(BMqttEndpointManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colStatus = new CustomColumn(BOssMqttSubscriber.status);
    MgrColumn colEnabled = new CustomColumn(BOssMqttSubscriber.enabled, 3);
    MgrColumn colSubscribed = new CustomColumn(BOssMqttSubscriber.subscribed);
    MgrColumn colTopic = new CustomColumn(BOssMqttSubscriber.topic, 1);
    MgrColumn colTime = new CustomColumn(BOssMqttSubscriber.lastUpdate);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colStatus, this.colEnabled, this.colSubscribed, this.colTopic, this.colTime};

    public Type getType() {
        return TYPE;
    }

    public BOssMqttFolder getFolderNode() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BOssMqttFolder) {
            return (BOssMqttFolder)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cxt) {
        super.doLoadValue(obj, cxt);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    static class CustomColumn
    extends MgrColumn.Prop {
        CustomColumn(Property prop) {
            super(prop, 0);
        }

        CustomColumn(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cxt) {
            String cellContents = "";
            if (row instanceof BOssMqttSubscriber) {
                BAbsTime updateTime;
                cellContents = this.getDisplayName().equals("Last Update") ? ((updateTime = ((BOssMqttSubscriber)row).getLastUpdate()) == null || updateTime.isNull() ? "never" : updateTime.toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)))) : super.toDisplayString(row, value, cxt);
            } else if (row instanceof BOssMqttPublisher) {
                BAbsTime updateTime;
                cellContents = this.getDisplayName().equals("Last Update") ? ((updateTime = ((BOssMqttPublisher)row).getLastPublished()) == null || updateTime.isNull() ? "never" : updateTime.toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)))) : (this.getDisplayName().equals("Subscribed") ? "" : super.toDisplayString(row, value, cxt));
            }
            return cellContents;
        }
    }

    class Controller
    extends FolderController {
        private final MgrController.MgrCommand newSubscriber;
        private final MgrController.MgrCommand newPublisher;
        private final BMqttEndpointManager manager;

        Controller(BFolderManager localManager) {
            super(localManager);
            this.manager = (BMqttEndpointManager)localManager;
            this.newFolder.setFlags(7);
            this.newFolder.setEnabled(true);
            this.newSubscriber = new NewSubscriberCommand((BWidget)this.manager);
            this.newSubscriber.setFlags(7);
            this.newSubscriber.setEnabled(true);
            this.newPublisher = new NewPublisherCommand((BWidget)this.manager);
            this.newPublisher.setFlags(7);
            this.newPublisher.setEnabled(true);
            this.edit.setFlags(7);
            this.edit.setEnabled(true);
            this.newCommand.setFlags(0);
            this.newCommand.setEnabled(false);
            this.match.setFlags(0);
            this.match.setEnabled(false);
            this.tagIt.setFlags(0);
            this.tagIt.setEnabled(false);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newFolder, this.newSubscriber, this.newPublisher, this.edit};
        }

        public CommandArtifact doNew(Context cxt) {
            return null;
        }

        class NewPublisherCommand
        extends MgrController.MgrCommand {
            public NewPublisherCommand(BWidget mgr) {
                super(mgr, "New Publisher");
            }

            public CommandArtifact doInvoke() {
                BNewPublisherDialog publisherDialog = new BNewPublisherDialog();
                boolean dialogComplete = false;
                while (!dialogComplete) {
                    int dialogResult = BDialog.open((BWidget)Controller.this.manager, (String)"New Publisher", (Object)((Object)publisherDialog), (int)3);
                    if (dialogResult == 1) {
                        String publisherName = publisherDialog.getPublisherName().trim();
                        String publisherTopic = publisherDialog.getPublisherTopic().trim();
                        if (publisherName.isEmpty()) {
                            BDialog.error((BWidget)Controller.this.manager, (Object)"Publisher name is blank");
                            continue;
                        }
                        if (publisherTopic.isEmpty()) {
                            BDialog.error((BWidget)Controller.this.manager, (Object)"Topic is blank");
                            continue;
                        }
                        BOssMqttPublisher newPublisherNode = new BOssMqttPublisher();
                        newPublisherNode.setEnabled(publisherDialog.getPublisherEnabled());
                        newPublisherNode.setDescription(publisherDialog.getPublisherDescription());
                        newPublisherNode.setTopic(publisherTopic);
                        newPublisherNode.setQos(publisherDialog.getPublisherQos());
                        BMqttEndpointManager.this.getFolderNode().add(SlotPath.escape((String)publisherName), (BValue)newPublisherNode);
                        dialogComplete = true;
                        continue;
                    }
                    dialogComplete = true;
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://ossEasyMqtt/icons/publisher.png")));
            }
        }

        class NewSubscriberCommand
        extends MgrController.MgrCommand {
            public NewSubscriberCommand(BWidget mgr) {
                super(mgr, "New Subscriber");
            }

            public CommandArtifact doInvoke() {
                BNewSubscriberDialog subscriberDialog = new BNewSubscriberDialog();
                boolean dialogComplete = false;
                while (!dialogComplete) {
                    int dialogResult = BDialog.open((BWidget)Controller.this.manager, (String)"New Subscriber", (Object)((Object)subscriberDialog), (int)3);
                    if (dialogResult == 1) {
                        String subscriberName = subscriberDialog.getSubscriberName().trim();
                        String subscriberTopic = subscriberDialog.getSubscriberTopic().trim();
                        if (subscriberName.isEmpty()) {
                            BDialog.error((BWidget)Controller.this.manager, (Object)"Subscriber name is blank");
                            continue;
                        }
                        if (subscriberTopic.isEmpty()) {
                            BDialog.error((BWidget)Controller.this.manager, (Object)"Topic is blank");
                            continue;
                        }
                        BOssMqttSubscriber newSubscriberNode = new BOssMqttSubscriber();
                        newSubscriberNode.setEnabled(subscriberDialog.getSubscriberEnabled());
                        newSubscriberNode.setDescription(subscriberDialog.getSubscriberDescription());
                        newSubscriberNode.setTopic(subscriberTopic);
                        newSubscriberNode.setSubscriptionQos(subscriberDialog.getSubscriberQos());
                        BMqttEndpointManager.this.getFolderNode().add(SlotPath.escape((String)subscriberName), (BValue)newSubscriberNode);
                        dialogComplete = true;
                        continue;
                    }
                    dialogComplete = true;
                }
                return null;
            }

            public BImage getIcon() {
                return BImage.make((BIcon)BIcon.make((BOrd)BOrd.make((String)"module://ossEasyMqtt/icons/subscriber.png")));
            }
        }
    }

    class Model
    extends FolderModel {
        Model(BFolderManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BMqttEndpointManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BOssMqttSubscriber.TYPE, BOssMqttPublisher.TYPE, BOssMqttFolder.TYPE};
        }

        public Type getFolderType() {
            return BOssMqttFolder.TYPE;
        }
    }
}

