/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.MqttMessageCallback;
import solutions.onesight.ossEasyMqtt.mqtt.MqttMessageQueueEntry;

class MqttPublisherTask
extends Thread {
    private final BOssMqttBroker broker;
    private final MqttAsyncClient client;
    private final BBrokerStatistics stats;
    private final String logPrefix;
    private final long publishWaitTimeout = 10000L;
    private volatile boolean abortPublisherTask = false;
    private LinkedBlockingDeque<MqttMessageQueueEntry> publishQueue;
    private static final long DEFAULT_PUBLISH_WAIT_TIMEOUT = 10000L;
    private static final long RECONNECT_WAIT_PERIOD = 500L;
    private static final Logger log = OssEasyMqttLog.getLog();

    public MqttPublisherTask(BOssMqttBroker newBroker) {
        this.broker = newBroker;
        this.client = this.broker.getMqttClient();
        this.stats = this.broker.getStatistics();
        this.logPrefix = this.broker.getLogPrefix();
    }

    @Override
    public void run() {
        this.setName("OSS-MqttPublisherTask");
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Publish task started");
        }
        try {
            this.publishQueue = new LinkedBlockingDeque(this.broker.getPublishQueueSize());
            while (!this.abortPublisherTask) {
                MqttMessageQueueEntry queueItem = this.publishQueue.take();
                if (queueItem == null) continue;
                if (this.client.isConnected()) {
                    this.publishEntry(queueItem);
                    continue;
                }
                if (!this.publishQueue.offerFirst(queueItem)) {
                    this.stats.incrementTxFailCount();
                }
                while (!this.client.isConnected() && !this.abortPublisherTask) {
                    Thread.sleep(500L);
                }
            }
        }
        catch (InterruptedException queueItem) {
        }
        catch (Exception publisherException) {
            log.severe(this.logPrefix + "Message publisher exception: " + publisherException);
            publisherException.printStackTrace();
        }
        this.publishQueue = null;
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Publish task terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishEntry(MqttMessageQueueEntry queueItem) {
        try {
            MqttPublisherTask mqttPublisherTask = this;
            synchronized (mqttPublisherTask) {
                IMqttDeliveryToken publishToken = this.client.publish(queueItem.getTopic(), queueItem.getMessage(), null, new MqttPublishCallbackHandler(queueItem.getCallback()));
                if (publishToken != null && !this.abortPublisherTask) {
                    try {
                        publishToken.waitForCompletion(10000L);
                        this.stats.newPublishMessage(queueItem.getMessage());
                    }
                    catch (MqttException timeoutException) {
                        publishToken = null;
                    }
                }
                if (publishToken == null && !this.publishQueue.offerFirst(queueItem)) {
                    this.stats.incrementTxFailCount();
                }
            }
        }
        catch (Exception publishException) {
            if (publishException instanceof InterruptedException) {
                return;
            }
            if (publishException.getCause() != null && publishException.getCause() instanceof InterruptedException) {
                return;
            }
            log.severe(this.logPrefix + "Publish exception: " + publishException);
            publishException.printStackTrace();
        }
    }

    public void publish(String topic, MqttMessage message, MqttMessageCallback callback) {
        try {
            if (this.client != null && this.publishQueue != null && !this.abortPublisherTask) {
                if (!this.publishQueue.offer(new MqttMessageQueueEntry(topic, message, callback))) {
                    this.stats.incrementTxDropCount();
                }
                this.stats.updatePublishQueueSize(this.publishQueue.size());
            }
        }
        catch (Exception publishException) {
            log.severe(this.logPrefix + "Publish queue exception: " + publishException);
            publishException.printStackTrace();
        }
    }

    public void terminate() {
        this.abortPublisherTask = true;
        this.interrupt();
    }

    private static class MqttPublishCallbackHandler
    implements IMqttActionListener {
        private final MqttMessageCallback targetCallback;

        public MqttPublishCallbackHandler(MqttMessageCallback newTargetCallback) {
            this.targetCallback = newTargetCallback;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            if (asyncActionToken instanceof MqttDeliveryToken && this.targetCallback != null) {
                this.targetCallback.onSuccess();
            }
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            if (this.targetCallback != null) {
                this.targetCallback.onFailure(exception);
            }
        }
    }
}

