/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.util.logging.Logger;
import javax.baja.sys.BComponent;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerConnectionConfig;
import solutions.onesight.ossEasyMqtt.mqtt.BBrokerStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.BLastWillAndTestament;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttPublisher;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttRouter;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttSubscriber;
import solutions.onesight.ossEasyMqtt.mqtt.BPublishStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.BSubscribeStatistics;

class MqttConnectionTask
extends Thread {
    private final BOssMqttBroker broker;
    private MqttAsyncClient client;
    private final String logPrefix;
    private volatile boolean shutdownConnection = false;
    private final int statisticsUpdatePeriod = 1000;
    private static final Logger log = OssEasyMqttLog.getLog();

    public MqttConnectionTask(BOssMqttBroker newBroker) {
        this.broker = newBroker;
        this.client = newBroker.getMqttClient();
        this.logPrefix = this.broker.getLogPrefix();
    }

    @Override
    public void run() {
        this.shutdownConnection = false;
        this.setName("OSS-MqttConnectionTask");
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Connection task started");
        }
        try {
            this.startSubscribers(this.broker);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception startException) {
            log.severe(this.logPrefix + "Subscribers start exception: " + startException);
            startException.printStackTrace();
        }
        try {
            while (!this.shutdownConnection) {
                this.broker.getStatistics().update();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException startException) {
            // empty catch block
        }
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Connection task shutting down");
        }
        this.shutdownConnection();
        this.client = null;
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Connection task stopping subscribers");
        }
        try {
            this.stopSubscribers(this.broker);
        }
        catch (Exception stopException) {
            log.severe(this.logPrefix + "Subscribers stop exception: " + stopException);
            stopException.printStackTrace();
        }
        if (this.broker.getDebugEnabled()) {
            log.finest(this.logPrefix + "Connection task terminated");
        }
    }

    public void startSubscribers(BComponent currentNode) throws InterruptedException {
        for (BComponent child : currentNode.getChildComponents()) {
            if (this.shutdownConnection) {
                return;
            }
            if (child instanceof BOssMqttSubscriber) {
                Thread.sleep(10L);
                BOssMqttSubscriber subscriber = (BOssMqttSubscriber)child;
                subscriber.startConsumerTask();
                subscriber.topicSubscribe();
                continue;
            }
            if (child instanceof BOssMqttRouter) {
                Thread.sleep(10L);
                BOssMqttRouter router = (BOssMqttRouter)child;
                router.startRouterTask();
                router.subscribeAllTopics();
                continue;
            }
            if (child instanceof BOssMqttPublisher || child instanceof BBrokerConnectionConfig || child instanceof BLastWillAndTestament || child instanceof BBrokerStatistics || child instanceof BSubscribeStatistics || child instanceof BPublishStatistics) continue;
            this.startSubscribers(child);
        }
    }

    public void stopSubscribers(BComponent currentNode) {
        for (BComponent child : currentNode.getChildComponents()) {
            if (child instanceof BOssMqttSubscriber) {
                BOssMqttSubscriber subscriber = (BOssMqttSubscriber)child;
                subscriber.stopConsumerTask();
                continue;
            }
            if (child instanceof BOssMqttPublisher || child instanceof BBrokerConnectionConfig || child instanceof BLastWillAndTestament || child instanceof BBrokerStatistics || child instanceof BSubscribeStatistics || child instanceof BPublishStatistics) continue;
            this.stopSubscribers(child);
        }
    }

    public void shutdownConnection() {
        block8: {
            try {
                if (this.client == null) break block8;
                boolean brokerConnected = this.client.isConnected();
                if (this.broker.getConnection().getConnectionDebug()) {
                    log.finest(this.logPrefix + "Disconnecting (" + brokerConnected + ")");
                }
                try {
                    this.client.disconnectForcibly(3000L, 10000L);
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.broker.getConnection().getConnectionDebug() && brokerConnected) {
                    OssEasyMqttLog.info(this.logPrefix + "Disconnected");
                }
            }
            catch (Exception shutdownException) {
                log.severe(this.logPrefix + "Broker shutdown exception: " + shutdownException);
                shutdownException.printStackTrace();
            }
        }
    }

    public void disconnect() {
        this.shutdownConnection = true;
        this.interrupt();
    }
}

