/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.io.BufferedReader;
import java.io.FileReader;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import solutions.onesight.ossEasyMqtt.file.FileUtils;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BMqttQos;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttPublisher;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttSubscriber;

public class EndpointImporter {
    private final BOssMqttBroker broker;
    private int lineIndex = 0;

    public EndpointImporter(BOssMqttBroker newBroker) {
        this.broker = newBroker;
    }

    public void read(BOrd importFileOrd) {
        if (importFileOrd == null || importFileOrd.isNull()) {
            OssEasyMqttLog.error("Endpoint import file null");
            return;
        }
        OssEasyMqttLog.debug("Import file = " + importFileOrd.encodeToString());
        String importFilePath = FileUtils.getFilePath(importFileOrd);
        if (importFilePath == null) {
            OssEasyMqttLog.error("Endpoint import file invalid");
            return;
        }
        try {
            String fileLine;
            BufferedReader reader = new BufferedReader(new FileReader(importFilePath));
            this.lineIndex = 1;
            while ((fileLine = reader.readLine()) != null) {
                this.processEntry(fileLine);
                ++this.lineIndex;
            }
            reader.close();
        }
        catch (Exception importException) {
            OssEasyMqttLog.debug("Import exception: " + importException);
            importException.printStackTrace();
        }
    }

    public void processEntry(String entryLine) {
        String[] itemList = entryLine.split(",");
        if (itemList[0].trim().equalsIgnoreCase("SUB")) {
            this.createSubscriber(itemList);
        } else if (itemList[0].trim().equalsIgnoreCase("PUB")) {
            this.createPublisher(itemList);
        } else {
            OssEasyMqttLog.error("Endpoint import file line " + this.lineIndex + " invalid");
        }
    }

    public void createSubscriber(String[] itemList) {
        if (itemList.length < 4) {
            return;
        }
        BOssMqttSubscriber newSubscriber = new BOssMqttSubscriber();
        try {
            newSubscriber.setTopic(itemList[3].trim());
            if (itemList.length > 4) {
                newSubscriber.setSubscriptionQos(BMqttQos.make(Integer.parseInt(itemList[4].trim())));
                if (itemList.length > 5) {
                    newSubscriber.setRetained(Boolean.parseBoolean(itemList[5].trim()));
                    if (itemList.length > 6) {
                        newSubscriber.setEnabled(Boolean.parseBoolean(itemList[6].trim()));
                        if (itemList.length > 7) {
                            newSubscriber.setDescription(itemList[7].trim());
                        }
                    }
                }
            }
        }
        catch (Exception conversionException) {
            OssEasyMqttLog.error("Endpoint import file line " + this.lineIndex + " exception");
            conversionException.printStackTrace();
        }
        this.addComponent(itemList[2].trim(), newSubscriber, itemList[1].trim());
    }

    public void createPublisher(String[] itemList) {
        if (itemList.length < 4) {
            return;
        }
        BOssMqttPublisher newPublisher = new BOssMqttPublisher();
        try {
            newPublisher.setTopic(itemList[3].trim());
            if (itemList.length > 4) {
                newPublisher.setQos(BMqttQos.make(Integer.parseInt(itemList[4].trim())));
                if (itemList.length > 5) {
                    newPublisher.setRetained(Boolean.parseBoolean(itemList[5].trim()));
                    if (itemList.length > 6) {
                        newPublisher.setEnabled(Boolean.parseBoolean(itemList[6].trim()));
                        if (itemList.length > 7) {
                            newPublisher.setDescription(itemList[7].trim());
                            if (itemList.length > 8) {
                                newPublisher.setPublishOnChange(Boolean.parseBoolean(itemList[8].trim()));
                                if (itemList.length > 9) {
                                    newPublisher.setIgnoreEmptyMessages(Boolean.parseBoolean(itemList[9].trim()));
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception conversionException) {
            OssEasyMqttLog.error("Endpoint import file line " + this.lineIndex + " exception");
            conversionException.printStackTrace();
        }
        this.addComponent(itemList[2].trim(), newPublisher, itemList[1].trim());
    }

    public void addComponent(String path, BComponent component, String displayName) {
        path = path.replaceAll("//", "/");
        String[] pathList = path.split("/");
        BOssMqttBroker currentNode = this.broker;
        for (int segmentIndex = 0; segmentIndex < pathList.length; ++segmentIndex) {
            String segmentStr = pathList[segmentIndex].trim();
            if (segmentIndex < pathList.length - 1) {
                if (segmentStr.isEmpty()) continue;
                if (currentNode.get(segmentStr) == null) {
                    BFolder newNode = new BFolder();
                    currentNode.add(segmentStr, (BValue)newNode);
                    currentNode = newNode;
                    continue;
                }
                if (currentNode.get(segmentStr) instanceof BComponent) {
                    currentNode = (BComponent)currentNode.get(segmentStr);
                    continue;
                }
                OssEasyMqttLog.error("Endpoint path invalid - invalid node");
                break;
            }
            if (segmentStr.isEmpty()) {
                OssEasyMqttLog.error("Endpoint path invalid - node name null");
                break;
            }
            if (currentNode.get(segmentStr) != null) continue;
            currentNode.add(segmentStr, (BValue)component);
            if (displayName.equals(segmentStr)) {
                OssEasyMqttLog.debug("Add endpoint: " + path);
                continue;
            }
            OssEasyMqttLog.debug("Add endpoint: " + path + " > " + displayName);
            currentNode.setDisplayName(currentNode.getProperty(segmentStr), BFormat.make((String)displayName), null);
        }
    }
}

