/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.util.BFolder;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttPublisher;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttSubscriber;

public class EndpointExporter {
    private final BOssMqttBroker broker;
    private String brokerPath;
    private int endpointCount = 0;

    public EndpointExporter(BOssMqttBroker newBroker) {
        this.broker = newBroker;
    }

    public void write() {
        GregorianCalendar currentTime = new GregorianCalendar();
        currentTime.setTime(new Date());
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setGroupingUsed(false);
        formatter.setMinimumIntegerDigits(2);
        String fileName = "mqtt-" + this.broker.getName() + "-" + formatter.format(currentTime.get(1)) + "-" + formatter.format(currentTime.get(2) + 1) + "-" + formatter.format(currentTime.get(5)) + "-" + formatter.format(currentTime.get(11)) + "-" + formatter.format(currentTime.get(12)) + ".csv";
        String filePath = Sys.getStationHome().toString() + "/" + fileName;
        OssEasyMqttLog.debug("Export file = " + fileName);
        this.brokerPath = this.broker.toPathString() + "/";
        this.endpointCount = 0;
        try {
            FileWriter outputWriter = new FileWriter(filePath);
            this.traverseEndpoints(this.broker, outputWriter);
            outputWriter.close();
        }
        catch (Exception exportException) {
            OssEasyMqttLog.debug("Export exception: " + exportException);
            exportException.printStackTrace();
        }
    }

    public void traverseEndpoints(BComponent current, FileWriter outputWriter) throws IOException {
        if (current instanceof BOssMqttPublisher) {
            BOssMqttPublisher publisher = (BOssMqttPublisher)current;
            String endpointPath = this.getEndpointPath(publisher);
            String publisherEntry = "pub, " + publisher.getDisplayName(null) + ", " + endpointPath + ", " + publisher.getTopic() + ", " + publisher.getQos().getOrdinal() + ", " + publisher.getRetained() + ", " + publisher.getEnabled() + ", " + publisher.getDescription() + ", " + publisher.getPublishOnChange() + ", " + publisher.getIgnoreEmptyMessages() + "\n";
            outputWriter.write(publisherEntry);
            ++this.endpointCount;
        } else if (current instanceof BOssMqttSubscriber) {
            BOssMqttSubscriber subscriber = (BOssMqttSubscriber)current;
            String endpointPath = this.getEndpointPath(subscriber);
            String subscriberEntry = "sub, " + subscriber.getDisplayName(null) + ", " + endpointPath + ", " + subscriber.getTopic() + ", " + subscriber.getSubscriptionQos().getOrdinal() + ", " + subscriber.getRetained() + ", " + subscriber.getEnabled() + ", " + subscriber.getDescription() + "\n";
            outputWriter.write(subscriberEntry);
            ++this.endpointCount;
        } else if (current instanceof BOssMqttBroker || current instanceof BFolder) {
            for (BComponent child : current.getChildComponents()) {
                this.traverseEndpoints(child, outputWriter);
            }
        }
    }

    public String getEndpointPath(BComponent endpoint) {
        String path = endpoint.toPathString();
        path = path.startsWith(this.brokerPath) ? path.substring(this.brokerPath.length()) : endpoint.getName();
        return path;
    }
}

