/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BAbsTime", defaultValue="BAbsTime.now()", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastReceiveTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="receiveMessageCount", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="receiveMessageRate", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"messageRate\", \"messages/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveTotalBytes", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="receiveDataRate", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"dataRate\", \"bytes/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveMinSize", type="int", defaultValue="-1", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="receiveMaxSize", type="int", defaultValue="0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="maxReceiveQueueSize", type="int", defaultValue="0", flags=65541)})
@NiagaraAction(name="reset")
public class BSubscribeStatistics
extends BComponent {
    public static final Property startTime = BSubscribeStatistics.newProperty((int)65537, (BValue)BAbsTime.now(), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastReceiveTime = BSubscribeStatistics.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property receiveMessageCount = BSubscribeStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property receiveMessageRate = BSubscribeStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"messageRate", (String)"messages/second", (BDimension)BDimension.NULL))));
    public static final Property receiveTotalBytes = BSubscribeStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property receiveDataRate = BSubscribeStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"dataRate", (String)"bytes/second", (BDimension)BDimension.NULL))));
    public static final Property receiveMinSize = BSubscribeStatistics.newProperty((int)65537, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property receiveMaxSize = BSubscribeStatistics.newProperty((int)65537, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property maxReceiveQueueSize = BSubscribeStatistics.newProperty((int)65541, (int)0, null);
    public static final Action reset = BSubscribeStatistics.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSubscribeStatistics.class);

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getLastReceiveTime() {
        return (BAbsTime)this.get(lastReceiveTime);
    }

    public void setLastReceiveTime(BAbsTime v) {
        this.set(lastReceiveTime, (BValue)v, null);
    }

    public double getReceiveMessageCount() {
        return this.getDouble(receiveMessageCount);
    }

    public void setReceiveMessageCount(double v) {
        this.setDouble(receiveMessageCount, v, null);
    }

    public double getReceiveMessageRate() {
        return this.getDouble(receiveMessageRate);
    }

    public void setReceiveMessageRate(double v) {
        this.setDouble(receiveMessageRate, v, null);
    }

    public double getReceiveTotalBytes() {
        return this.getDouble(receiveTotalBytes);
    }

    public void setReceiveTotalBytes(double v) {
        this.setDouble(receiveTotalBytes, v, null);
    }

    public double getReceiveDataRate() {
        return this.getDouble(receiveDataRate);
    }

    public void setReceiveDataRate(double v) {
        this.setDouble(receiveDataRate, v, null);
    }

    public int getReceiveMinSize() {
        return this.getInt(receiveMinSize);
    }

    public void setReceiveMinSize(int v) {
        this.setInt(receiveMinSize, v, null);
    }

    public int getReceiveMaxSize() {
        return this.getInt(receiveMaxSize);
    }

    public void setReceiveMaxSize(int v) {
        this.setInt(receiveMaxSize, v, null);
    }

    public int getMaxReceiveQueueSize() {
        return this.getInt(maxReceiveQueueSize);
    }

    public void setMaxReceiveQueueSize(int v) {
        this.setInt(maxReceiveQueueSize, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void newSubscribeMessage(MqttMessage message) {
        long seconds;
        int size = message.getPayload().length;
        this.setReceiveMessageCount(this.getReceiveMessageCount() + 1.0);
        this.setReceiveTotalBytes(this.getReceiveTotalBytes() + (double)size);
        this.setLastReceiveTime(BAbsTime.now());
        if (this.getReceiveMinSize() < 0) {
            this.setReceiveMinSize(size);
        } else if (size < this.getReceiveMinSize()) {
            this.setReceiveMinSize(size);
        }
        if (size > this.getReceiveMaxSize()) {
            this.setReceiveMaxSize(size);
        }
        if ((seconds = (System.currentTimeMillis() - this.getStartTime().getMillis()) / 1000L) > 0L) {
            this.setReceiveMessageRate(this.getReceiveMessageCount() / (double)seconds);
            this.setReceiveDataRate(this.getReceiveTotalBytes() / (double)seconds);
        } else {
            this.setReceiveMessageRate(0.0);
            this.setReceiveDataRate(0.0);
        }
    }

    public void updateQueueSize(int newQueueSize) {
        if (newQueueSize > this.getMaxReceiveQueueSize()) {
            this.setMaxReceiveQueueSize(newQueueSize);
        }
    }

    public void doReset() {
        this.setReceiveMessageCount(0.0);
        this.setReceiveMessageRate(0.0);
        this.setReceiveTotalBytes(0.0);
        this.setStartTime(BAbsTime.now());
        this.setLastReceiveTime(BAbsTime.NULL);
        this.setReceiveDataRate(0.0);
        this.setReceiveMinSize(-1);
        this.setReceiveMaxSize(0);
        this.setMaxReceiveQueueSize(0);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/statistics.png");
    }
}

