/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import org.eclipse.paho.client.mqttv3.MqttMessage;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="startTime", type="BAbsTime", defaultValue="BAbsTime.now()", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="lastPublishTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65537, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="publishMessageCount", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( 0 )")}), @NiagaraProperty(name="publishMessageRate", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"messageRate\", \"messages/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishTotalBytes", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.makeNumeric( BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ), 0 )")}), @NiagaraProperty(name="publishDataRate", type="double", defaultValue="0.0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"dataRate\", \"bytes/second\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishMinSize", type="int", defaultValue="-1", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")}), @NiagaraProperty(name="publishMaxSize", type="int", defaultValue="0", flags=65537, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(25)"), @Facet(value="BFacets.make( BFacets.UNITS, BUnit.make( \"bytes\", \"bytes\", BDimension.NULL ) )")})})
@NiagaraAction(name="reset")
public class BPublishStatistics
extends BComponent {
    public static final Property startTime = BPublishStatistics.newProperty((int)65537, (BValue)BAbsTime.now(), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property lastPublishTime = BPublishStatistics.newProperty((int)65537, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property publishMessageCount = BPublishStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((int)0)));
    public static final Property publishMessageRate = BPublishStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"messageRate", (String)"messages/second", (BDimension)BDimension.NULL))));
    public static final Property publishTotalBytes = BPublishStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.makeNumeric((BUnit)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL), (int)0)));
    public static final Property publishDataRate = BPublishStatistics.newProperty((int)65537, (double)0.0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"dataRate", (String)"bytes/second", (BDimension)BDimension.NULL))));
    public static final Property publishMinSize = BPublishStatistics.newProperty((int)65537, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Property publishMaxSize = BPublishStatistics.newProperty((int)65537, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)25)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"bytes", (String)"bytes", (BDimension)BDimension.NULL))));
    public static final Action reset = BPublishStatistics.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPublishStatistics.class);

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getLastPublishTime() {
        return (BAbsTime)this.get(lastPublishTime);
    }

    public void setLastPublishTime(BAbsTime v) {
        this.set(lastPublishTime, (BValue)v, null);
    }

    public double getPublishMessageCount() {
        return this.getDouble(publishMessageCount);
    }

    public void setPublishMessageCount(double v) {
        this.setDouble(publishMessageCount, v, null);
    }

    public double getPublishMessageRate() {
        return this.getDouble(publishMessageRate);
    }

    public void setPublishMessageRate(double v) {
        this.setDouble(publishMessageRate, v, null);
    }

    public double getPublishTotalBytes() {
        return this.getDouble(publishTotalBytes);
    }

    public void setPublishTotalBytes(double v) {
        this.setDouble(publishTotalBytes, v, null);
    }

    public double getPublishDataRate() {
        return this.getDouble(publishDataRate);
    }

    public void setPublishDataRate(double v) {
        this.setDouble(publishDataRate, v, null);
    }

    public int getPublishMinSize() {
        return this.getInt(publishMinSize);
    }

    public void setPublishMinSize(int v) {
        this.setInt(publishMinSize, v, null);
    }

    public int getPublishMaxSize() {
        return this.getInt(publishMaxSize);
    }

    public void setPublishMaxSize(int v) {
        this.setInt(publishMaxSize, v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void newPublishMessage(MqttMessage message) {
        long seconds;
        int size = message.getPayload().length;
        this.setPublishMessageCount(this.getPublishMessageCount() + 1.0);
        this.setPublishTotalBytes(this.getPublishTotalBytes() + (double)size);
        this.setLastPublishTime(BAbsTime.now());
        if (this.getPublishMinSize() < 0) {
            this.setPublishMinSize(size);
        } else if (size < this.getPublishMinSize()) {
            this.setPublishMinSize(size);
        }
        if (size > this.getPublishMaxSize()) {
            this.setPublishMaxSize(size);
        }
        if ((seconds = (System.currentTimeMillis() - this.getStartTime().getMillis()) / 1000L) > 0L) {
            this.setPublishMessageRate(this.getPublishMessageCount() / (double)seconds);
            this.setPublishDataRate(this.getPublishTotalBytes() / (double)seconds);
        } else {
            this.setPublishMessageRate(0.0);
            this.setPublishDataRate(0.0);
        }
    }

    public void doReset() {
        this.setPublishMessageCount(0.0);
        this.setPublishMessageRate(0.0);
        this.setPublishTotalBytes(0.0);
        this.setStartTime(BAbsTime.now());
        this.setLastPublishTime(BAbsTime.NULL);
        this.setPublishDataRate(0.0);
        this.setPublishMinSize(-1);
        this.setPublishMaxSize(0);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/statistics.png");
    }
}

