/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BMqttQos;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;
import solutions.onesight.ossEasyMqtt.mqtt.BSubscribeStatistics;
import solutions.onesight.ossEasyMqtt.mqtt.MqttMessageQueueEntry;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=67, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="topic", type="String", defaultValue="", flags=8, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make(60)")}), @NiagaraProperty(name="subscriptionQos", type="BMqttQos", defaultValue="BMqttQos.AtMostOnce"), @NiagaraProperty(name="subscribed", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="messageOut", type="String", defaultValue="", flags=9, facets={@Facet(name="BFacets.FIELD_WIDTH", value="BInteger.make( 70 )")}), @NiagaraProperty(name="messageSize", type="int", defaultValue="0", flags=65537), @NiagaraProperty(name="receivedQos", type="BMqttQos", defaultValue="BMqttQos.AtMostOnce", flags=65537), @NiagaraProperty(name="retained", type="boolean", defaultValue="false", flags=65537), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65545, facets={@Facet(name="BFacets.SHOW_SECONDS", value="BBoolean.make(true)")}), @NiagaraProperty(name="statistics", type="BSubscribeStatistics", defaultValue="new BSubscribeStatistics()", flags=65541), @NiagaraProperty(name="summaryFormat", type="BFormat", defaultValue="BFormat.make( \"%topic%\" )", flags=4), @NiagaraProperty(name="debugEnabled", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="debugDataEnabled", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="subscribe"), @NiagaraAction(name="unsubscribe"), @NiagaraAction(name="reset")})
@NiagaraTopic(name="updated", eventType="BBoolean")
public class BOssMqttSubscriber
extends BComponent {
    public static final Property enabled = BOssMqttSubscriber.newProperty((int)0, (boolean)true, null);
    public static final Property status = BOssMqttSubscriber.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOssMqttSubscriber.newProperty((int)67, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property description = BOssMqttSubscriber.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property topic = BOssMqttSubscriber.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)60)));
    public static final Property subscriptionQos = BOssMqttSubscriber.newProperty((int)0, (BValue)BMqttQos.AtMostOnce, null);
    public static final Property subscribed = BOssMqttSubscriber.newProperty((int)1, (boolean)false, null);
    public static final Property messageOut = BOssMqttSubscriber.newProperty((int)9, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)70)));
    public static final Property messageSize = BOssMqttSubscriber.newProperty((int)65537, (int)0, null);
    public static final Property receivedQos = BOssMqttSubscriber.newProperty((int)65537, (BValue)BMqttQos.AtMostOnce, null);
    public static final Property retained = BOssMqttSubscriber.newProperty((int)65537, (boolean)false, null);
    public static final Property lastUpdate = BOssMqttSubscriber.newProperty((int)65545, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property statistics = BOssMqttSubscriber.newProperty((int)65541, (BValue)new BSubscribeStatistics(), null);
    public static final Property summaryFormat = BOssMqttSubscriber.newProperty((int)4, (BValue)BFormat.make((String)"%topic%"), null);
    public static final Property debugEnabled = BOssMqttSubscriber.newProperty((int)4, (boolean)false, null);
    public static final Property debugDataEnabled = BOssMqttSubscriber.newProperty((int)4, (boolean)false, null);
    public static final Action subscribe = BOssMqttSubscriber.newAction((int)0, null);
    public static final Action unsubscribe = BOssMqttSubscriber.newAction((int)0, null);
    public static final Action reset = BOssMqttSubscriber.newAction((int)0, null);
    public static final Topic updated = BOssMqttSubscriber.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssMqttSubscriber.class);
    private BOssMqttBroker broker = null;
    private MqttConsumerTask consumerTask;
    private volatile boolean abortConsumerTask = false;
    private String lastTopicSubscribed = null;
    private int maxQueueSize = 0;
    private String logPrefix = "null";
    private final LinkedBlockingQueue<MqttMessageQueueEntry> receiveQueue = new LinkedBlockingQueue(20);
    private final MqttSubscriptionCallbackHandler callbackHandler = new MqttSubscriptionCallbackHandler();
    public static final int SUBSCRIBE_MESSAGE_QUEUE_SIZE = 20;
    private static final Logger log = OssEasyMqttLog.getLog();

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getTopic() {
        return this.getString(topic);
    }

    public void setTopic(String v) {
        this.setString(topic, v, null);
    }

    public BMqttQos getSubscriptionQos() {
        return (BMqttQos)this.get(subscriptionQos);
    }

    public void setSubscriptionQos(BMqttQos v) {
        this.set(subscriptionQos, (BValue)v, null);
    }

    public boolean getSubscribed() {
        return this.getBoolean(subscribed);
    }

    public void setSubscribed(boolean v) {
        this.setBoolean(subscribed, v, null);
    }

    public String getMessageOut() {
        return this.getString(messageOut);
    }

    public void setMessageOut(String v) {
        this.setString(messageOut, v, null);
    }

    public int getMessageSize() {
        return this.getInt(messageSize);
    }

    public void setMessageSize(int v) {
        this.setInt(messageSize, v, null);
    }

    public BMqttQos getReceivedQos() {
        return (BMqttQos)this.get(receivedQos);
    }

    public void setReceivedQos(BMqttQos v) {
        this.set(receivedQos, (BValue)v, null);
    }

    public boolean getRetained() {
        return this.getBoolean(retained);
    }

    public void setRetained(boolean v) {
        this.setBoolean(retained, v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public BSubscribeStatistics getStatistics() {
        return (BSubscribeStatistics)this.get(statistics);
    }

    public void setStatistics(BSubscribeStatistics v) {
        this.set(statistics, (BValue)v, null);
    }

    public BFormat getSummaryFormat() {
        return (BFormat)this.get(summaryFormat);
    }

    public void setSummaryFormat(BFormat v) {
        this.set(summaryFormat, (BValue)v, null);
    }

    public boolean getDebugEnabled() {
        return this.getBoolean(debugEnabled);
    }

    public void setDebugEnabled(boolean v) {
        this.setBoolean(debugEnabled, v, null);
    }

    public boolean getDebugDataEnabled() {
        return this.getBoolean(debugDataEnabled);
    }

    public void setDebugDataEnabled(boolean v) {
        this.setBoolean(debugDataEnabled, v, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public void unsubscribe() {
        this.invoke(unsubscribe, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void fireUpdated(BBoolean event) {
        this.fire(updated, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.abortConsumerTask = false;
        this.receiveQueue.clear();
        this.maxQueueSize = 0;
        this.broker = BOssMqttBroker.findBroker(this);
        if (this.broker == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid parent");
            log.severe("MqttSubscriber [" + this.getSlotPath() + "] should be placed in a MqttBroker");
            throw new BajaRuntimeException("Invalid parent");
        }
        if (this.getEnabled()) {
            this.setStatus(BStatus.ok);
        } else {
            this.setStatus(BStatus.disabled);
        }
        this.setFaultCause("");
        this.setSubscribed(false);
        this.logPrefix = this.broker.getLogPrefix();
        this.startConsumerTask();
    }

    public void stopped() {
        this.topicUnsubscribe();
        this.stopConsumerTask();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (this.broker == null) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() & 0xFFFFFFFE)));
                this.topicSubscribe();
            } else {
                this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 1)));
                this.topicUnsubscribe();
            }
        } else if (property == topic) {
            if (this.lastTopicSubscribed != null) {
                this.broker.unsubscribe(this.lastTopicSubscribed);
            }
            if (this.getSubscribed()) {
                this.topicSubscribe();
            }
        }
    }

    public void topicSubscribe() {
        if (this.broker != null && this.getEnabled() && this.isSubscribeTopicValid(this.getTopic())) {
            this.processSubscription();
        } else {
            this.setSubscribed(false);
        }
    }

    public void topicUnsubscribe() {
        if (!this.getTopic().isEmpty() && this.broker != null) {
            if (this.lastTopicSubscribed != null) {
                this.broker.unsubscribe(this.lastTopicSubscribed);
                log.finest(this.logPrefix + "Unsubscribed topic: " + this.lastTopicSubscribed);
            }
            this.setSubscribed(false);
        }
    }

    public void processSubscription() {
        IMqttToken subscribeToken = this.broker.subscribe(this.getTopic(), this.getSubscriptionQos().getOrdinal(), this.callbackHandler, this.callbackHandler);
        if (subscribeToken != null) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
            this.setSubscribed(true);
            this.lastTopicSubscribed = this.getTopic();
        } else {
            this.setStatus(BStatus.stale);
            this.setFaultCause("");
        }
    }

    public void updateValue(String topic, MqttMessage message) {
        if (this.getEnabled()) {
            int size = message.getPayload().length;
            this.setLastUpdate(BAbsTime.now());
            this.setMessageOut(new String(message.getPayload()));
            this.setMessageSize(size);
            this.setReceivedQos(BMqttQos.make(message.getQos()));
            this.setRetained(message.isRetained());
            this.fireUpdated(BBoolean.TRUE);
            if (this.broker != null) {
                this.getStatistics().newSubscribeMessage(message);
                this.broker.newSubscribeMessage(topic, message);
            }
            this.getStatistics().updateQueueSize(this.maxQueueSize);
            if (this.getDebugDataEnabled()) {
                log.finest(this.logPrefix + "Received [" + topic + "]: " + size + " bytes");
            }
        }
    }

    public boolean isSubscribeTopicValid(String topicStr) {
        try {
            boolean topicInvalid = false;
            if (topicStr.isEmpty()) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid blank topic");
                log.severe(this.logPrefix + "Subscription has invalid blank topic");
                return false;
            }
            int length = topicStr.length();
            if (topicStr.matches(".*//.*")) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid null topic level");
                log.severe(this.logPrefix + "Subscription has invalid null topic level");
                return false;
            }
            int hashIndex = topicStr.indexOf(35);
            if (hashIndex >= 0 && (hashIndex != length - 1 || length > 1 && !topicStr.substring(length - 2).equals("/#"))) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid topic wildcard (#)");
                log.severe(this.logPrefix + "Subscription has invalid use of topic multi-level wildcard (#)");
                return false;
            }
            int plusIndex = topicStr.indexOf(43);
            if (plusIndex >= 0) {
                while (plusIndex >= 0) {
                    if (plusIndex == 0) {
                        if (length > 1 && !topicStr.startsWith("+/", plusIndex)) {
                            topicInvalid = true;
                        }
                    } else if (length > plusIndex + 1) {
                        if (!topicStr.substring(plusIndex - 1, plusIndex + 2).equals("/+/")) {
                            topicInvalid = true;
                        }
                    } else if (!topicStr.substring(plusIndex - 1, plusIndex + 1).equals("/+")) {
                        topicInvalid = true;
                    }
                    if (topicInvalid) {
                        this.setStatus(BStatus.fault);
                        this.setFaultCause("Invalid topic wildcard (+)");
                        log.severe(this.logPrefix + "Subscription has invalid use of topic single-level wildcard (+)");
                        return false;
                    }
                    plusIndex = topicStr.indexOf(43, plusIndex + 1);
                }
            }
        }
        catch (Exception checkException) {
            checkException.printStackTrace();
        }
        return true;
    }

    public static void subscribeAll(BComponent parent) {
        for (BOssMqttSubscriber bOssMqttSubscriber : (BOssMqttSubscriber[])parent.getChildren(BOssMqttSubscriber.class)) {
            bOssMqttSubscriber.topicSubscribe();
        }
        for (BOssMqttSubscriber bOssMqttSubscriber : (BFolder[])parent.getChildren(BFolder.class)) {
            BOssMqttSubscriber.subscribeAll(bOssMqttSubscriber);
        }
    }

    public static void unsubscribeAll(BComponent parent) {
        for (BOssMqttSubscriber bOssMqttSubscriber : (BOssMqttSubscriber[])parent.getChildren(BOssMqttSubscriber.class)) {
            bOssMqttSubscriber.topicUnsubscribe();
        }
        for (BOssMqttSubscriber bOssMqttSubscriber : (BFolder[])parent.getChildren(BFolder.class)) {
            BOssMqttSubscriber.unsubscribeAll(bOssMqttSubscriber);
        }
    }

    public void doSubscribe() {
        this.topicSubscribe();
    }

    public void doUnsubscribe() {
        this.topicUnsubscribe();
    }

    public void doReset() {
        this.setMessageOut("");
        this.setLastUpdate(BAbsTime.NULL);
        this.setMessageSize(0);
    }

    public synchronized void startConsumerTask() {
        if (this.consumerTask == null || !this.consumerTask.isAlive()) {
            this.abortConsumerTask = false;
            this.consumerTask = new MqttConsumerTask();
            this.consumerTask.start();
        }
    }

    public synchronized void stopConsumerTask() {
        this.abortConsumerTask = true;
        if (this.consumerTask != null) {
            this.consumerTask.interrupt();
        }
        this.consumerTask = null;
    }

    public String toString(Context cxt) {
        return this.getSummaryFormat().format((Object)this);
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/subscriber.png");
    }

    private class MqttConsumerTask
    extends Thread {
        private MqttConsumerTask() {
        }

        @Override
        public void run() {
            BOssMqttSubscriber.this.abortConsumerTask = false;
            this.setName("OSS-MqttConsumerTask");
            String consumerName = SlotPath.unescape((String)BOssMqttSubscriber.this.getName());
            if (BOssMqttSubscriber.this.getDebugEnabled()) {
                log.finest(BOssMqttSubscriber.this.logPrefix + "Consumer task [" + consumerName + "] started");
            }
            try {
                while (!BOssMqttSubscriber.this.abortConsumerTask) {
                    this.consumeEntry((MqttMessageQueueEntry)BOssMqttSubscriber.this.receiveQueue.take());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception consumerException) {
                log.severe(BOssMqttSubscriber.this.logPrefix + "Message consumer exception: " + consumerException);
                consumerException.printStackTrace();
            }
            if (BOssMqttSubscriber.this.getDebugEnabled()) {
                log.finest(BOssMqttSubscriber.this.logPrefix + "Consumer task [" + consumerName + "] terminated");
            }
        }

        void consumeEntry(MqttMessageQueueEntry queueItem) {
            if (queueItem != null) {
                BOssMqttSubscriber.this.updateValue(queueItem.getTopic(), queueItem.getMessage());
            }
        }
    }

    private class MqttSubscriptionCallbackHandler
    implements IMqttActionListener,
    IMqttMessageListener {
        private MqttSubscriptionCallbackHandler() {
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            BOssMqttSubscriber.this.setStatus(BStatus.ok);
            BOssMqttSubscriber.this.setFaultCause("");
            if (BOssMqttSubscriber.this.getDebugEnabled()) {
                log.finest(BOssMqttSubscriber.this.logPrefix + "Subscribe succeeded for topic: " + BOssMqttSubscriber.this.getTopic());
            }
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            BOssMqttSubscriber.this.setStatus(BStatus.make((int)(BOssMqttSubscriber.this.getStatus().getBits() | 2)));
            BOssMqttSubscriber.this.setFaultCause("Subscribe failed: " + exception.getCause());
            log.severe(BOssMqttSubscriber.this.logPrefix + "Subscribe failed for topic: " + BOssMqttSubscriber.this.getTopic());
            if (BOssMqttSubscriber.this.getDebugEnabled()) {
                exception.printStackTrace();
            }
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) {
            if (BOssMqttSubscriber.this.getEnabled() && topic != null && message != null) {
                try {
                    if (!BOssMqttSubscriber.this.receiveQueue.offer(new MqttMessageQueueEntry(topic, message, null)) && BOssMqttSubscriber.this.broker != null) {
                        BOssMqttSubscriber.this.broker.droppedRxMessage();
                    }
                    if (BOssMqttSubscriber.this.receiveQueue.size() > BOssMqttSubscriber.this.maxQueueSize) {
                        BOssMqttSubscriber.this.maxQueueSize = BOssMqttSubscriber.this.receiveQueue.size();
                    }
                }
                catch (Exception queueException) {
                    queueException.printStackTrace();
                }
            }
        }
    }
}

