/*
 * Decompiled with CFR 0.152.
 */
package solutions.onesight.ossEasyMqtt.mqtt;

import javax.baja.driver.BDriverContainer;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import solutions.onesight.ossEasyMqtt.license.OssEasyMqttLicense;
import solutions.onesight.ossEasyMqtt.log.OssEasyMqttLog;
import solutions.onesight.ossEasyMqtt.mqtt.BOssMqttBroker;

@NiagaraType
@NiagaraAction(name="addBroker")
public class BOssMqttService
extends BAbstractService {
    public static final Action addBroker = BOssMqttService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOssMqttService.class);
    private boolean serviceValid = false;
    private static final Type[] serviceTypes = new Type[]{TYPE};

    public void addBroker() {
        this.invoke(addBroker, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)enabled, 5);
        this.serviceValid = false;
        if (!OssEasyMqttLicense.checkLicense()) {
            this.configFail("ossEasyMQTT licence fault");
            throw new FeatureNotLicensedException("ossEasyMQTT");
        }
        if (!(this.getParent() instanceof BServiceContainer) && !(this.getParent() instanceof BDriverContainer)) {
            this.configFail("Invalid service parent");
            OssEasyMqttLog.error("OssMqttService must be placed in the services or drivers containers");
            throw new BajaRuntimeException("Invalid OssMqttService parent");
        }
        this.serviceValid = true;
        this.configOk();
    }

    public void doAddBroker() {
        this.add("MqttBroker1?", (BValue)new BOssMqttBroker());
    }

    public boolean isServiceValid() {
        return this.serviceValid;
    }

    public BIcon getIcon() {
        return BIcon.make((String)"module://ossEasyMqtt/icons/oss-icon-16.png");
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }
}

